/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.BooleanOperator;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.exec.store.kafka.KafkaGroupScan;
import org.apache.drill.exec.store.kafka.KafkaNodeProcessor;
import org.apache.drill.exec.store.kafka.KafkaPartitionScanSpec;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;

public class KafkaPartitionScanSpecBuilder
extends AbstractExprVisitor<List<KafkaPartitionScanSpec>, Void, RuntimeException>
implements AutoCloseable {
    private final LogicalExpression le;
    private final KafkaGroupScan groupScan;
    private final KafkaConsumer<?, ?> kafkaConsumer;
    private ImmutableMap<TopicPartition, KafkaPartitionScanSpec> fullScanSpec;

    public KafkaPartitionScanSpecBuilder(KafkaGroupScan groupScan, LogicalExpression conditionExp) {
        this.groupScan = groupScan;
        this.kafkaConsumer = new KafkaConsumer(groupScan.getKafkaStoragePluginConfig().getKafkaConsumerProps(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.le = conditionExp;
    }

    public List<KafkaPartitionScanSpec> parseTree() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (KafkaPartitionScanSpec scanSpec : this.groupScan.getPartitionScanSpecList()) {
            builder.put((Object)new TopicPartition(scanSpec.getTopicName(), scanSpec.getPartitionId()), (Object)scanSpec);
        }
        this.fullScanSpec = builder.build();
        List pushdownSpec = (List)this.le.accept((ExprVisitor)this, null);
        if (pushdownSpec != null && pushdownSpec.isEmpty()) {
            TopicPartition firstPartition = new TopicPartition(this.groupScan.getKafkaScanSpec().getTopicName(), 0);
            KafkaPartitionScanSpec emptySpec = new KafkaPartitionScanSpec(firstPartition.topic(), firstPartition.partition(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)firstPartition)).getEndOffset(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)firstPartition)).getEndOffset());
            pushdownSpec.add(emptySpec);
        }
        return pushdownSpec;
    }

    public List<KafkaPartitionScanSpec> visitUnknown(LogicalExpression e, Void value) {
        return null;
    }

    public List<KafkaPartitionScanSpec> visitBooleanOperator(BooleanOperator op, Void value) {
        HashMap specMap = Maps.newHashMap();
        List args = op.args();
        if (op.getName().equals("booleanOr")) {
            for (LogicalExpression expr : args) {
                List parsedSpec = (List)expr.accept((ExprVisitor)this, null);
                if (parsedSpec != null) {
                    for (KafkaPartitionScanSpec newSpec : parsedSpec) {
                        TopicPartition tp = new TopicPartition(newSpec.getTopicName(), newSpec.getPartitionId());
                        KafkaPartitionScanSpec existingSpec = (KafkaPartitionScanSpec)specMap.get(tp);
                        if (existingSpec == null) {
                            specMap.put(tp, newSpec);
                            continue;
                        }
                        existingSpec.mergeScanSpec(op.getName(), newSpec);
                        specMap.put(tp, existingSpec);
                    }
                    continue;
                }
                return null;
            }
        } else {
            specMap.putAll(this.fullScanSpec);
            for (LogicalExpression expr : args) {
                List parsedSpec = (List)expr.accept((ExprVisitor)this, null);
                if (parsedSpec == null) continue;
                HashSet partitionsInNewSpec = Sets.newHashSet();
                for (KafkaPartitionScanSpec newSpec : parsedSpec) {
                    TopicPartition tp = new TopicPartition(newSpec.getTopicName(), newSpec.getPartitionId());
                    partitionsInNewSpec.add(tp);
                    KafkaPartitionScanSpec existingSpec = (KafkaPartitionScanSpec)specMap.get(tp);
                    if (existingSpec == null) continue;
                    existingSpec.mergeScanSpec(op.getName(), newSpec);
                    specMap.put(tp, existingSpec);
                }
                specMap.keySet().removeIf(partition -> !partitionsInNewSpec.contains(partition));
            }
        }
        return Lists.newArrayList(specMap.values());
    }

    public List<KafkaPartitionScanSpec> visitFunctionCall(FunctionCall call, Void value) {
        KafkaNodeProcessor kafkaNodeProcessor;
        String functionName = call.getName();
        if (KafkaNodeProcessor.isPushdownFunction(functionName) && (kafkaNodeProcessor = KafkaNodeProcessor.process(call)).isSuccess()) {
            switch (kafkaNodeProcessor.getPath()) {
                case "kafkaMsgTimestamp": {
                    return this.createScanSpecForTimestamp(kafkaNodeProcessor.getFunctionName(), kafkaNodeProcessor.getValue());
                }
                case "kafkaMsgOffset": {
                    return this.createScanSpecForOffset(kafkaNodeProcessor.getFunctionName(), kafkaNodeProcessor.getValue());
                }
                case "kafkaPartitionId": {
                    return this.createScanSpecForPartition(kafkaNodeProcessor.getFunctionName(), kafkaNodeProcessor.getValue());
                }
            }
        }
        return null;
    }

    private List<KafkaPartitionScanSpec> createScanSpecForTimestamp(String functionName, Long fieldValue) {
        ArrayList scanSpec = Lists.newArrayList();
        HashMap timesValMap = Maps.newHashMap();
        ImmutableSet topicPartitions = this.fullScanSpec.keySet();
        for (TopicPartition partitions : topicPartitions) {
            timesValMap.put(partitions, functionName.equals("greater_than") ? fieldValue + 1L : fieldValue);
        }
        Map offsetAndTimestamp = this.kafkaConsumer.offsetsForTimes((Map)timesValMap);
        for (TopicPartition tp : topicPartitions) {
            OffsetAndTimestamp value = (OffsetAndTimestamp)offsetAndTimestamp.get(tp);
            if (value == null) {
                scanSpec.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset()));
                continue;
            }
            scanSpec.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), value.offset(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset()));
        }
        return scanSpec;
    }

    private List<KafkaPartitionScanSpec> createScanSpecForOffset(String functionName, Long fieldValue) {
        ArrayList scanSpec = Lists.newArrayList();
        ImmutableSet topicPartitions = this.fullScanSpec.keySet();
        switch (functionName) {
            case "equal": {
                for (TopicPartition tp : topicPartitions) {
                    if (fieldValue < ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getStartOffset()) {
                        scanSpec.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset()));
                        continue;
                    }
                    long val = Math.min(fieldValue, ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset());
                    long nextVal = Math.min(val + 1L, ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset());
                    scanSpec.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), val, nextVal));
                }
                break;
            }
            case "greater_than_or_equal_to": {
                for (TopicPartition tp : topicPartitions) {
                    long val = this.bindOffsetToRange(tp, fieldValue);
                    scanSpec.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), val, ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset()));
                }
                break;
            }
            case "greater_than": {
                for (TopicPartition tp : topicPartitions) {
                    long val = this.bindOffsetToRange(tp, fieldValue + 1L);
                    scanSpec.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), val, ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset()));
                }
                break;
            }
            case "less_than_or_equal_to": {
                for (TopicPartition tp : topicPartitions) {
                    long val = this.bindOffsetToRange(tp, fieldValue + 1L);
                    scanSpec.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getStartOffset(), val));
                }
                break;
            }
            case "less_than": {
                for (TopicPartition tp : topicPartitions) {
                    long val = this.bindOffsetToRange(tp, fieldValue);
                    scanSpec.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getStartOffset(), val));
                }
                break;
            }
        }
        return scanSpec;
    }

    private List<KafkaPartitionScanSpec> createScanSpecForPartition(String functionName, Long fieldValue) {
        ArrayList scanSpecList = Lists.newArrayList();
        ImmutableSet topicPartitions = this.fullScanSpec.keySet();
        switch (functionName) {
            case "equal": {
                for (TopicPartition tp : topicPartitions) {
                    if ((long)tp.partition() != fieldValue) continue;
                    scanSpecList.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getStartOffset(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset()));
                }
                break;
            }
            case "not_equal": {
                for (TopicPartition tp : topicPartitions) {
                    if ((long)tp.partition() == fieldValue) continue;
                    scanSpecList.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getStartOffset(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset()));
                }
                break;
            }
            case "greater_than_or_equal_to": {
                for (TopicPartition tp : topicPartitions) {
                    if ((long)tp.partition() < fieldValue) continue;
                    scanSpecList.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getStartOffset(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset()));
                }
                break;
            }
            case "greater_than": {
                for (TopicPartition tp : topicPartitions) {
                    if ((long)tp.partition() <= fieldValue) continue;
                    scanSpecList.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getStartOffset(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset()));
                }
                break;
            }
            case "less_than_or_equal_to": {
                for (TopicPartition tp : topicPartitions) {
                    if ((long)tp.partition() > fieldValue) continue;
                    scanSpecList.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getStartOffset(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset()));
                }
                break;
            }
            case "less_than": {
                for (TopicPartition tp : topicPartitions) {
                    if ((long)tp.partition() >= fieldValue) continue;
                    scanSpecList.add(new KafkaPartitionScanSpec(tp.topic(), tp.partition(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getStartOffset(), ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset()));
                }
                break;
            }
        }
        return scanSpecList;
    }

    @Override
    public void close() {
        this.groupScan.getStoragePlugin().registerToClose((AutoCloseable)this.kafkaConsumer);
    }

    private long bindOffsetToRange(TopicPartition tp, long offset) {
        return Math.max(((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getStartOffset(), Math.min(offset, ((KafkaPartitionScanSpec)this.fullScanSpec.get((Object)tp)).getEndOffset()));
    }
}

