/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util.internal;

import com.google.common.net.UrlEscapers;
import com.oracle.bmc.http.internal.HttpDateUtils;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class HttpUtils {
    public static String encodePathSegment(@Nonnull String pathSegment) {
        if (pathSegment.isEmpty()) {
            throw new IllegalArgumentException("Cannot provide empty path segment");
        }
        return UrlEscapers.urlPathSegmentEscaper().escape(pathSegment);
    }

    public static String encodePathSegment(@Nonnull Number pathSegment) {
        return HttpUtils.encodePathSegment(pathSegment.toString());
    }

    public static String encodePathSegment(@Nonnull Boolean pathSegment) {
        return HttpUtils.encodePathSegment(pathSegment.toString());
    }

    public static String encodePathSegment(@Nonnull Character pathSegment) {
        return HttpUtils.encodePathSegment(pathSegment.toString());
    }

    public static String encodePathSegment(@Nonnull UUID pathSegment) {
        return HttpUtils.encodePathSegment(pathSegment.toString());
    }

    public static Object attemptEncodeQueryParam(Object queryParam) {
        if (queryParam instanceof Date) {
            return HttpDateUtils.format((Date)queryParam);
        }
        if (queryParam instanceof String) {
            return UrlEscapers.urlPathSegmentEscaper().escape((String)queryParam);
        }
        return queryParam;
    }

    public static WrappedWebTarget encodeMapQueryParam(WrappedWebTarget target, String prefix, Map<String, ?> queryParam) {
        if (prefix == null) {
            prefix = "";
        }
        if (queryParam != null) {
            for (Map.Entry<String, ?> e : queryParam.entrySet()) {
                target = HttpUtils.encodeMapQueryParamValue(target, prefix + e.getKey(), e.getValue());
            }
        }
        return target;
    }

    public static <T> WrappedWebTarget encodeCollectionFormatQueryParam(WrappedWebTarget target, String queryParamName, List<T> values, CollectionFormatType collectionFormatType) {
        if (StringUtils.isBlank((CharSequence)queryParamName)) {
            throw new IllegalArgumentException("A non-blank queryParamName must be provided");
        }
        if (values != null && !values.isEmpty()) {
            ArrayList<String> valuesToUse = new ArrayList<String>();
            for (T v : values) {
                if (v == null) continue;
                if (v instanceof Enum) {
                    Object rawValue = ReflectionUtils.invokeGetter(v, "getValue");
                    if (rawValue != null) {
                        valuesToUse.add((String)rawValue);
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("Could not get the correct value for enum %s", v.getClass().getCanonicalName()));
                }
                valuesToUse.add((String)v);
            }
            if (valuesToUse.isEmpty()) {
                return target;
            }
            if (collectionFormatType == CollectionFormatType.CommaSeparated) {
                target = target.queryParam(queryParamName, HttpUtils.attemptEncodeQueryParam(StringUtils.join(valuesToUse, (char)',')));
            } else if (collectionFormatType == CollectionFormatType.PipeSeparated) {
                target = target.queryParam(queryParamName, HttpUtils.attemptEncodeQueryParam(StringUtils.join(valuesToUse, (char)'|')));
            } else if (collectionFormatType == CollectionFormatType.SpaceSeparated) {
                target = target.queryParam(queryParamName, HttpUtils.attemptEncodeQueryParam(StringUtils.join(valuesToUse, (char)' ')));
            } else if (collectionFormatType == CollectionFormatType.TabSeparated) {
                target = target.queryParam(queryParamName, HttpUtils.attemptEncodeQueryParam(StringUtils.join(valuesToUse, (char)'\t')));
            } else if (collectionFormatType == CollectionFormatType.Multi) {
                Object[] encodedValuesToUse = new Object[valuesToUse.size()];
                for (int i = 0; i < valuesToUse.size(); ++i) {
                    encodedValuesToUse[i] = HttpUtils.attemptEncodeQueryParam(valuesToUse.get(i));
                }
                target = target.queryParam(queryParamName, encodedValuesToUse);
            } else {
                throw new IllegalArgumentException(String.format("Unknown collection format type: %s", new Object[]{collectionFormatType}));
            }
        }
        return target;
    }

    private static WrappedWebTarget encodeMapQueryParamValue(WrappedWebTarget target, String prefixedKey, Object value) {
        String name = HttpUtils.attemptEncodeQueryParam(prefixedKey).toString();
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            for (Object v : c) {
                target = target.queryParam(name, HttpUtils.attemptEncodeQueryParam(v));
            }
        } else {
            target = target.queryParam(name, HttpUtils.attemptEncodeQueryParam(value));
        }
        return target;
    }
}

