/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.model;

public class BmcException
extends RuntimeException {
    public static final String OPC_REQUEST_ID_HEADER = "opc-request-id";
    private final int statusCode;
    private final String serviceCode;
    private final boolean timeout;
    private final String opcRequestId;
    private final boolean isClientSide;

    public BmcException(int statusCode, String serviceCode, String message, String opcRequestId, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
        this.serviceCode = serviceCode;
        this.opcRequestId = opcRequestId;
        this.timeout = false;
        this.isClientSide = false;
    }

    public BmcException(int statusCode, String serviceCode, String message, String opcRequestId) {
        super(message);
        this.statusCode = statusCode;
        this.serviceCode = serviceCode;
        this.opcRequestId = opcRequestId;
        this.timeout = false;
        this.isClientSide = false;
    }

    public BmcException(boolean timeout, String message, Throwable cause, String opcRequestId) {
        super(message, cause);
        this.statusCode = -1;
        this.serviceCode = null;
        this.opcRequestId = opcRequestId;
        this.timeout = timeout;
        this.isClientSide = true;
    }

    @Override
    public String getMessage() {
        String requestId = this.opcRequestId != null ? " (" + (this.isClientSide ? "outbound " : "") + "opc-request-id: " + this.opcRequestId + ")" : "";
        return String.format("(%s, %s, %s) %s%s", this.statusCode, this.serviceCode, this.timeout, super.getMessage(), requestId);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public boolean isClientSide() {
        return this.isClientSide;
    }
}

