/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.json4s.jackson;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import shadedelta.com.fasterxml.jackson.core.JsonGenerator;
import shadedelta.com.fasterxml.jackson.databind.JsonSerializer;
import shadedelta.com.fasterxml.jackson.databind.SerializerProvider;
import shadedelta.org.json4s.JsonAST;
import shadedelta.org.json4s.JsonAST$JNothing$;
import shadedelta.org.json4s.JsonAST$JNull$;
import shadedelta.org.json4s.package$;

@ScalaSignature(bytes="\u0006\u000593A\u0001B\u0003\u0001\u0019!)\u0001\u0005\u0001C\u0001C!)A\u0005\u0001C\u0001K!)1\b\u0001C!y\t\u0001\"JV1mk\u0016\u001cVM]5bY&TXM\u001d\u0006\u0003\r\u0011\u000bqA[1dWN|gN\u0003\u0002\t\r\u00061!n]8oiMT\u0011AC\u0001\u0004_J<7\u0001A\n\u0003\u00015\u00012A\u0004\f\u0019\u001b\u0005y!B\u0001\tK\u0003!!\u0017\r^1cS:$'B\u0001\u0004N\u0015\t\u0019B#A\u0005gCN$XM\u001d=nY*\tQ#A\u0002d_6L!aF\b\u0003\u001d)\u001bxN\\*fe&\fG.\u001b>feB\u0011\u0011$\b\b\u00035mi\u0011aB\u0005\u00039\u001d\tq\u0001]1dW\u0006<W-\u0003\u0002\u001f?\t1!JV1mk\u0016T!\u0001H\u0004\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005)\u0011!C:fe&\fG.\u001b>f)\u00111CF\f\u001c\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006[\t\u0001\r\u0001G\u0001\u0006m\u0006dW/\u001a\u0005\u0006_\t\u0001\r\u0001M\u0001\u0005UN|g\u000e\u0005\u00022i5\t!G\u0003\u00024#\u0005!1m\u001c:f\u0013\t)$GA\u0007Kg>tw)\u001a8fe\u0006$xN\u001d\u0005\u0006o\t\u0001\r\u0001O\u0001\taJ|g/\u001b3feB\u0011a\"O\u0005\u0003u=\u0011!cU3sS\u0006d\u0017N_3s!J|g/\u001b3fe\u00069\u0011n]#naRLHCA\u001fA!\t9c(\u0003\u0002@Q\t9!i\\8mK\u0006t\u0007\"B\u0017\u0004\u0001\u0004A\u0012AC:iC\u0012,G-\u001a7uC*\t\u0011I\u0003\u0002\u000b\u0005*\u0011\u0001b\u0011\u0006\u0002\u0003*\u0011!\"\u0012\u0006\u0002\u0003*\u0011Qc\u0012\u0006\u0003'!S!AB%\u000b\u0003\u0005S!!F&\u000b\u0005Ma\u0005")
public class JValueSerializer
extends JsonSerializer<JsonAST.JValue> {
    @Override
    public void serialize(JsonAST.JValue value, JsonGenerator json, SerializerProvider provider) {
        if (value == null) {
            json.writeNull();
        } else {
            JsonAST.JValue jValue = value;
            if (jValue instanceof JsonAST.JInt) {
                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                BigInt v = jInt.num();
                json.writeNumber(v.bigInteger());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JsonAST.JLong) {
                JsonAST.JLong jLong = (JsonAST.JLong)jValue;
                long v = jLong.num();
                json.writeNumber(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JsonAST.JDouble) {
                JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
                double v = jDouble.num();
                json.writeNumber(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JsonAST.JDecimal) {
                JsonAST.JDecimal jDecimal = (JsonAST.JDecimal)jValue;
                BigDecimal v = jDecimal.num();
                json.writeNumber(v.bigDecimal());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String v = jString.s();
                json.writeString(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JsonAST.JBool) {
                JsonAST.JBool jBool = (JsonAST.JBool)jValue;
                boolean v = jBool.value();
                json.writeBoolean(v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JsonAST.JArray) {
                JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                List<JsonAST.JValue> elements = jArray.arr();
                json.writeStartArray();
                elements.foreach((Function1 & Serializable)x -> {
                    this.serialize(x, json, provider);
                    return BoxedUnit.UNIT;
                });
                json.writeEndArray();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JsonAST.JSet) {
                JsonAST.JSet jSet = (JsonAST.JSet)jValue;
                Set<JsonAST.JValue> elements = jSet.set();
                json.writeStartArray();
                elements.foreach((Function1 & Serializable)x -> {
                    this.serialize(x, json, provider);
                    return BoxedUnit.UNIT;
                });
                json.writeEndArray();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jValue instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                List<Tuple2<String, JsonAST.JValue>> fields = jObject.obj();
                json.writeStartObject();
                fields.foreach((Function1 & Serializable)x0$1 -> {
                    JValueSerializer.$anonfun$serialize$3(this, json, provider, x0$1);
                    return BoxedUnit.UNIT;
                });
                json.writeEndObject();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                JsonAST$JNull$ jsonAST$JNull$ = package$.MODULE$.JNull();
                JsonAST.JValue jValue2 = jValue;
                if (!(jsonAST$JNull$ != null ? !jsonAST$JNull$.equals(jValue2) : jValue2 != null)) {
                    json.writeNull();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    JsonAST$JNothing$ jsonAST$JNothing$ = package$.MODULE$.JNothing();
                    JsonAST.JValue jValue3 = jValue;
                    if (!(jsonAST$JNothing$ != null ? !jsonAST$JNothing$.equals(jValue3) : jValue3 != null)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)jValue);
                    }
                }
            }
        }
    }

    @Override
    public boolean isEmpty(JsonAST.JValue value) {
        JsonAST.JValue jValue = value;
        JsonAST$JNothing$ jsonAST$JNothing$ = package$.MODULE$.JNothing();
        return !(jValue != null ? !jValue.equals(jsonAST$JNothing$) : jsonAST$JNothing$ != null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$serialize$3(JValueSerializer $this, JsonGenerator json$1, SerializerProvider provider$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
            JsonAST$JNothing$ jsonAST$JNothing$ = package$.MODULE$.JNothing();
            JsonAST.JValue jValue2 = jValue;
            if (!(jsonAST$JNothing$ != null ? !jsonAST$JNothing$.equals(jValue2) : jValue2 != null)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String n = (String)tuple2._1();
        JsonAST.JValue v = (JsonAST.JValue)tuple2._2();
        json$1.writeFieldName(n);
        $this.serialize(v, json$1, provider$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

