/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.types;

import io.delta.standalone.types.DataType;
import java.util.Objects;

public final class MapType
extends DataType {
    private final DataType keyType;
    private final DataType valueType;
    private final boolean valueContainsNull;

    public MapType(DataType dataType, DataType dataType2, boolean bl) {
        this.keyType = dataType;
        this.valueType = dataType2;
        this.valueContainsNull = bl;
    }

    public DataType getKeyType() {
        return this.keyType;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    public boolean valueContainsNull() {
        return this.valueContainsNull;
    }

    protected void buildFormattedString(String string, StringBuilder stringBuilder) {
        String string2 = string + "    |";
        stringBuilder.append(String.format("%s-- key: %s\n", string, this.keyType.getTypeName()));
        DataType.buildFormattedString(this.keyType, string2, stringBuilder);
        stringBuilder.append(String.format("%s-- value: %s (valueContainsNull = %b)\n", string, this.valueType.getTypeName(), this.valueContainsNull));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MapType mapType = (MapType)object;
        return this.valueContainsNull == mapType.valueContainsNull && Objects.equals(this.keyType, mapType.keyType) && Objects.equals(this.valueType, mapType.valueType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keyType, this.valueType, this.valueContainsNull);
    }
}

