/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.util;

import io.delta.standalone.internal.util.CalendarInterval;
import io.delta.standalone.internal.util.DateTimeConstants$;
import io.delta.standalone.internal.util.IntervalUtils$IntervalUnit$;
import io.delta.standalone.internal.util.IntervalUtils$ParseState$;
import java.nio.charset.StandardCharsets;
import scala.Enumeration;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class IntervalUtils$ {
    public static final IntervalUtils$ MODULE$ = new IntervalUtils$();
    private static final String yearStr = MODULE$.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.YEAR());
    private static final String monthStr = MODULE$.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.MONTH());
    private static final String weekStr = MODULE$.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.WEEK());
    private static final String dayStr = MODULE$.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.DAY());
    private static final String hourStr = MODULE$.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.HOUR());
    private static final String minuteStr = MODULE$.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.MINUTE());
    private static final String secondStr = MODULE$.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.SECOND());
    private static final String millisStr = MODULE$.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.MILLISECOND());
    private static final String microsStr = MODULE$.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.MICROSECOND());

    private final String intervalStr() {
        return "interval";
    }

    private String unitToUtf8(Enumeration.Value unit) {
        return unit.toString();
    }

    private final String yearStr() {
        return yearStr;
    }

    private final String monthStr() {
        return monthStr;
    }

    private final String weekStr() {
        return weekStr;
    }

    private final String dayStr() {
        return dayStr;
    }

    private final String hourStr() {
        return hourStr;
    }

    private final String minuteStr() {
        return minuteStr;
    }

    private final String secondStr() {
        return secondStr;
    }

    private final String millisStr() {
        return millisStr;
    }

    private final String microsStr() {
        return microsStr;
    }

    public CalendarInterval safeStringToInterval(String input) {
        CalendarInterval calendarInterval;
        try {
            calendarInterval = this.stringToInterval(input);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            calendarInterval = null;
        }
        return calendarInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CalendarInterval stringToInterval(String input) {
        boolean bl;
        if (input == null) {
            throw IntervalUtils$.throwIAE$1("interval string cannot be null", IntervalUtils$.throwIAE$default$2$1(), input);
        }
        String s = input.trim().toLowerCase();
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(bytes))) {
            throw IntervalUtils$.throwIAE$1("interval string cannot be empty", IntervalUtils$.throwIAE$default$2$1(), input);
        }
        ObjectRef state = ObjectRef.create((Object)IntervalUtils$ParseState$.MODULE$.PREFIX());
        IntRef i = IntRef.create((int)0);
        long currentValue = 0L;
        boolean isNegative = false;
        int months = 0;
        int days = 0;
        long microseconds = 0L;
        int fractionScale = 0;
        int initialFractionScale = (int)(DateTimeConstants$.MODULE$.NANOS_PER_SECOND() / 10L);
        int fraction = 0;
        boolean pointPrefixed = false;
        while (i.elem < bytes.length) {
            BoxedUnit boxedUnit;
            byte b = bytes[i.elem];
            Enumeration.Value value = (Enumeration.Value)state.elem;
            Enumeration.Value value2 = IntervalUtils$ParseState$.MODULE$.PREFIX();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                if (s.startsWith("interval")) {
                    if (s.length() == "interval".length()) {
                        throw IntervalUtils$.throwIAE$1("interval string cannot be empty", IntervalUtils$.throwIAE$default$2$1(), input);
                    }
                    if (!Character.isWhitespace(bytes[i.elem + "interval".length()])) {
                        throw IntervalUtils$.throwIAE$1(new StringBuilder(24).append("invalid interval prefix ").append(IntervalUtils$.currentWord$1(s, i)).toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    }
                    i.elem += "interval".length() + 1;
                }
                state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value4 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                IntervalUtils$.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.SIGN(), i, state);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value6 = IntervalUtils$ParseState$.MODULE$.SIGN();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                BoxedUnit boxedUnit2;
                currentValue = 0L;
                fraction = 0;
                state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
                fractionScale = -1;
                pointPrefixed = false;
                byte by = b;
                if (45 == by) {
                    isNegative = true;
                    ++i.elem;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (43 == by) {
                    isNegative = false;
                    ++i.elem;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (48 <= b && b <= 57) {
                    isNegative = false;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    if (46 != by) throw IntervalUtils$.throwIAE$1(new StringBuilder(22).append("unrecognized number '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    isNegative = false;
                    fractionScale = initialFractionScale;
                    pointPrefixed = true;
                    ++i.elem;
                    state.elem = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value8 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                IntervalUtils$.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.VALUE(), i, state);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value10 = IntervalUtils$ParseState$.MODULE$.VALUE();
            Enumeration.Value value11 = value;
            if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                BoxedUnit boxedUnit3;
                byte by = b;
                if (48 <= b && b <= 57) {
                    BoxedUnit boxedUnit4;
                    try {
                        currentValue = Math.addExact(Math.multiplyExact(10L, currentValue), (long)(b - 48));
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    catch (ArithmeticException e) {
                        throw IntervalUtils$.throwIAE$1(e.getMessage(), e, input);
                    }
                    boxedUnit3 = boxedUnit4;
                } else if (Character.isWhitespace(b)) {
                    state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    if (46 != by) throw IntervalUtils$.throwIAE$1(new StringBuilder(16).append("invalid value '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    fractionScale = initialFractionScale;
                    state.elem = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                ++i.elem;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value12 = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
            Enumeration.Value value13 = value;
            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                if (48 <= b && b <= 57 && fractionScale > 0) {
                    fraction += (b - 48) * fractionScale;
                    fractionScale /= 10;
                } else {
                    if (!Character.isWhitespace(b) || pointPrefixed && fractionScale >= initialFractionScale) throw 48 <= b && b <= 57 ? IntervalUtils$.throwIAE$1(new StringBuilder(0).append(new StringBuilder(57).append("interval can only support nanosecond precision, '").append(IntervalUtils$.currentWord$1(s, i)).append("' is out").toString()).append(" of range").toString(), IntervalUtils$.throwIAE$default$2$1(), input) : IntervalUtils$.throwIAE$1(new StringBuilder(16).append("invalid value '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    fraction /= (int)DateTimeConstants$.MODULE$.NANOS_PER_MICROS();
                    state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
                }
                ++i.elem;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value14 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
            Enumeration.Value value15 = value;
            if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                IntervalUtils$.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.UNIT_BEGIN(), i, state);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value16 = IntervalUtils$ParseState$.MODULE$.UNIT_BEGIN();
            Enumeration.Value value17 = value;
            if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                if (b != 115 && fractionScale >= 0) {
                    throw IntervalUtils$.throwIAE$1(new StringBuilder(30).append("'").append(IntervalUtils$.currentWord$1(s, i)).append("' cannot have fractional part").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                }
                if (isNegative) {
                    currentValue = -currentValue;
                    fraction = -fraction;
                }
                try {
                    byte by = b;
                    switch (by) {
                        case 121: {
                            if (!IntervalUtils$.matchAt$1(i.elem, this.yearStr(), s)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long monthsInYears = Math.multiplyExact((long)DateTimeConstants$.MODULE$.MONTHS_PER_YEAR(), currentValue);
                            months = Math.toIntExact(Math.addExact((long)months, monthsInYears));
                            i.elem += this.yearStr().length();
                            break;
                        }
                        case 119: {
                            if (!IntervalUtils$.matchAt$1(i.elem, this.weekStr(), s)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long daysInWeeks = Math.multiplyExact((long)DateTimeConstants$.MODULE$.DAYS_PER_WEEK(), currentValue);
                            days = Math.toIntExact(Math.addExact((long)days, daysInWeeks));
                            i.elem += this.weekStr().length();
                            break;
                        }
                        case 100: {
                            if (!IntervalUtils$.matchAt$1(i.elem, this.dayStr(), s)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            days = Math.addExact(days, Math.toIntExact(currentValue));
                            i.elem += this.dayStr().length();
                            break;
                        }
                        case 104: {
                            if (!IntervalUtils$.matchAt$1(i.elem, this.hourStr(), s)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long hoursUs = Math.multiplyExact(currentValue, DateTimeConstants$.MODULE$.MICROS_PER_HOUR());
                            microseconds = Math.addExact(microseconds, hoursUs);
                            i.elem += this.hourStr().length();
                            break;
                        }
                        case 115: {
                            if (!IntervalUtils$.matchAt$1(i.elem, this.secondStr(), s)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long secondsUs = Math.multiplyExact(currentValue, DateTimeConstants$.MODULE$.MICROS_PER_SECOND());
                            microseconds = Math.addExact(Math.addExact(microseconds, secondsUs), (long)fraction);
                            i.elem += this.secondStr().length();
                            break;
                        }
                        case 109: {
                            if (IntervalUtils$.matchAt$1(i.elem, this.monthStr(), s)) {
                                months = Math.addExact(months, Math.toIntExact(currentValue));
                                i.elem += this.monthStr().length();
                                break;
                            }
                            if (IntervalUtils$.matchAt$1(i.elem, this.minuteStr(), s)) {
                                long minutesUs = Math.multiplyExact(currentValue, DateTimeConstants$.MODULE$.MICROS_PER_MINUTE());
                                microseconds = Math.addExact(microseconds, minutesUs);
                                i.elem += this.minuteStr().length();
                                break;
                            }
                            if (IntervalUtils$.matchAt$1(i.elem, this.millisStr(), s)) {
                                long millisUs = Math.multiplyExact(currentValue, DateTimeConstants$.MODULE$.MICROS_PER_MILLIS());
                                microseconds = Math.addExact(microseconds, millisUs);
                                i.elem += this.millisStr().length();
                                break;
                            }
                            if (!IntervalUtils$.matchAt$1(i.elem, this.microsStr(), s)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            microseconds = Math.addExact(microseconds, currentValue);
                            i.elem += this.microsStr().length();
                            break;
                        }
                        default: {
                            throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                        }
                    }
                }
                catch (ArithmeticException e) {
                    throw IntervalUtils$.throwIAE$1(e.getMessage(), e, input);
                }
                state.elem = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value18 = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
            Enumeration.Value value19 = value;
            if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                byte by = b;
                switch (by) {
                    case 115: {
                        state.elem = IntervalUtils$ParseState$.MODULE$.UNIT_END();
                        break;
                    }
                    default: {
                        if (!Character.isWhitespace(b)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                        state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                        break;
                    }
                }
                ++i.elem;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value20 = IntervalUtils$ParseState$.MODULE$.UNIT_END();
            Enumeration.Value value21 = value;
            if (value20 == null) {
                if (value21 != null) {
                    throw new MatchError((Object)value);
                }
            } else if (!value20.equals(value21)) throw new MatchError((Object)value);
            if (!Character.isWhitespace(b)) throw IntervalUtils$.throwIAE$1(new StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
            ++i.elem;
            state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
            boxedUnit = BoxedUnit.UNIT;
        }
        Enumeration.Value value = (Enumeration.Value)state.elem;
        Enumeration.Value value22 = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
        Enumeration.Value value23 = value;
        if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
            bl = true;
        } else {
            Enumeration.Value value24 = IntervalUtils$ParseState$.MODULE$.UNIT_END();
            Enumeration.Value value25 = value;
            if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
                bl = true;
            } else {
                Enumeration.Value value26 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                Enumeration.Value value27 = value;
                bl = !(value26 != null ? !value26.equals(value27) : value27 != null);
            }
        }
        if (!bl) {
            boolean bl2;
            Enumeration.Value value28 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
            Enumeration.Value value29 = value;
            if (value28 == null) {
                if (value29 == null) throw IntervalUtils$.throwIAE$1(new StringBuilder(36).append("expect a number after '").append(IntervalUtils$.currentWord$1(s, i)).append("' but hit EOL").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
            } else if (value28.equals(value29)) {
                throw IntervalUtils$.throwIAE$1(new StringBuilder(36).append("expect a number after '").append(IntervalUtils$.currentWord$1(s, i)).append("' but hit EOL").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
            }
            Enumeration.Value value30 = IntervalUtils$ParseState$.MODULE$.VALUE();
            Enumeration.Value value31 = value;
            if (!(value30 != null ? !value30.equals(value31) : value31 != null)) {
                bl2 = true;
            } else {
                Enumeration.Value value32 = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
                Enumeration.Value value33 = value;
                bl2 = !(value32 != null ? !value32.equals(value33) : value33 != null);
            }
            if (!bl2) throw IntervalUtils$.throwIAE$1(new StringBuilder(29).append("unknown error when parsing '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
            throw IntervalUtils$.throwIAE$1(new StringBuilder(39).append("expect a unit name after '").append(IntervalUtils$.currentWord$1(s, i)).append("' but hit EOL").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
        }
        CalendarInterval calendarInterval = new CalendarInterval(months, days, microseconds);
        return calendarInterval;
    }

    private static final Nothing$ throwIAE$1(String msg, Exception e, String input$1) {
        throw new IllegalArgumentException(new StringBuilder(30).append("Error parsing '").append(input$1).append("' to interval, ").append(msg).toString(), e);
    }

    private static final Exception throwIAE$default$2$1() {
        return null;
    }

    private static final void trimToNextState$1(byte b, Enumeration.Value next, IntRef i$1, ObjectRef state$1) {
        if (Character.isWhitespace(b)) {
            ++i$1.elem;
        } else {
            state$1.elem = next;
        }
    }

    private static final String currentWord$1(String s$1, IntRef i$1) {
        String sep = "\\s+";
        String[] strings = s$1.split(sep);
        int lenRight = s$1.substring(i$1.elem, s$1.length()).split(sep).length;
        return strings[strings.length - lenRight];
    }

    private static final boolean matchAt$1(int i, String str, String s$1) {
        boolean bl;
        if (i + str.length() > s$1.length()) {
            bl = false;
        } else {
            String string = s$1.substring(i, i + str.length());
            String string2 = str;
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        }
        return bl;
    }

    private IntervalUtils$() {
    }
}

