/*
 * Decompiled with CFR 0.152.
 */
package org.jamel.dbf.structure;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Date;
import org.jamel.dbf.exception.DbfException;
import org.jamel.dbf.structure.DbfHeader;
import org.jamel.dbf.utils.DbfUtils;

public class DbfRow {
    private static final Long ZERO = 0L;
    private final DbfHeader header;
    private final Charset defaultCharset;
    private final Object[] row;

    public DbfRow(DbfHeader header, Charset defaultCharset, Object[] row) {
        this.header = header;
        this.defaultCharset = defaultCharset;
        this.row = row;
    }

    public BigDecimal getBigDecimal(String fieldName) throws DbfException {
        Object value = this.get(fieldName);
        return value == null ? null : new BigDecimal(value.toString());
    }

    public Date getDate(String fieldName) throws DbfException {
        Date value = (Date)this.get(fieldName);
        return value == null ? null : value;
    }

    public String getString(String fieldName) throws DbfException {
        return this.getString(fieldName, this.defaultCharset);
    }

    public String getString(String fieldName, Charset charset) throws DbfException {
        Object value = this.get(fieldName);
        return value == null ? null : new String(DbfUtils.trimLeftSpaces((byte[])value), charset);
    }

    public boolean getBoolean(String fieldName) throws DbfException {
        Boolean value = (Boolean)this.get(fieldName);
        return value != null && value != false;
    }

    public int getInt(String fieldName) throws DbfException {
        return this.getNumber(fieldName).intValue();
    }

    public short getShort(String fieldName) throws DbfException {
        return this.getNumber(fieldName).shortValue();
    }

    public byte getByte(String fieldName) throws DbfException {
        return this.getNumber(fieldName).byteValue();
    }

    public long getLong(String fieldName) throws DbfException {
        return this.getNumber(fieldName).longValue();
    }

    public float getFloat(String fieldName) throws DbfException {
        return this.getNumber(fieldName).floatValue();
    }

    public double getDouble(String fieldName) throws DbfException {
        return this.getNumber(fieldName).doubleValue();
    }

    public Object getObject(String fieldName) throws DbfException {
        return this.get(fieldName);
    }

    private Number getNumber(String fieldName) {
        Number value = (Number)this.get(fieldName);
        return value == null ? (Number)ZERO : (Number)value;
    }

    private Object get(String fieldName) {
        int fieldIndex = this.header.getFieldIndex(fieldName);
        if (fieldIndex < 0) {
            throw new DbfException(String.format("Field \"%s\" does not exist", fieldName));
        }
        return this.row[fieldIndex];
    }
}

