/*
 * Decompiled with CFR 0.152.
 */
package org.jamel.dbf.processor;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jamel.dbf.DbfReader;
import org.jamel.dbf.exception.DbfException;
import org.jamel.dbf.processor.DbfRowMapper;
import org.jamel.dbf.processor.DbfRowProcessor;
import org.jamel.dbf.structure.DbfDataType;
import org.jamel.dbf.structure.DbfField;
import org.jamel.dbf.structure.DbfHeader;
import org.jamel.dbf.utils.StringUtils;

public final class DbfProcessor {
    private static final int INDEX_WIDTH = 4;
    private static final int NAME_WIDTH = 16;
    private static final int TYPE_WIDTH = 8;
    private static final int LENGTH_WIDTH = 8;
    private static final int DECIMAL_WIDTH = 8;

    private DbfProcessor() {
    }

    public static <T> List<T> loadData(InputStream inputStream, DbfRowMapper<T> rowMapper) throws DbfException {
        try (DbfReader reader = new DbfReader(inputStream);){
            Object[] row;
            ArrayList<T> result = new ArrayList<T>(reader.getRecordCount());
            while ((row = reader.nextRecord()) != null) {
                result.add(rowMapper.mapRow(row));
            }
            ArrayList<T> arrayList = result;
            return arrayList;
        }
    }

    public static <T> List<T> loadData(File dbf, DbfRowMapper<T> rowMapper) throws DbfException {
        try (DbfReader reader = new DbfReader(dbf);){
            Object[] row;
            ArrayList<T> result = new ArrayList<T>(reader.getRecordCount());
            while ((row = reader.nextRecord()) != null) {
                result.add(rowMapper.mapRow(row));
            }
            ArrayList<T> arrayList = result;
            return arrayList;
        }
    }

    public static void processDbf(File dbf, DbfRowProcessor rowProcessor) throws DbfException {
        try (DbfReader reader = new DbfReader(dbf);){
            Object[] row;
            while ((row = reader.nextRecord()) != null) {
                rowProcessor.processRow(row);
            }
        }
    }

    public static void writeToTxtFile(File dbf, File txt, Charset dbfEncoding) {
        try (DbfReader reader = new DbfReader(dbf);
             PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(txt)));){
            Object[] row;
            DbfHeader header = reader.getHeader();
            String[] titles = new String[header.getFieldsCount()];
            for (int i = 0; i < header.getFieldsCount(); ++i) {
                DbfField field = header.getField(i);
                titles[i] = StringUtils.rightPad(field.getName(), field.getFieldLength(), ' ');
            }
            for (String title : titles) {
                writer.print(title);
            }
            writer.println();
            while ((row = reader.nextRecord()) != null) {
                for (int i = 0; i < header.getFieldsCount(); ++i) {
                    DbfField field = header.getField(i);
                    String value = field.getDataType() == DbfDataType.CHAR ? new String((byte[])row[i], dbfEncoding) : String.valueOf(row[i]);
                    writer.print(StringUtils.rightPad(value, field.getFieldLength(), ' '));
                }
                writer.println();
            }
        }
        catch (IOException e) {
            throw new DbfException("Cannot write .dbf file to .txt", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readDbfInfo(File dbf) {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(dbf)));){
            int i;
            DbfHeader header = DbfHeader.read(in);
            StringBuilder sb = new StringBuilder(512);
            sb.append("Created at: ").append(header.getYear()).append('-').append(header.getMonth()).append('-').append(header.getDay()).append('\n').append("Total records: ").append(header.getNumberOfRecords()).append('\n').append("Header length: ").append(header.getHeaderLength()).append('\n').append("Columns: ").append('\n');
            sb.append("  ").append(StringUtils.rightPad("#", 4, ' ')).append(StringUtils.rightPad("Name", 16, ' ')).append(StringUtils.rightPad("Type", 8, ' ')).append(StringUtils.rightPad("Length", 8, ' ')).append(StringUtils.rightPad("Decimal", 8, ' ')).append('\n');
            int totalWidth = 46;
            for (i = 0; i < totalWidth; ++i) {
                sb.append('-');
            }
            for (i = 0; i < header.getFieldsCount(); ++i) {
                DbfField field = header.getField(i);
                sb.append('\n').append("  ").append(StringUtils.rightPad(String.valueOf(i), 4, ' ')).append(StringUtils.rightPad(field.getName(), 16, ' ')).append(StringUtils.rightPad(String.valueOf((char)field.getDataType().byteValue), 8, ' ')).append(StringUtils.rightPad(String.valueOf(field.getFieldLength()), 8, ' ')).append(StringUtils.rightPad(String.valueOf(field.getDecimalCount()), 8, ' '));
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new DbfException("Cannot read header of .dbf file " + dbf, e);
        }
    }
}

