/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.DeviceSessionLogInfo;
import com.dropbox.core.v2.teamlog.WebSessionLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class WebDeviceSessionLogInfo
extends DeviceSessionLogInfo {
    protected final WebSessionLogInfo sessionInfo;
    protected final String userAgent;
    protected final String os;
    protected final String browser;

    public WebDeviceSessionLogInfo(String userAgent, String os, String browser, String ipAddress, Date created, Date updated, WebSessionLogInfo sessionInfo) {
        super(ipAddress, created, updated);
        this.sessionInfo = sessionInfo;
        if (userAgent == null) {
            throw new IllegalArgumentException("Required value for 'userAgent' is null");
        }
        this.userAgent = userAgent;
        if (os == null) {
            throw new IllegalArgumentException("Required value for 'os' is null");
        }
        this.os = os;
        if (browser == null) {
            throw new IllegalArgumentException("Required value for 'browser' is null");
        }
        this.browser = browser;
    }

    public WebDeviceSessionLogInfo(String userAgent, String os, String browser) {
        this(userAgent, os, browser, null, null, null, null);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getOs() {
        return this.os;
    }

    public String getBrowser() {
        return this.browser;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    public WebSessionLogInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public static Builder newBuilder(String userAgent, String os, String browser) {
        return new Builder(userAgent, os, browser);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sessionInfo, this.userAgent, this.os, this.browser});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            WebDeviceSessionLogInfo other = (WebDeviceSessionLogInfo)obj;
            return !(this.userAgent != other.userAgent && !this.userAgent.equals(other.userAgent) || this.os != other.os && !this.os.equals(other.os) || this.browser != other.browser && !this.browser.equals(other.browser) || this.ipAddress != other.ipAddress && (this.ipAddress == null || !this.ipAddress.equals(other.ipAddress)) || this.created != other.created && (this.created == null || !this.created.equals(other.created)) || this.updated != other.updated && (this.updated == null || !this.updated.equals(other.updated)) || this.sessionInfo != other.sessionInfo && (this.sessionInfo == null || !this.sessionInfo.equals(other.sessionInfo)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<WebDeviceSessionLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(WebDeviceSessionLogInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            this.writeTag("web_device_session", g);
            g.writeFieldName("user_agent");
            StoneSerializers.string().serialize(value.userAgent, g);
            g.writeFieldName("os");
            StoneSerializers.string().serialize(value.os, g);
            g.writeFieldName("browser");
            StoneSerializers.string().serialize(value.browser, g);
            if (value.ipAddress != null) {
                g.writeFieldName("ip_address");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.ipAddress, g);
            }
            if (value.created != null) {
                g.writeFieldName("created");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.created, g);
            }
            if (value.updated != null) {
                g.writeFieldName("updated");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.updated, g);
            }
            if (value.sessionInfo != null) {
                g.writeFieldName("session_info");
                StoneSerializers.nullableStruct(WebSessionLogInfo.Serializer.INSTANCE).serialize(value.sessionInfo, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public WebDeviceSessionLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            WebSessionLogInfo f_sessionInfo;
            Date f_updated;
            Date f_created;
            String f_ipAddress;
            String f_browser;
            String f_os;
            String f_userAgent;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("web_device_session".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                f_userAgent = null;
                f_os = null;
                f_browser = null;
                f_ipAddress = null;
                f_created = null;
                f_updated = null;
                f_sessionInfo = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("user_agent".equals(field)) {
                        f_userAgent = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("os".equals(field)) {
                        f_os = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("browser".equals(field)) {
                        f_browser = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("ip_address".equals(field)) {
                        f_ipAddress = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("created".equals(field)) {
                        f_created = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("updated".equals(field)) {
                        f_updated = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("session_info".equals(field)) {
                        f_sessionInfo = StoneSerializers.nullableStruct(WebSessionLogInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_userAgent == null) {
                    throw new JsonParseException(p, "Required field \"user_agent\" missing.");
                }
                if (f_os == null) {
                    throw new JsonParseException(p, "Required field \"os\" missing.");
                }
                if (f_browser == null) {
                    throw new JsonParseException(p, "Required field \"browser\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            WebDeviceSessionLogInfo value = new WebDeviceSessionLogInfo(f_userAgent, f_os, f_browser, f_ipAddress, f_created, f_updated, f_sessionInfo);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends DeviceSessionLogInfo.Builder {
        protected final String userAgent;
        protected final String os;
        protected final String browser;
        protected WebSessionLogInfo sessionInfo;

        protected Builder(String userAgent, String os, String browser) {
            if (userAgent == null) {
                throw new IllegalArgumentException("Required value for 'userAgent' is null");
            }
            this.userAgent = userAgent;
            if (os == null) {
                throw new IllegalArgumentException("Required value for 'os' is null");
            }
            this.os = os;
            if (browser == null) {
                throw new IllegalArgumentException("Required value for 'browser' is null");
            }
            this.browser = browser;
            this.sessionInfo = null;
        }

        public Builder withSessionInfo(WebSessionLogInfo sessionInfo) {
            this.sessionInfo = sessionInfo;
            return this;
        }

        @Override
        public Builder withIpAddress(String ipAddress) {
            super.withIpAddress(ipAddress);
            return this;
        }

        @Override
        public Builder withCreated(Date created) {
            super.withCreated(created);
            return this;
        }

        @Override
        public Builder withUpdated(Date updated) {
            super.withUpdated(updated);
            return this;
        }

        @Override
        public WebDeviceSessionLogInfo build() {
            return new WebDeviceSessionLogInfo(this.userAgent, this.os, this.browser, this.ipAddress, this.created, this.updated, this.sessionInfo);
        }
    }
}

