/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.timestamp.storage;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.retry.RetryNTimes;
import org.apache.omid.timestamp.storage.TimestampStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZKTimestampStorage
implements TimestampStorage {
    private static final Logger LOG = LoggerFactory.getLogger(ZKTimestampStorage.class);
    static final long INITIAL_MAX_TS_VALUE = 0L;
    private final DistributedAtomicLong timestamp;

    @Inject
    public ZKTimestampStorage(CuratorFramework zkClient) throws Exception {
        LOG.info("ZK Client state {}", (Object)zkClient.getState());
        this.timestamp = new DistributedAtomicLong(zkClient, "/omid/timestamp", (RetryPolicy)new RetryNTimes(3, 1000));
        if (this.timestamp.initialize(Long.valueOf(0L))) {
            LOG.info("Timestamp value in ZNode initialized to {}", (Object)0L);
        }
    }

    @Override
    public void updateMaxTimestamp(long previousMaxTimestamp, long newMaxTimestamp) throws IOException {
        AtomicValue compareAndSet;
        if (newMaxTimestamp < 0L) {
            LOG.error("Negative value received for maxTimestamp: {}", (Object)newMaxTimestamp);
            throw new IllegalArgumentException();
        }
        if (newMaxTimestamp <= previousMaxTimestamp) {
            LOG.error("maxTimestamp {} <= previousMaxTimesamp: {}", (Object)newMaxTimestamp, (Object)previousMaxTimestamp);
            throw new IllegalArgumentException();
        }
        try {
            compareAndSet = this.timestamp.compareAndSet(Long.valueOf(previousMaxTimestamp), Long.valueOf(newMaxTimestamp));
        }
        catch (Exception e) {
            throw new IOException("Problem setting timestamp in ZK", e);
        }
        if (!compareAndSet.succeeded()) {
            throw new IOException("GetAndSet operation for storing timestamp in ZK did not succeed " + compareAndSet.preValue() + " " + compareAndSet.postValue());
        }
    }

    @Override
    public long getMaxTimestamp() throws IOException {
        AtomicValue atomicValue;
        try {
            atomicValue = this.timestamp.get();
        }
        catch (Exception e) {
            throw new IOException("Problem getting data from ZK", e);
        }
        if (!atomicValue.succeeded()) {
            throw new IOException("Get operation to obtain timestamp from ZK did not succeed");
        }
        return (Long)atomicValue.postValue();
    }
}

