/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.timestamp.storage;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.IOException;
import javax.inject.Singleton;
import org.apache.curator.framework.CuratorFramework;
import org.apache.omid.zk.ZKUtils;

public class ZKModule
extends AbstractModule {
    private final String zkCluster;
    private final String namespace;

    public ZKModule(String zkCluster, String namespace) {
        this.zkCluster = zkCluster;
        this.namespace = namespace;
    }

    public void configure() {
    }

    @Provides
    @Singleton
    CuratorFramework provideInitializedZookeeperClient() throws IOException {
        return ZKUtils.initZKClient((String)this.zkCluster, (String)this.namespace, (int)10);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ZKModule zkModule = (ZKModule)((Object)o);
        if (!this.zkCluster.equals(zkModule.zkCluster)) {
            return false;
        }
        return this.namespace.equals(zkModule.namespace);
    }

    public int hashCode() {
        int result = this.zkCluster.hashCode();
        result = 31 * result + this.namespace.hashCode();
        return result;
    }
}

