/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigListener;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public interface ReplicationPeer {
    public String getId();

    public PeerState getPeerState();

    default public boolean isPeerEnabled() {
        return this.getPeerState() == PeerState.ENABLED;
    }

    public ReplicationPeerConfig getPeerConfig();

    public Configuration getConfiguration();

    public Map<TableName, List<String>> getTableCFs();

    public Set<String> getNamespaces();

    public long getPeerBandwidth();

    public void registerPeerConfigListener(ReplicationPeerConfigListener var1);

    @Deprecated
    default public void trackPeerConfigChanges(ReplicationPeerConfigListener listener) {
        this.registerPeerConfigListener(listener);
    }

    @InterfaceAudience.LimitedPrivate(value={"Replication"})
    public static enum PeerState {
        ENABLED,
        DISABLED;

    }
}

