/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractMeta;

final class SchemaMetaImpl
extends AbstractMeta {
    private static final long serialVersionUID = -505810795492145873L;
    private final Schema[] schemas;

    SchemaMetaImpl(Configuration configuration, Schema[] schemas) {
        super(configuration);
        this.schemas = schemas;
    }

    @Override
    protected final List<Catalog> getCatalogs0() {
        LinkedHashSet<Catalog> result = new LinkedHashSet<Catalog>();
        for (Schema schema : this.schemas) {
            if (schema.getCatalog() == null) continue;
            result.add(schema.getCatalog());
        }
        return new ArrayList<Catalog>(result);
    }

    @Override
    protected final List<Schema> getSchemas0() {
        return Collections.unmodifiableList(Arrays.asList(this.schemas));
    }

    @Override
    protected final List<Table<?>> getTables0() {
        ArrayList result = new ArrayList();
        for (Schema schema : this.schemas) {
            result.addAll(schema.getTables());
        }
        return result;
    }

    @Override
    protected final List<Sequence<?>> getSequences0() {
        ArrayList result = new ArrayList();
        for (Schema schema : this.schemas) {
            result.addAll(schema.getSequences());
        }
        return result;
    }

    @Override
    protected final List<UniqueKey<?>> getPrimaryKeys0() {
        ArrayList result = new ArrayList();
        for (Schema schema : this.schemas) {
            for (Table<?> table : schema.getTables()) {
                if (table.getPrimaryKey() == null) continue;
                result.add(table.getPrimaryKey());
            }
        }
        return result;
    }
}

