/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;

final class Position
extends AbstractField<Integer> {
    private static final long serialVersionUID = 3544690069533526544L;
    private final Field<String> search;
    private final Field<String> in;
    private final Field<? extends Number> startIndex;

    Position(Field<String> search, Field<String> in) {
        this(search, in, null);
    }

    Position(Field<String> search, Field<String> in, Field<? extends Number> startIndex) {
        super(Names.N_POSITION, SQLDataType.INTEGER);
        this.search = search;
        this.in = in;
        this.startIndex = startIndex;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.startIndex != null) {
            switch (ctx.family()) {
                default: 
            }
            ctx.visit(DSL.position(DSL.substring(this.in, this.startIndex), this.search).add(this.startIndex).sub(DSL.one()));
        } else {
            switch (ctx.family()) {
                case DERBY: {
                    ctx.visit(Keywords.F_LOCATE).sql('(').visit(this.search).sql(", ").visit(this.in).sql(')');
                    break;
                }
                case SQLITE: {
                    ctx.visit(Keywords.F_INSTR).sql('(').visit(this.in).sql(", ").visit(this.search).sql(')');
                    break;
                }
                default: {
                    ctx.visit(Keywords.F_POSITION).sql('(').visit(this.search).sql(' ').visit(Keywords.K_IN).sql(' ').visit(this.in).sql(')');
                }
            }
        }
    }
}

