/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.util.Properties;
import java.util.TimeZone;
import org.apache.calcite.avatica.ConnectionConfigImpl;

public class DrillConnectionConfig
extends ConnectionConfigImpl {
    private final Properties props;

    public DrillConnectionConfig(Properties p) {
        super(p);
        this.props = p;
    }

    public boolean isLocal() {
        return "local".equals(this.props.getProperty("zk"));
    }

    public boolean isDirect() {
        return this.props.getProperty("drillbit") != null;
    }

    public String getZookeeperConnectionString() {
        return this.props.getProperty("zk");
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public boolean isServerPreparedStatementDisabled() {
        return Boolean.valueOf(this.props.getProperty("server.preparedstatement.disabled"));
    }

    public boolean isServerMetadataDisabled() {
        return Boolean.valueOf(this.props.getProperty("server.metadata.disabled"));
    }
}

