/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.core;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.scanner.ClassPathScanner;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.yarn.core.ClusterDef;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.drill.yarn.core.DoyConfigException;
import org.apache.drill.yarn.core.NameValuePair;

public class DrillOnYarnConfig {
    public static final String DEFAULTS_FILE_NAME = "drill-on-yarn-defaults.conf";
    public static final String DISTRIB_FILE_NAME = "doy-distrib.conf";
    public static final String CONFIG_FILE_NAME = "drill-on-yarn.conf";
    public static final String DRILL_ON_YARN_PARENT = "drill.yarn";
    public static final String DOY_CLIENT_PARENT = DrillOnYarnConfig.append("drill.yarn", "client");
    public static final String DOY_AM_PARENT = DrillOnYarnConfig.append("drill.yarn", "am");
    public static final String DOY_DRILLBIT_PARENT = DrillOnYarnConfig.append("drill.yarn", "drillbit");
    public static final String FILES_PARENT = DrillOnYarnConfig.append("drill.yarn", "drill-install");
    public static final String DFS_PARENT = DrillOnYarnConfig.append("drill.yarn", "dfs");
    public static final String HTTP_PARENT = DrillOnYarnConfig.append("drill.yarn", "http");
    public static final String YARN_PARENT = DrillOnYarnConfig.append("drill.yarn", "yarn");
    public static final String HADOOP_PARENT = DrillOnYarnConfig.append("drill.yarn", "hadoop");
    public static final String CLIENT_PARENT = DrillOnYarnConfig.append("drill.yarn", "client");
    public static final String APP_NAME = DrillOnYarnConfig.append("drill.yarn", "app-name");
    public static final String CLUSTER_ID = "drill.exec.cluster-id";
    public static final String DFS_CONNECTION = DrillOnYarnConfig.append(DFS_PARENT, "connection");
    public static final String DFS_APP_DIR = DrillOnYarnConfig.append(DFS_PARENT, "app-dir");
    public static final String YARN_QUEUE = DrillOnYarnConfig.append(YARN_PARENT, "queue");
    public static final String YARN_PRIORITY = DrillOnYarnConfig.append(YARN_PARENT, "priority");
    public static final String DRILL_ARCHIVE_PATH = DrillOnYarnConfig.append(FILES_PARENT, "client-path");
    public static final String DRILL_DIR_NAME = DrillOnYarnConfig.append(FILES_PARENT, "dir-name");
    public static final String DRILL_ARCHIVE_KEY = DrillOnYarnConfig.append(FILES_PARENT, "drill-key");
    public static final String SITE_ARCHIVE_KEY = DrillOnYarnConfig.append(FILES_PARENT, "site-key");
    public static final String LOCALIZE_DRILL = DrillOnYarnConfig.append(FILES_PARENT, "localize");
    public static final String CONF_AS_SITE = DrillOnYarnConfig.append(FILES_PARENT, "conf-as-site");
    public static final String DRILL_HOME = DrillOnYarnConfig.append(FILES_PARENT, "drill-home");
    public static final String SITE_DIR = DrillOnYarnConfig.append(FILES_PARENT, "site-dir");
    public static final String JAVA_LIB_PATH = DrillOnYarnConfig.append(FILES_PARENT, "library-path");
    public static final String HADOOP_HOME = DrillOnYarnConfig.append(HADOOP_PARENT, "home");
    public static final String HADOOP_CLASSPATH = DrillOnYarnConfig.append(HADOOP_PARENT, "class-path");
    public static final String HBASE_CLASSPATH = DrillOnYarnConfig.append(HADOOP_PARENT, "hbase-class-path");
    public static final String MEMORY_KEY = "memory-mb";
    public static final String VCORES_KEY = "vcores";
    public static final String DISKS_KEY = "disks";
    public static final String VM_ARGS_KEY = "vm-args";
    public static final String HEAP_KEY = "heap";
    public static final String AM_MEMORY = DrillOnYarnConfig.append(DOY_AM_PARENT, "memory-mb");
    public static final String AM_VCORES = DrillOnYarnConfig.append(DOY_AM_PARENT, "vcores");
    public static final String AM_DISKS = DrillOnYarnConfig.append(DOY_AM_PARENT, "disks");
    public static final String AM_NODE_LABEL_EXPR = DrillOnYarnConfig.append(DOY_AM_PARENT, "node-label-expr");
    public static final String AM_HEAP = DrillOnYarnConfig.append(DOY_AM_PARENT, "heap");
    public static final String AM_VM_ARGS = DrillOnYarnConfig.append(DOY_AM_PARENT, "vm-args");
    public static final String AM_POLL_PERIOD_MS = DrillOnYarnConfig.append(DOY_AM_PARENT, "poll-ms");
    public static final String AM_TICK_PERIOD_MS = DrillOnYarnConfig.append(DOY_AM_PARENT, "tick-ms");
    public static final String AM_PREFIX_CLASSPATH = DrillOnYarnConfig.append(DOY_AM_PARENT, "prefix-class-path");
    public static final String AM_CLASSPATH = DrillOnYarnConfig.append(DOY_AM_PARENT, "class-path");
    public static final String AM_DEBUG_LAUNCH = DrillOnYarnConfig.append(DOY_AM_PARENT, "debug-launch");
    public static final String AM_ENABLE_AUTO_SHUTDOWN = DrillOnYarnConfig.append(DOY_AM_PARENT, "auto-shutdown");
    public static final String DRILLBIT_MEMORY = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "memory-mb");
    public static final String DRILLBIT_VCORES = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "vcores");
    public static final String DRILLBIT_DISKS = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "disks");
    public static final String DRILLBIT_VM_ARGS = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "vm-args");
    public static final String DRILLBIT_HEAP = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "heap");
    public static final String DRILLBIT_DIRECT_MEM = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "max-direct-memory");
    public static final String DRILLBIT_CODE_CACHE = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "code-cache");
    public static final String DRILLBIT_LOG_GC = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "log-gc");
    public static final String DRILLBIT_PREFIX_CLASSPATH = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "prefix-class-path");
    public static final String DRILLBIT_EXTN_CLASSPATH = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "extn-class-path");
    public static final String DRILLBIT_CLASSPATH = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "class-path");
    public static final String DRILLBIT_MAX_RETRIES = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "max-retries");
    public static final String DRILLBIT_DEBUG_LAUNCH = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "debug-launch");
    public static final String DRILLBIT_HTTP_PORT = "drill.exec.http.port";
    public static final String DISABLE_YARN_LOGS = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "disable-yarn-logs");
    public static final String DRILLBIT_USER_PORT = "drill.exec.rpc.user.server.port";
    public static final String DRILLBIT_BIT_PORT = "drill.exec.rpc.bit.server.port";
    public static final String DRILLBIT_USE_HTTPS = "drill.exec.http.ssl_enabled";
    public static final String DRILLBIT_MAX_EXTRA_NODES = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "max-extra-nodes");
    public static final String DRILLBIT_REQUEST_TIMEOUT_SEC = DrillOnYarnConfig.append(DOY_DRILLBIT_PARENT, "request-timeout-secs");
    public static final String ZK_CONNECT = "drill.exec.zk.connect";
    public static final String ZK_ROOT = "drill.exec.zk.root";
    public static final String ZK_FAILURE_TIMEOUT_MS = "drill.exec.zk.timeout";
    public static final String ZK_RETRY_COUNT = "drill.exec.zk.retry.count";
    public static final String ZK_RETRY_DELAY_MS = "drill.exec.zk.retry.delay";
    public static final String HTTP_ENABLED = DrillOnYarnConfig.append(HTTP_PARENT, "enabled");
    public static final String HTTP_ENABLE_SSL = DrillOnYarnConfig.append(HTTP_PARENT, "ssl-enabled");
    public static final String HTTP_PORT = DrillOnYarnConfig.append(HTTP_PARENT, "port");
    public static final String HTTP_AUTH_TYPE = DrillOnYarnConfig.append(HTTP_PARENT, "auth-type");
    public static final String HTTP_REST_KEY = DrillOnYarnConfig.append(HTTP_PARENT, "rest-key");
    public static final String HTTP_SESSION_MAX_IDLE_SECS = DrillOnYarnConfig.append(HTTP_PARENT, "session-max-idle-secs");
    public static final String HTTP_DOCS_LINK = DrillOnYarnConfig.append(HTTP_PARENT, "docs-link");
    public static final String HTTP_REFRESH_SECS = DrillOnYarnConfig.append(HTTP_PARENT, "refresh-secs");
    public static final String HTTP_USER_NAME = DrillOnYarnConfig.append(HTTP_PARENT, "user-name");
    public static final String HTTP_PASSWORD = DrillOnYarnConfig.append(HTTP_PARENT, "password");
    public static final String AUTH_TYPE_NONE = "none";
    public static final String AUTH_TYPE_DRILL = "drill";
    public static final String AUTH_TYPE_SIMPLE = "simple";
    public static final String CLIENT_POLL_SEC = DrillOnYarnConfig.append(CLIENT_PARENT, "poll-sec");
    public static final String CLIENT_START_WAIT_SEC = DrillOnYarnConfig.append(CLIENT_PARENT, "start-wait-sec");
    public static final String CLIENT_STOP_WAIT_SEC = DrillOnYarnConfig.append(CLIENT_PARENT, "stop-wait-sec");
    public static final String CLUSTERS = DrillOnYarnConfig.append("drill.yarn", "cluster");
    public static String LOCAL_DIR_NAME = "drill";
    public static final String APP_ID_ENV_VAR = "DRILL_AM_APP_ID";
    public static final String DRILL_ARCHIVE_ENV_VAR = "DRILL_ARCHIVE";
    public static final String SITE_ARCHIVE_ENV_VAR = "SITE_ARCHIVE";
    public static final String DRILL_HOME_ENV_VAR = "DRILL_HOME";
    public static final String DRILL_SITE_ENV_VAR = "DRILL_CONF_DIR";
    public static final String AM_HEAP_ENV_VAR = "DRILL_AM_HEAP";
    public static final String AM_JAVA_OPTS_ENV_VAR = "DRILL_AM_JAVA_OPTS";
    public static final String DRILL_CLASSPATH_ENV_VAR = "DRILL_CLASSPATH";
    public static final String DRILL_CLASSPATH_PREFIX_ENV_VAR = "DRILL_CLASSPATH_PREFIX";
    public static final String DOY_LIBPATH_ENV_VAR = "DOY_JAVA_LIB_PATH";
    public static final String DRILL_DEBUG_ENV_VAR = "DRILL_DEBUG";
    private static final Object BASE_NAME_MARKER = "<base>";
    public static final String SITE_ARCHIVE_NAME = "site.tar.gz";
    protected static DrillOnYarnConfig instance;
    private File drillSite;
    private File drillHome;
    private static DrillConfig drillConfig;
    private Config config;
    private ScanResult classPathScan;
    private static final String[] keys;
    private static String[] envVars;
    private static String[] suffixes;

    public static String append(String parent, String key) {
        return parent + "." + key;
    }

    protected DrillOnYarnConfig() {
    }

    public static DrillOnYarnConfig load() throws DoyConfigException {
        instance = new DrillOnYarnConfig();
        instance.doLoad(Thread.currentThread().getContextClassLoader());
        return instance;
    }

    protected void doLoad(ClassLoader cl) throws DoyConfigException {
        Config drillConfig = DrillOnYarnConfig.loadDrillConfig();
        URL url = DrillOnYarnConfig.class.getResource(DEFAULTS_FILE_NAME);
        if (url == null) {
            throw new IllegalStateException("Drill-on-YARN defaults file is required: drill-on-yarn-defaults.conf");
        }
        this.config = ConfigFactory.parseURL((URL)url).withFallback((ConfigMergeable)drillConfig);
        url = cl.getResource(DISTRIB_FILE_NAME);
        if (url != null) {
            this.config = ConfigFactory.parseURL((URL)url).withFallback((ConfigMergeable)this.config);
        }
        if ((url = cl.getResource(CONFIG_FILE_NAME)) != null) {
            this.config = ConfigFactory.parseURL((URL)url).withFallback((ConfigMergeable)this.config);
        }
        this.config = ConfigFactory.systemProperties().withFallback((ConfigMergeable)this.config);
        this.config = this.config.resolve();
    }

    private static Config loadDrillConfig() {
        drillConfig = DrillConfig.create((String)"drill-override.conf");
        return drillConfig.resolve();
    }

    public DrillConfig getDrillConfig() {
        return drillConfig;
    }

    public ScanResult getClassPathScan() {
        if (this.classPathScan == null) {
            this.classPathScan = ClassPathScanner.fromPrescan((DrillConfig)drillConfig);
        }
        return this.classPathScan;
    }

    public void setClientPaths() throws DoyConfigException {
        this.setClientDrillHome();
        this.setSiteDir();
    }

    private void setClientDrillHome() throws DoyConfigException {
        String homeDir = this.getEnv(DRILL_HOME_ENV_VAR);
        if (DoYUtil.isBlank(homeDir)) {
            homeDir = this.config.getString(DRILL_HOME);
        }
        if (DoYUtil.isBlank(homeDir)) {
            throw new DoyConfigException("The DRILL_HOME environment variable must point to your Drill install.");
        }
        this.drillHome = new File(homeDir);
    }

    protected String getEnv(String key) {
        return System.getenv(key);
    }

    private void setSiteDir() throws DoyConfigException {
        File archiveFile;
        String drillArchivePath;
        String sitePath = this.getEnv(DRILL_SITE_ENV_VAR);
        if (!DoYUtil.isBlank(sitePath)) {
            this.drillSite = new File(sitePath);
        } else {
            File confFile;
            URL url;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = DrillOnYarnConfig.class.getClassLoader();
            }
            if ((url = classLoader.getResource("drill-override.conf")) == null) {
                throw new DoyConfigException("Drill configuration file is missing: drill-override.conf");
            }
            try {
                Path confPath = Paths.get(url.toURI());
                confFile = confPath.toFile();
            }
            catch (URISyntaxException e) {
                throw new DoyConfigException("Invalid path to Drill-on-YARN configuration file: " + url.toString(), e);
            }
            this.drillSite = confFile.getParentFile();
        }
        if (!(!this.drillHome.equals(this.drillSite.getParentFile()) || this.config.getBoolean(CONF_AS_SITE) || DoYUtil.isBlank(drillArchivePath = this.config.getString(DRILL_ARCHIVE_PATH)) || (archiveFile = new File(drillArchivePath)).isAbsolute() || archiveFile.getAbsolutePath().startsWith(this.drillHome.getAbsolutePath()))) {
            this.drillSite = null;
        }
    }

    public void setAmDrillHome() throws DoyConfigException {
        String drillHomeStr = this.getEnv(DRILL_HOME_ENV_VAR);
        this.drillHome = new File(drillHomeStr);
        this.setSiteDir();
    }

    public Config getConfig() {
        return DrillOnYarnConfig.instance.config;
    }

    public static DrillOnYarnConfig instance() {
        assert (instance != null);
        return instance;
    }

    public static Config config() {
        return DrillOnYarnConfig.instance().getConfig();
    }

    public File getLocalDrillHome() {
        return this.drillHome;
    }

    public void dump() {
        this.dump(System.out);
    }

    private void dump(PrintStream out) {
        for (String key : keys) {
            out.print(key);
            out.print(" = ");
            try {
                out.println(this.config.getString(key));
            }
            catch (ConfigException.Missing e) {
                out.println("<missing>");
            }
        }
        out.print(CLUSTERS);
        out.println("[");
        for (int i = 0; i < this.clusterGroupCount(); ++i) {
            ClusterDef.ClusterGroup cluster = ClusterDef.getCluster(this.config, i);
            out.print(i);
            out.println(" = {");
            cluster.dump("  ", out);
            out.println("  }");
        }
        out.println("]");
    }

    public void dumpEnv(PrintStream out) {
        out.print("environment");
        out.println("[");
        for (String envVar : envVars) {
            String value = this.getEnv(envVar);
            out.print(envVar);
            out.print(" = ");
            if (value == null) {
                out.print("<unset>");
            } else {
                out.print("\"");
                out.print(value);
                out.print("\"");
            }
            out.println();
        }
        out.println("]");
    }

    public List<NameValuePair> getPairs() {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (String key : keys) {
            pairs.add(new NameValuePair(key, this.config.getString(key)));
        }
        for (int i = 0; i < this.clusterGroupCount(); ++i) {
            ClusterDef.ClusterGroup pool = ClusterDef.getCluster(this.config, i);
            pool.getPairs(i, pairs);
        }
        for (String envVar : envVars) {
            pairs.add(new NameValuePair("envt." + envVar, this.getEnv(envVar)));
        }
        return pairs;
    }

    public static String clusterGroupKey(int index, String key) {
        return CLUSTERS + "." + index + "." + key;
    }

    public int clusterGroupCount() {
        return this.config.getList(CLUSTERS).size();
    }

    public static String findSuffix(String baseName) {
        baseName = baseName.toLowerCase();
        for (String extn : suffixes) {
            if (!baseName.endsWith(extn)) continue;
            return extn;
        }
        return null;
    }

    public String getRemoteDrillHome() throws DoyConfigException {
        if (!this.config.getBoolean(LOCALIZE_DRILL)) {
            String drillHomePath = this.config.getString(DRILL_HOME);
            if (DoYUtil.isBlank(drillHomePath)) {
                drillHomePath = this.drillHome.getAbsolutePath();
            }
            return drillHomePath;
        }
        String drillHome = "$PWD/" + this.config.getString(DRILL_ARCHIVE_KEY);
        String home = this.config.getString(DRILL_DIR_NAME);
        if (!DoYUtil.isBlank(home)) {
            if (home.equals(BASE_NAME_MARKER)) {
                String drillArchivePath = this.config.getString(DRILL_ARCHIVE_PATH);
                if (DoYUtil.isBlank(drillArchivePath)) {
                    throw new DoyConfigException("Required config property not set: " + DRILL_ARCHIVE_PATH);
                }
                File localArchiveFile = new File(drillArchivePath);
                home = localArchiveFile.getName();
                String suffix = DrillOnYarnConfig.findSuffix(home);
                if (suffix == null) {
                    throw new DoyConfigException(DRILL_ARCHIVE_PATH + " does not name a valid archive: " + drillArchivePath);
                }
                drillHome = drillHome + "/" + home.substring(0, home.length() - suffix.length());
            } else {
                drillHome = drillHome + "/" + home;
            }
        }
        return drillHome;
    }

    public String getRemoteSiteDir() {
        if (!this.hasSiteDir()) {
            return null;
        }
        if (!this.config.getBoolean(LOCALIZE_DRILL)) {
            String drillSitePath = this.config.getString(SITE_DIR);
            if (DoYUtil.isBlank(drillSitePath)) {
                drillSitePath = this.drillSite.getAbsolutePath();
            }
            return drillSitePath;
        }
        return "$PWD/" + this.config.getString(SITE_ARCHIVE_KEY);
    }

    public File getLocalAppIdFile() {
        String rootDir = this.config.getString(ZK_ROOT);
        String clusterId = this.config.getString(CLUSTER_ID);
        String key = rootDir + "-" + clusterId;
        String appIdFileName = key + ".appid";
        File appIdDir = this.hasSiteDir() ? this.drillSite.getParentFile() : this.drillHome.getParentFile();
        return new File(appIdDir, appIdFileName);
    }

    public boolean hasSiteDir() {
        return this.drillSite != null;
    }

    public File getLocalSiteDir() {
        return this.drillSite;
    }

    public String getDrillArchiveDfsPath() {
        return this.getEnv(DRILL_ARCHIVE_ENV_VAR);
    }

    public String getSiteArchiveDfsPath() {
        return this.getEnv(SITE_ARCHIVE_ENV_VAR);
    }

    static {
        keys = new String[]{APP_NAME, CLUSTER_ID, DFS_CONNECTION, DFS_APP_DIR, HADOOP_HOME, HADOOP_CLASSPATH, HBASE_CLASSPATH, YARN_QUEUE, YARN_PRIORITY, DRILL_ARCHIVE_PATH, DRILL_DIR_NAME, LOCALIZE_DRILL, CONF_AS_SITE, DRILL_HOME, DRILL_ARCHIVE_KEY, SITE_ARCHIVE_KEY, JAVA_LIB_PATH, CLIENT_POLL_SEC, CLIENT_START_WAIT_SEC, CLIENT_STOP_WAIT_SEC, AM_MEMORY, AM_VCORES, AM_DISKS, AM_NODE_LABEL_EXPR, AM_VM_ARGS, AM_HEAP, AM_POLL_PERIOD_MS, AM_TICK_PERIOD_MS, AM_PREFIX_CLASSPATH, AM_CLASSPATH, AM_DEBUG_LAUNCH, AM_ENABLE_AUTO_SHUTDOWN, ZK_CONNECT, ZK_ROOT, ZK_RETRY_COUNT, ZK_RETRY_DELAY_MS, ZK_FAILURE_TIMEOUT_MS, DRILLBIT_MEMORY, DRILLBIT_VCORES, DRILLBIT_DISKS, DRILLBIT_VM_ARGS, DRILLBIT_HEAP, DRILLBIT_DIRECT_MEM, DRILLBIT_CODE_CACHE, DRILLBIT_PREFIX_CLASSPATH, DRILLBIT_EXTN_CLASSPATH, DRILLBIT_CLASSPATH, DRILLBIT_MAX_RETRIES, DRILLBIT_DEBUG_LAUNCH, DRILLBIT_MAX_EXTRA_NODES, DRILLBIT_REQUEST_TIMEOUT_SEC, DISABLE_YARN_LOGS, DRILLBIT_HTTP_PORT, DRILLBIT_USER_PORT, DRILLBIT_BIT_PORT, DRILLBIT_USE_HTTPS, HTTP_ENABLED, HTTP_ENABLE_SSL, HTTP_PORT, HTTP_AUTH_TYPE, HTTP_SESSION_MAX_IDLE_SECS, HTTP_DOCS_LINK, HTTP_REFRESH_SECS};
        envVars = new String[]{APP_ID_ENV_VAR, DRILL_HOME_ENV_VAR, DRILL_SITE_ENV_VAR, AM_HEAP_ENV_VAR, AM_JAVA_OPTS_ENV_VAR, DRILL_CLASSPATH_PREFIX_ENV_VAR, DRILL_CLASSPATH_ENV_VAR, DRILL_ARCHIVE_ENV_VAR, SITE_ARCHIVE_ENV_VAR, DRILL_DEBUG_ENV_VAR};
        suffixes = new String[]{".tar.gz", ".tgz", ".zip"};
    }
}

