/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.core;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigValue;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.drill.yarn.appMaster.TaskSpec;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.drill.yarn.core.NameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterDef {
    private static Logger logger = LoggerFactory.getLogger(ClusterDef.class);
    public static final String GROUP_NAME = "name";
    public static final String GROUP_TYPE = "type";
    public static final String GROUP_SIZE = "count";
    public static final String DRILLBIT_LABEL = "drillbit-label-expr";
    public static final String AM_LABEL = "am-label-expr";

    public static ClusterGroup getCluster(Config config, int n) {
        ClusterGroup tierDef;
        String type;
        int index = n + 1;
        ConfigList tiers = config.getList(DrillOnYarnConfig.CLUSTERS);
        ConfigValue value = (ConfigValue)tiers.get(n);
        if (value == null) {
            throw new IllegalArgumentException("If cluster group is provided, it cannot be null: group " + index);
        }
        Map tier = (Map)value.unwrapped();
        try {
            type = tier.get(GROUP_TYPE).toString();
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Pool type is required for cluster group " + index);
        }
        GroupType groupType = GroupType.toEnum(type);
        if (groupType == null) {
            throw new IllegalArgumentException("Undefined type for cluster group " + index + ": " + type);
        }
        switch (groupType) {
            case BASIC: {
                tierDef = new BasicGroup(tier, index);
                break;
            }
            case LABELED: {
                tierDef = new LabeledGroup(tier, index);
                break;
            }
            default: {
                assert (false);
                throw new IllegalStateException("Undefined cluster group type: " + (Object)((Object)groupType));
            }
        }
        return tierDef;
    }

    public static enum GroupType {
        BASIC,
        LABELED;


        public static GroupType toEnum(String value) {
            return GroupType.valueOf(value.toUpperCase());
        }

        public String toValue() {
            return this.name().toLowerCase();
        }
    }

    public static class BasicGroup
    extends ClusterGroup {
        public BasicGroup(Map<String, Object> pool, int index) {
            super(pool, index, GroupType.BASIC);
        }
    }

    public static class LabeledGroup
    extends ClusterGroup {
        private final String drillbitLabelExpr;

        public LabeledGroup(Map<String, Object> pool, int index) {
            super(pool, index, GroupType.LABELED);
            this.drillbitLabelExpr = (String)pool.get(ClusterDef.DRILLBIT_LABEL);
            if (this.drillbitLabelExpr == null) {
                logger.warn("Labeled pool is missing the drillbit label expression (drillbit-label-expr), will treat pool as basic.");
            }
        }

        public String getLabelExpr() {
            return this.drillbitLabelExpr;
        }

        @Override
        public void dump(String prefix, PrintStream out) {
            out.print(prefix);
            out.print("Drillbit label expr = ");
            out.println(this.drillbitLabelExpr == null ? "<none>" : this.drillbitLabelExpr);
        }

        @Override
        protected void addPairs(List<NameValuePair> pairs, String key) {
            super.addPairs(pairs, key);
            pairs.add(new NameValuePair(DrillOnYarnConfig.append(key, ClusterDef.DRILLBIT_LABEL), this.drillbitLabelExpr));
        }

        @Override
        public void modifyTaskSpec(TaskSpec taskSpec) {
            taskSpec.containerSpec.nodeLabelExpr = this.drillbitLabelExpr;
        }
    }

    public static class ClusterGroup {
        private final String name;
        private final int count;
        private final GroupType type;

        public ClusterGroup(Map<String, Object> group, int index, GroupType type) {
            this.type = type;
            try {
                this.count = (Integer)group.get(ClusterDef.GROUP_SIZE);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Expected an integer for count for tier " + index);
            }
            Object nameValue = group.get(ClusterDef.GROUP_NAME);
            String theName = null;
            if (nameValue != null) {
                theName = nameValue.toString();
            }
            if (DoYUtil.isBlank(theName)) {
                theName = "tier-" + Integer.toString(index);
            }
            this.name = theName;
        }

        public String getName() {
            return this.name;
        }

        public int getCount() {
            return this.count;
        }

        public GroupType getType() {
            return this.type;
        }

        public void getPairs(int index, List<NameValuePair> pairs) {
            String key = DrillOnYarnConfig.append(DrillOnYarnConfig.CLUSTERS, Integer.toString(index));
            this.addPairs(pairs, key);
        }

        protected void addPairs(List<NameValuePair> pairs, String key) {
            pairs.add(new NameValuePair(DrillOnYarnConfig.append(key, ClusterDef.GROUP_NAME), this.name));
            pairs.add(new NameValuePair(DrillOnYarnConfig.append(key, ClusterDef.GROUP_TYPE), (Object)this.type));
            pairs.add(new NameValuePair(DrillOnYarnConfig.append(key, ClusterDef.GROUP_SIZE), this.count));
        }

        public void dump(String prefix, PrintStream out) {
            out.print(prefix);
            out.print("name = ");
            out.println(this.name);
            out.print(prefix);
            out.print("type = ");
            out.println(this.type.toValue());
            out.print(prefix);
            out.print("count = ");
            out.println(this.count);
        }

        public void modifyTaskSpec(TaskSpec taskSpec) {
        }
    }
}

