/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.client;

import org.apache.drill.yarn.client.ClientCommand;
import org.apache.drill.yarn.client.ClientException;
import org.apache.drill.yarn.core.YarnClientException;
import org.apache.drill.yarn.core.YarnRMClient;
import org.apache.hadoop.yarn.api.records.ApplicationId;

public class KillCommand
extends ClientCommand {
    @Override
    public void run() throws ClientException {
        ApplicationId appId = this.checkAppId();
        if (appId == null) {
            System.exit(-1);
        }
        YarnRMClient client = new YarnRMClient(appId);
        try {
            client.killApplication();
        }
        catch (YarnClientException e) {
            throw new ClientException(e);
        }
        System.out.println("Kill request sent, waiting for shut-down.");
        try {
            client.waitForCompletion();
        }
        catch (YarnClientException e) {
            throw new ClientException("Wait for completion failed for app id: " + appId.toString(), e);
        }
        System.out.println("Application completed: " + appId.toString());
    }
}

