/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.drill.yarn.client.ClientException;
import org.apache.drill.yarn.client.CommandLineOptions;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.drill.yarn.core.YarnRMClient;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.ConverterUtils;

public abstract class ClientCommand {
    protected CommandLineOptions opts;

    public void setOpts(CommandLineOptions opts) {
        this.opts = opts;
    }

    public abstract void run() throws ClientException;

    protected static File getAppIdFile() {
        return DrillOnYarnConfig.instance().getLocalAppIdFile();
    }

    protected ApplicationId checkAppId() throws ClientException {
        String appIdStr;
        if (this.opts.appId != null) {
            appIdStr = this.opts.appId;
        } else {
            File appIdFile = ClientCommand.getAppIdFile();
            appIdStr = this.loadAppId(appIdFile);
            if (appIdStr == null) {
                throw new ClientException("No Drill cluster is running (did not find file appid file: " + appIdFile.toString() + ")");
            }
        }
        return ConverterUtils.toApplicationId((String)appIdStr);
    }

    protected YarnRMClient getClient() throws ClientException {
        return new YarnRMClient(this.checkAppId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadAppId(File appIdFile) {
        String appIdStr;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(appIdFile));
            appIdStr = reader.readLine();
            if (appIdStr != null) {
                appIdStr = appIdStr.trim();
            }
        }
        catch (FileNotFoundException e) {
            String string = null;
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return appIdStr;
    }

    protected void removeAppIdFile() {
        ClientCommand.getAppIdFile().delete();
    }
}

