/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.yarn.appMaster.AMYarnFacade;
import org.apache.drill.yarn.appMaster.YarnFacadeException;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NodeReport;

public class NodeInventory {
    private static final Log LOG = LogFactory.getLog(NodeInventory.class);
    private boolean failed;
    private Map<String, String> nodeMap = new HashMap<String, String>();
    private Map<String, NodeReport> yarnNodes = new HashMap<String, NodeReport>();
    private Set<String> nodesInUse = new HashSet<String>();
    private Set<String> blacklist = new HashSet<String>();
    private final AMYarnFacade yarn;

    public NodeInventory(AMYarnFacade yarn) throws YarnFacadeException {
        this.yarn = yarn;
        this.buildNodeMap();
    }

    private void buildNodeMap() throws YarnFacadeException {
        List<NodeReport> nodes = this.yarn.getNodeReports();
        for (NodeReport node : nodes) {
            String hostName = node.getNodeId().getHost();
            this.nodeMap.put(hostName, node.getHttpAddress());
            this.yarnNodes.put(hostName, node);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"YARN Node report");
            for (NodeReport node : nodes) {
                LOG.info((Object)("Node: " + node.getHttpAddress() + ", Rack: " + node.getRackName() + " has " + node.getCapability().getMemory() + " MB, " + node.getCapability().getVirtualCores() + " vcores, labels: " + node.getNodeLabels()));
            }
        }
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void reserve(Container container) {
        this.reserve(container.getNodeId().getHost());
    }

    public void reserve(String hostName) {
        if (this.blacklist.contains(hostName)) {
            LOG.error((Object)("Node to be reserved is in the blacklist: " + hostName));
            this.failed = true;
        }
        if (this.nodesInUse.contains(hostName)) {
            LOG.error((Object)("Node to be reserved is already in use: " + hostName));
            return;
        }
        if (!this.yarnNodes.containsKey(hostName)) {
            LOG.warn((Object)("Node to be reserved was not in YARN node inventory: " + hostName));
        }
        this.nodesInUse.add(hostName);
        this.yarn.blacklistNode(hostName);
    }

    public void release(Container container) {
        this.release(container.getNodeId().getHost());
    }

    public void release(String hostName) {
        if (!this.yarnNodes.containsKey(hostName)) {
            return;
        }
        this.nodesInUse.remove(hostName);
        this.yarn.removeBlacklist(hostName);
    }

    public void blacklist(String hostName) {
        if (!this.yarnNodes.containsKey(hostName)) {
            return;
        }
        assert (!this.nodesInUse.contains(hostName));
        this.blacklist.add(hostName);
        this.yarn.blacklistNode(hostName);
        LOG.info((Object)("Node blacklisted: " + hostName));
    }

    public int getFreeNodeCount() {
        HashSet<String> free = new HashSet<String>();
        free.addAll(this.yarnNodes.keySet());
        free.removeAll(this.nodesInUse);
        free.removeAll(this.blacklist);
        return free.size();
    }

    public List<String> getBlacklist() {
        ArrayList<String> copy = new ArrayList<String>();
        copy.addAll(this.blacklist);
        return copy;
    }

    public boolean isInUse(String hostName) {
        return this.blacklist.contains(hostName) || this.nodesInUse.contains(hostName);
    }
}

