/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.yarn.appMaster.AMException;
import org.apache.drill.yarn.appMaster.AbstractTaskManager;
import org.apache.drill.yarn.appMaster.Scheduler;
import org.apache.drill.yarn.appMaster.SchedulerState;
import org.apache.drill.yarn.appMaster.Task;
import org.apache.drill.yarn.appMaster.TaskSpec;
import org.apache.drill.yarn.core.ContainerRequestSpec;
import org.apache.hadoop.yarn.api.records.Resource;

public abstract class AbstractScheduler
implements Scheduler {
    private static final Log LOG = LogFactory.getLog(AbstractScheduler.class);
    private final String name;
    private final String type;
    protected TaskSpec taskSpec;
    protected int priority;
    protected int failCount;
    protected Scheduler.TaskManager taskManager;
    protected SchedulerState state;
    protected boolean isTracked;

    public AbstractScheduler(String type, String name) {
        this.type = type;
        this.name = name;
        this.taskManager = new AbstractTaskManager();
    }

    public void setTaskManager(Scheduler.TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Override
    public void registerState(SchedulerState state) {
        this.state = state;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.taskSpec.containerSpec.priority = priority;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Scheduler.TaskManager getTaskManager() {
        return this.taskManager;
    }

    @Override
    public void change(int delta) {
        this.resize(this.getTarget() + delta);
    }

    protected void addTasks(int n) {
        LOG.info((Object)("[" + this.getName() + "] - Adding " + n + " tasks"));
        for (int i = 0; i < n; ++i) {
            this.state.start(new Task(this, this.taskSpec));
        }
    }

    @Override
    public boolean isTracked() {
        return this.isTracked;
    }

    @Override
    public ContainerRequestSpec getResource() {
        return this.taskSpec.containerSpec;
    }

    @Override
    public void limitContainerSize(Resource maxResource) throws AMException {
        if (this.taskSpec.containerSpec.memoryMb > maxResource.getMemory()) {
            LOG.warn((Object)(this.taskSpec.name + " requires " + this.taskSpec.containerSpec.memoryMb + " MB but the maximum YARN container size is " + maxResource.getMemory() + " MB"));
            this.taskSpec.containerSpec.memoryMb = maxResource.getMemory();
        }
        if (this.taskSpec.containerSpec.vCores > maxResource.getVirtualCores()) {
            LOG.warn((Object)(this.taskSpec.name + " requires " + this.taskSpec.containerSpec.vCores + " vcores but the maximum YARN container size is " + maxResource.getVirtualCores() + " vcores"));
            this.taskSpec.containerSpec.vCores = maxResource.getVirtualCores();
        }
    }

    @Override
    public int getRequestTimeoutSec() {
        return 0;
    }
}

