/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.yarn.appMaster.AbstractTaskManager;
import org.apache.drill.yarn.appMaster.EventContext;
import org.apache.drill.yarn.appMaster.PersistentTaskScheduler;
import org.apache.drill.yarn.appMaster.Task;
import org.apache.drill.yarn.zk.ZKRegistry;

public abstract class AbstractDrillbitScheduler
extends PersistentTaskScheduler {
    private static final Log LOG = LogFactory.getLog(AbstractDrillbitScheduler.class);

    public AbstractDrillbitScheduler(String type, String name, int quantity) {
        super(type, name, quantity);
        this.isTracked = true;
        this.setTaskManager(new DrillbitManager());
    }

    public class DrillbitManager
    extends AbstractTaskManager {
        @Override
        public int maxConcurrentAllocs() {
            return 1;
        }

        @Override
        public void allocated(EventContext context) {
            context.controller.getNodeInventory().reserve(context.task.container);
        }

        @Override
        public void completed(EventContext context) {
            if (context.task.container != null) {
                context.controller.getNodeInventory().release(context.task.container);
            }
            this.analyzeResult(context);
        }

        @Override
        public boolean isLive(EventContext context) {
            ZKRegistry reg = (ZKRegistry)context.controller.getProperty("zk");
            return reg.isRegistered(context.task);
        }

        private void analyzeResult(EventContext context) {
            boolean registered;
            Task task = context.task;
            if (task.isCancelled()) {
                return;
            }
            int exitCode = task.completionStatus.getExitStatus();
            long duration = task.uptime() / 1000L;
            boolean bl = registered = task.trackingState != Task.TrackingState.NEW;
            if (registered || task.getTryCount() < 2) {
                return;
            }
            String hostName = task.getHostName();
            StringBuilder buf = new StringBuilder();
            buf.append(task.getLabel()).append(" on host ").append(hostName).append(" failed with status ").append(exitCode).append(" after ").append(duration).append(" secs. with");
            if (!registered) {
                buf.append("out");
            }
            buf.append(" ZK registration");
            if (duration < 60L && !registered) {
                buf.append("\n    Probable configuration problem, check Drill log file on host ").append(hostName).append(".");
            }
            LOG.error((Object)buf.toString());
            task.cancelled = true;
            context.controller.getNodeInventory().blacklist(hostName);
        }
    }
}

