/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.transform;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.expressions.FilterExpression;
import org.apache.drill.metastore.iceberg.transform.FilterExpressionVisitor;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;

public class FilterTransformer {
    private static final FilterExpression.Visitor<Expression> FILTER_VISITOR = FilterExpressionVisitor.get();

    public Expression transform(FilterExpression filter) {
        return filter == null ? Expressions.alwaysTrue() : (Expression)filter.accept(FILTER_VISITOR);
    }

    public Expression transform(Map<MetastoreColumn, Object> conditions) {
        if (conditions == null || conditions.isEmpty()) {
            return Expressions.alwaysTrue();
        }
        List expressions = conditions.entrySet().stream().map(entry -> Expressions.equal((String)((MetastoreColumn)entry.getKey()).columnName(), entry.getValue())).collect(Collectors.toList());
        if (expressions.size() == 1) {
            return (Expression)expressions.get(0);
        }
        return Expressions.and((Expression)((Expression)expressions.get(0)), (Expression)((Expression)expressions.get(1)), (Expression[])expressions.subList(2, expressions.size()).toArray(new Expression[0]));
    }

    public Expression transform(Set<MetadataType> metadataTypes) {
        if (metadataTypes.contains(MetadataType.ALL)) {
            return Expressions.alwaysTrue();
        }
        Set inConditionValues = metadataTypes.stream().map(Enum::name).collect(Collectors.toSet());
        if (inConditionValues.size() == 1) {
            return Expressions.equal((String)MetastoreColumn.METADATA_TYPE.columnName(), (Object)((String)inConditionValues.iterator().next()));
        }
        return Expressions.in((String)MetastoreColumn.METADATA_TYPE.columnName(), inConditionValues);
    }

    public Expression combine(Expression ... expressions) {
        if (expressions.length == 0) {
            return Expressions.alwaysTrue();
        }
        if (expressions.length == 1) {
            return expressions[0];
        }
        return Expressions.and((Expression)expressions[0], (Expression)expressions[1], (Expression[])Arrays.copyOfRange(expressions, 2, expressions.length));
    }
}

