/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.operate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.drill.metastore.expressions.FilterExpression;
import org.apache.drill.metastore.iceberg.IcebergMetastoreContext;
import org.apache.drill.metastore.iceberg.operate.IcebergOperation;
import org.apache.drill.metastore.iceberg.transform.OperationTransformer;
import org.apache.drill.metastore.operate.AbstractModify;
import org.apache.drill.metastore.operate.Delete;
import org.apache.drill.metastore.operate.MetadataTypeValidator;
import org.apache.iceberg.Transaction;

public class IcebergModify<T>
extends AbstractModify<T> {
    private final OperationTransformer<T> transformer;
    private final IcebergMetastoreContext<T> context;
    private final List<IcebergOperation> operations = new ArrayList<IcebergOperation>();

    public IcebergModify(MetadataTypeValidator metadataTypeValidator, IcebergMetastoreContext<T> context) {
        super(metadataTypeValidator);
        this.context = context;
        this.transformer = context.transformer().operation();
    }

    public void execute() {
        if (this.operations.isEmpty()) {
            return;
        }
        this.executeOperations(this.operations);
    }

    public void purge() {
        this.executeOperations(Collections.singletonList(this.transformer.toDelete((FilterExpression)null)));
    }

    protected void addOverwrite(List<T> units) {
        this.operations.addAll(this.transformer.toOverwrite(units));
    }

    protected void addDelete(Delete delete) {
        this.operations.add(this.transformer.toDelete(delete));
    }

    private void executeOperations(List<IcebergOperation> operations) {
        Transaction transaction = this.context.table().newTransaction();
        operations.forEach(op -> op.add(transaction));
        transaction.commitTransaction();
        this.context.expirationHandler().expireQuietly();
    }
}

