/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.components.tables;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.iceberg.exceptions.IcebergMetastoreException;
import org.apache.drill.metastore.iceberg.transform.OutputDataTransformer;

public class TablesOutputDataTransformer
extends OutputDataTransformer<TableMetadataUnit> {
    public TablesOutputDataTransformer(Map<String, MethodHandle> unitSetters) {
        super(unitSetters);
    }

    @Override
    public List<TableMetadataUnit> execute() {
        ArrayList<TableMetadataUnit> results = new ArrayList<TableMetadataUnit>();
        for (Map<MethodHandle, Object> valueToSet : this.valuesToSet()) {
            TableMetadataUnit.Builder builder = TableMetadataUnit.builder();
            for (Map.Entry<MethodHandle, Object> entry : valueToSet.entrySet()) {
                try {
                    entry.getKey().invokeWithArguments(builder, entry.getValue());
                }
                catch (Throwable e) {
                    throw new IcebergMetastoreException(String.format("Unable to invoke setter for [%s] using [%s]", TableMetadataUnit.Builder.class.getSimpleName(), entry.getKey()), e);
                }
            }
            results.add(builder.build());
        }
        return results;
    }
}

