/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch.schema;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.elasticsearch.schema.ElasticsearchDynamicTable;

public class ElasticsearchDrillSchema
extends AbstractSchema {
    private final Schema delegatingSchema;
    private final StoragePlugin plugin;
    private final Map<String, Table> tables = new ConcurrentHashMap<String, Table>();

    public ElasticsearchDrillSchema(String name, StoragePlugin plugin, Schema delegatingSchema) {
        super(Collections.emptyList(), name);
        this.plugin = plugin;
        this.delegatingSchema = delegatingSchema;
    }

    public String getTypeName() {
        return "elastic";
    }

    public Table getTable(String tableName) {
        return this.tables.computeIfAbsent(tableName, this::getDrillTable);
    }

    private DrillTable getDrillTable(String tableName) {
        Table table = this.delegatingSchema.getTable(tableName);
        return table == null ? null : new ElasticsearchDynamicTable(this.plugin, tableName, null, table);
    }

    public Set<String> getTableNames() {
        return this.delegatingSchema.getTableNames();
    }

    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return this.delegatingSchema.getExpression(parentSchema, name);
    }
}

