/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.adapter.elasticsearch.CalciteUtils;
import org.apache.calcite.adapter.elasticsearch.DrillElasticsearchTableScan;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchAggregate;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchFilter;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchProject;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSort;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;

public class ElasticPlanTransformer
extends RelShuttleImpl {
    private boolean hasProject = false;
    private RelDataTypeField mapField;

    public RelNode visit(TableScan other) {
        RelOptTableImpl table = (RelOptTableImpl)other.getTable();
        ElasticsearchTable elasticsearchTable = Objects.requireNonNull((ElasticsearchTable)table.unwrap(ElasticsearchTable.class), "ElasticSearch table cannot be null");
        RelDataType rowType = elasticsearchTable.getRowType(other.getCluster().getTypeFactory());
        this.mapField = (RelDataTypeField)rowType.getFieldList().get(0);
        return new DrillElasticsearchTableScan(other.getCluster(), other.getTraitSet(), (RelOptTable)table.copy(rowType), elasticsearchTable, rowType);
    }

    public RelNode visit(RelNode other) {
        if (other instanceof ElasticsearchProject) {
            ElasticsearchProject project = (ElasticsearchProject)other;
            RelNode input = project.getInput().accept((RelShuttle)this);
            List convertedExpressions = project.getProjects();
            if (!this.hasProject) {
                ElasticExpressionMapper expressionMapper = new ElasticExpressionMapper(project.getCluster().getRexBuilder(), project.getInput().getRowType(), this.mapField);
                convertedExpressions = convertedExpressions.stream().map(expression -> (RexNode)expression.accept((RexVisitor)expressionMapper)).collect(Collectors.toList());
                RelRecordType relDataType = this.getRelRecordType(other.getRowType());
                this.hasProject = true;
                return CalciteUtils.createProject(project.getTraitSet(), input, convertedExpressions, (RelDataType)relDataType);
            }
            return input;
        }
        if (other instanceof ElasticsearchFilter) {
            ElasticsearchFilter filter = (ElasticsearchFilter)other;
            RexNode convertedCondition = (RexNode)filter.getCondition().accept((RexVisitor)new ElasticExpressionMapper(other.getCluster().getRexBuilder(), filter.getInput().getRowType(), this.mapField));
            return filter.copy(other.getTraitSet(), filter.getInput().accept((RelShuttle)this), convertedCondition);
        }
        if (other instanceof ElasticsearchSort) {
            ElasticsearchSort sort = (ElasticsearchSort)other;
            RelNode input = this.getMappedInput(sort.getInput());
            return sort.copy(other.getTraitSet(), input, sort.getCollation(), sort.offset, sort.fetch);
        }
        if (other instanceof ElasticsearchAggregate) {
            ElasticsearchAggregate aggregate = (ElasticsearchAggregate)other;
            RelNode input = this.getMappedInput(aggregate.getInput());
            return aggregate.copy(other.getTraitSet(), input, aggregate.getGroupSet(), (List)aggregate.getGroupSets(), aggregate.getAggCallList());
        }
        return super.visit(other);
    }

    private RelNode getMappedInput(RelNode relNode) {
        boolean hasProject = this.hasProject;
        this.hasProject = false;
        RelNode input = relNode.accept((RelShuttle)this);
        if (!this.hasProject) {
            this.hasProject = hasProject;
            RelOptCluster cluster = relNode.getCluster();
            List projections = IntStream.range(0, relNode.getRowType().getFieldCount()).mapToObj(i -> cluster.getRexBuilder().makeInputRef(relNode, i)).collect(Collectors.toList());
            return CalciteUtils.createProject(relNode.getTraitSet(), relNode, projections, relNode.getRowType()).accept((RelShuttle)this);
        }
        return input;
    }

    private RelRecordType getRelRecordType(RelDataType rowType) {
        ArrayList<RelDataTypeField> fields = new ArrayList<RelDataTypeField>();
        for (RelDataTypeField relDataTypeField : rowType.getFieldList()) {
            if (relDataTypeField.isDynamicStar()) {
                fields.add(this.mapField);
                continue;
            }
            fields.add(relDataTypeField);
        }
        return new RelRecordType(StructKind.FULLY_QUALIFIED, fields, false);
    }

    public static class ElasticExpressionMapper
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final RelDataType relDataType;
        private final RelDataTypeField mapField;

        public ElasticExpressionMapper(RexBuilder rexBuilder, RelDataType relDataType, RelDataTypeField mapField) {
            this.rexBuilder = rexBuilder;
            this.relDataType = relDataType;
            this.mapField = mapField;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            if (inputRef.getType().getSqlTypeName() == SqlTypeName.DYNAMIC_STAR) {
                return this.rexBuilder.makeInputRef(this.mapField.getType(), 0);
            }
            return this.rexBuilder.makeCall(SqlStdOperatorTable.ITEM, new RexNode[]{this.rexBuilder.makeInputRef(this.relDataType, 0), this.rexBuilder.makeLiteral((String)this.relDataType.getFieldNames().get(inputRef.getIndex()))});
        }
    }
}

