/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.calcite.adapter.elasticsearch.CalciteUtils;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.planner.PlannerPhase;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.elasticsearch.ElasticsearchStorageConfig;
import org.apache.drill.exec.store.elasticsearch.schema.ElasticsearchDrillSchemaFactory;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchStoragePlugin
extends AbstractStoragePlugin {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchStoragePlugin.class);
    private final ElasticsearchStorageConfig config;
    private final ElasticsearchDrillSchemaFactory schemaFactory;

    public ElasticsearchStoragePlugin(ElasticsearchStorageConfig config, DrillbitContext context, String name) {
        super(context, name);
        this.config = config;
        this.schemaFactory = new ElasticsearchDrillSchemaFactory(name, this);
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws JsonProcessingException {
        Optional<UsernamePasswordCredentials> userCreds;
        if (this.config.getAuthMode() == StoragePluginConfig.AuthMode.USER_TRANSLATION && !(userCreds = this.config.getUsernamePasswordCredentials(schemaConfig.getUserName())).isPresent()) {
            logger.debug("No schemas will be registered in {} for query user {}.", (Object)this.getName(), (Object)schemaConfig.getUserName());
            return;
        }
        this.schemaFactory.registerSchemas(schemaConfig, parent);
    }

    public ElasticsearchStorageConfig getConfig() {
        return this.config;
    }

    public boolean supportsRead() {
        return true;
    }

    public Set<? extends RelOptRule> getOptimizerRules(OptimizerRulesContext optimizerContext, PlannerPhase phase) {
        switch (phase) {
            case PHYSICAL: 
            case LOGICAL: {
                return CalciteUtils.elasticSearchRules();
            }
        }
        return Collections.emptySet();
    }
}

