/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo.schema;

import com.mongodb.MongoException;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.AbstractSchemaFactory;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.mongo.MongoScanSpec;
import org.apache.drill.exec.store.mongo.MongoStoragePlugin;
import org.apache.drill.exec.store.mongo.schema.MongoDatabaseSchema;
import org.apache.drill.exec.store.plan.rel.PluginDrillTable;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheBuilder;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheLoader;
import org.apache.drill.shaded.guava.com.google.common.cache.LoadingCache;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoSchemaFactory
extends AbstractSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(MongoSchemaFactory.class);
    private static final String DATABASES = "databases";
    private final LoadingCache<String, List<String>> databases;
    private final LoadingCache<String, List<String>> tableNameLoader;
    private final Map<String, String> schemaNameMap;
    private final MongoStoragePlugin plugin;

    public MongoSchemaFactory(MongoStoragePlugin plugin, String schemaName) {
        super(schemaName);
        this.plugin = plugin;
        this.schemaNameMap = new HashMap<String, String>();
        this.databases = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new DatabaseLoader());
        this.tableNameLoader = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new TableNameLoader());
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) {
        MongoSchema schema = new MongoSchema(this.getName());
        SchemaPlus hPlus = parent.add(this.getName(), (Schema)schema);
        schema.setHolder(hPlus);
    }

    private class DatabaseLoader
    extends CacheLoader<String, List<String>> {
        private DatabaseLoader() {
        }

        public List<String> load(String key) {
            if (!MongoSchemaFactory.DATABASES.equals(key)) {
                throw new UnsupportedOperationException();
            }
            try {
                ArrayList<String> dbNames = new ArrayList<String>();
                MongoSchemaFactory.this.plugin.getClient().listDatabaseNames().forEach(name -> {
                    dbNames.add(name.toLowerCase());
                    MongoSchemaFactory.this.schemaNameMap.put(name.toLowerCase(), name);
                });
                return dbNames;
            }
            catch (MongoException me) {
                logger.warn("Failure while loading databases in Mongo. {}", (Object)me.getMessage());
                return Collections.emptyList();
            }
            catch (Exception e) {
                throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private class TableNameLoader
    extends CacheLoader<String, List<String>> {
        private TableNameLoader() {
        }

        public List<String> load(String dbName) {
            try {
                MongoDatabase db = MongoSchemaFactory.this.plugin.getClient().getDatabase((String)MongoSchemaFactory.this.schemaNameMap.get(dbName));
                ArrayList<String> collectionNames = new ArrayList<String>();
                db.listCollectionNames().into(collectionNames);
                return collectionNames;
            }
            catch (MongoException me) {
                logger.warn("Failure while getting collection names from '{}'. {}", (Object)dbName, (Object)me.getMessage());
                return Collections.emptyList();
            }
            catch (Exception e) {
                throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
    }

    class MongoSchema
    extends AbstractSchema {
        private final Map<String, MongoDatabaseSchema> schemaMap;

        public MongoSchema(String name) {
            super(Collections.emptyList(), name);
            this.schemaMap = Maps.newHashMap();
        }

        public AbstractSchema getSubSchema(String name) {
            try {
                if (!this.schemaMap.containsKey(name)) {
                    List tables = (List)MongoSchemaFactory.this.tableNameLoader.get((Object)name);
                    this.schemaMap.put(name, new MongoDatabaseSchema(tables, this, name));
                }
                return this.schemaMap.get(name);
            }
            catch (ExecutionException e) {
                logger.warn("Failure while attempting to access MongoDataBase '{}'.", (Object)name, (Object)e.getCause());
                return null;
            }
        }

        void setHolder(SchemaPlus plusOfThis) {
            for (String s : this.getSubSchemaNames()) {
                plusOfThis.add(s, (Schema)this.getSubSchema(s));
            }
        }

        public boolean showInInformationSchema() {
            return false;
        }

        public Set<String> getSubSchemaNames() {
            try {
                List dbs = (List)MongoSchemaFactory.this.databases.get((Object)MongoSchemaFactory.DATABASES);
                return Sets.newHashSet((Iterable)dbs);
            }
            catch (ExecutionException e) {
                logger.warn("Failure while getting Mongo database list.", (Throwable)e);
                return Collections.emptySet();
            }
        }

        List<String> getTableNames(String dbName) {
            try {
                return (List)MongoSchemaFactory.this.tableNameLoader.get((Object)dbName);
            }
            catch (ExecutionException e) {
                logger.warn("Failure while loading table names for database '{}'.", (Object)dbName, (Object)e.getCause());
                return Collections.emptyList();
            }
        }

        DrillTable getDrillTable(String dbName, String collectionName) {
            MongoScanSpec mongoScanSpec = new MongoScanSpec((String)MongoSchemaFactory.this.schemaNameMap.get(dbName), collectionName);
            return new PluginDrillTable((StoragePlugin)MongoSchemaFactory.this.plugin, this.getName(), null, (DrillTableSelection)mongoScanSpec, MongoSchemaFactory.this.plugin.convention());
        }

        public String getTypeName() {
            return "mongo";
        }
    }
}

