/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Aggregates;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.bson.BsonRecordReader;
import org.apache.drill.exec.store.mongo.BaseMongoSubScanSpec;
import org.apache.drill.exec.store.mongo.MongoStoragePlugin;
import org.apache.drill.exec.store.mongo.MongoSubScan;
import org.apache.drill.exec.store.mongo.MongoUtils;
import org.apache.drill.exec.vector.complex.fn.JsonReader;
import org.apache.drill.exec.vector.complex.impl.VectorContainerWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonReader;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoRecordReader
extends AbstractRecordReader {
    private static final Logger logger = LoggerFactory.getLogger(MongoRecordReader.class);
    private MongoCollection<BsonDocument> collection;
    private MongoCursor<BsonDocument> cursor;
    private JsonReader jsonReader;
    private BsonRecordReader bsonReader;
    private VectorContainerWriter writer;
    private Document filters;
    private List<Bson> operations;
    private final Document fields = new Document();
    private final FragmentContext fragmentContext;
    private final MongoStoragePlugin plugin;
    private final boolean enableAllTextMode;
    private final boolean enableNanInf;
    private final boolean readNumbersAsDouble;
    private boolean unionEnabled;
    private final boolean isBsonRecordReader;

    public MongoRecordReader(BaseMongoSubScanSpec subScanSpec, List<SchemaPath> projectedColumns, FragmentContext context, MongoStoragePlugin plugin) {
        this.fields.put("_id", (Object)0);
        this.setColumns(projectedColumns);
        this.fragmentContext = context;
        this.plugin = plugin;
        this.filters = new Document();
        if (subScanSpec instanceof MongoSubScan.MongoSubScanSpec) {
            this.operations = ((MongoSubScan.MongoSubScanSpec)subScanSpec).getOperations().stream().map(BsonDocument::parse).collect(Collectors.toList());
        } else {
            MongoSubScan.ShardedMongoSubScanSpec shardedMongoSubScanSpec = (MongoSubScan.ShardedMongoSubScanSpec)subScanSpec;
            Map<String, List<Document>> mergedFilters = MongoUtils.mergeFilters(shardedMongoSubScanSpec.getMinFilters(), shardedMongoSubScanSpec.getMaxFilters());
            Document pushdownFilters = Optional.ofNullable(shardedMongoSubScanSpec.getFilter()).map(Document::parse).orElse(null);
            this.buildFilters(pushdownFilters, mergedFilters);
        }
        this.enableAllTextMode = this.fragmentContext.getOptions().getOption((String)"store.mongo.all_text_mode").bool_val;
        this.enableNanInf = this.fragmentContext.getOptions().getOption((String)"store.json.reader.allow_nan_inf").bool_val;
        this.readNumbersAsDouble = this.fragmentContext.getOptions().getOption((String)"store.mongo.read_numbers_as_double").bool_val;
        this.isBsonRecordReader = this.fragmentContext.getOptions().getOption((String)"store.mongo.bson.record.reader").bool_val;
        logger.debug("BsonRecordReader is enabled? " + this.isBsonRecordReader);
        this.init(subScanSpec);
    }

    protected Collection<SchemaPath> transformColumns(Collection<SchemaPath> projectedColumns) {
        LinkedHashSet transformed = Sets.newLinkedHashSet();
        if (!this.isStarQuery()) {
            for (SchemaPath column : projectedColumns) {
                String fieldName = column.getRootSegment().getPath();
                transformed.add(column);
                this.fields.put(fieldName, (Object)1);
            }
        } else {
            this.fields.remove((Object)"_id");
            transformed.add(SchemaPath.STAR_COLUMN);
        }
        return transformed;
    }

    private void buildFilters(Document pushdownFilters, Map<String, List<Document>> mergedFilters) {
        for (Map.Entry<String, List<Document>> entry : mergedFilters.entrySet()) {
            List<Document> list = entry.getValue();
            if (list.size() == 1) {
                this.filters.putAll((Map)list.get(0));
                continue;
            }
            Document andQueryFilter = new Document();
            andQueryFilter.put("$and", list);
            this.filters.putAll((Map)andQueryFilter);
        }
        if (pushdownFilters != null && !pushdownFilters.isEmpty()) {
            this.filters = !mergedFilters.isEmpty() ? MongoUtils.andFilterAtIndex(this.filters, pushdownFilters) : pushdownFilters;
        }
    }

    private void init(BaseMongoSubScanSpec subScanSpec) {
        List<String> hosts = subScanSpec.getHosts();
        ArrayList addresses = Lists.newArrayList();
        for (String host : hosts) {
            addresses.add(new ServerAddress(host));
        }
        MongoClient client = this.plugin.getClient(addresses);
        MongoDatabase db = client.getDatabase(subScanSpec.getDbName());
        this.unionEnabled = this.fragmentContext.getOptions().getBoolean("exec.enable_union_type");
        this.collection = db.getCollection(subScanSpec.getCollectionName(), BsonDocument.class);
    }

    public void setup(OperatorContext context, OutputMutator output) throws ExecutionSetupException {
        this.writer = new VectorContainerWriter(output, this.unionEnabled);
        if (this.isBsonRecordReader) {
            this.bsonReader = new BsonRecordReader(this.fragmentContext.getManagedBuffer(), Lists.newArrayList((Iterable)this.getColumns()), this.readNumbersAsDouble);
            logger.debug("Initialized BsonRecordReader. ");
        } else {
            this.jsonReader = new JsonReader.Builder(this.fragmentContext.getManagedBuffer()).schemaPathColumns((List)Lists.newArrayList((Iterable)this.getColumns())).allTextMode(this.enableAllTextMode).readNumbersAsDouble(this.readNumbersAsDouble).enableNanInf(this.enableNanInf).build();
            logger.debug(" Intialized JsonRecordReader. ");
        }
    }

    public int next() {
        int docCount;
        if (this.cursor == null) {
            FindIterable projection;
            logger.debug("Filters Applied : " + this.filters);
            logger.debug("Fields Selected :" + this.fields);
            if (CollectionUtils.isNotEmpty(this.operations)) {
                ArrayList<Bson> operations = new ArrayList<Bson>(this.operations);
                if (!this.fields.isEmpty()) {
                    operations.add(Aggregates.project((Bson)this.fields));
                }
                projection = this.plugin.getConfig().allowDiskUse() ? this.collection.aggregate(operations).allowDiskUse(Boolean.valueOf(true)) : this.collection.aggregate(operations);
            } else {
                projection = this.collection.find((Bson)this.filters).projection((Bson)this.fields);
            }
            this.cursor = projection.batchSize(this.plugin.getConfig().getBatchSize()).iterator();
        }
        this.writer.allocate();
        this.writer.reset();
        Stopwatch watch = Stopwatch.createStarted();
        try {
            for (docCount = 0; docCount < 4096 && this.cursor.hasNext(); ++docCount) {
                this.writer.setPosition(docCount);
                if (this.isBsonRecordReader) {
                    BsonDocument bsonDocument = (BsonDocument)this.cursor.next();
                    this.bsonReader.write((BaseWriter.ComplexWriter)this.writer, (BsonReader)new BsonDocumentReader(bsonDocument));
                    continue;
                }
                String doc = ((BsonDocument)this.cursor.next()).toJson();
                this.jsonReader.setSource(doc.getBytes(Charsets.UTF_8));
                this.jsonReader.write((BaseWriter.ComplexWriter)this.writer);
            }
            if (this.isBsonRecordReader) {
                this.bsonReader.ensureAtLeastOneField((BaseWriter.ComplexWriter)this.writer);
            } else {
                this.jsonReader.ensureAtLeastOneField((BaseWriter.ComplexWriter)this.writer);
            }
            this.writer.setValueCount(docCount);
            logger.debug("Took {} ms to get {} records", (Object)watch.elapsed(TimeUnit.MILLISECONDS), (Object)docCount);
            return docCount;
        }
        catch (IOException e) {
            String msg = "Failure while reading document. - Parser was at record: " + (docCount + 1);
            logger.error(msg, (Throwable)e);
            throw new DrillRuntimeException(msg, (Throwable)e);
        }
    }

    public void close() {
    }

    public String toString() {
        BsonRecordReader reader = this.isBsonRecordReader ? this.bsonReader : this.jsonReader;
        return "MongoRecordReader[reader=" + reader + "]";
    }
}

