/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.mongo.BaseMongoSubScanSpec;
import org.apache.drill.exec.store.mongo.DrillMongoConstants;
import org.apache.drill.exec.store.mongo.MongoScanSpec;
import org.apache.drill.exec.store.mongo.MongoStoragePlugin;
import org.apache.drill.exec.store.mongo.MongoStoragePluginConfig;
import org.apache.drill.exec.store.mongo.MongoSubScan;
import org.apache.drill.exec.store.mongo.common.ChunkInfo;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.bson.Document;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.Encoder;
import org.bson.conversions.Bson;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="mongo-scan")
public class MongoGroupScan
extends AbstractGroupScan
implements DrillMongoConstants {
    private static final int SELECT = 1;
    private static final Comparator<List<BaseMongoSubScanSpec>> LIST_SIZE_COMPARATOR = Comparator.comparingInt(List::size);
    private static final Comparator<List<BaseMongoSubScanSpec>> LIST_SIZE_COMPARATOR_REV = Collections.reverseOrder(LIST_SIZE_COMPARATOR);
    private static final Logger logger = LoggerFactory.getLogger(MongoGroupScan.class);
    private MongoStoragePlugin storagePlugin;
    private MongoStoragePluginConfig storagePluginConfig;
    private MongoScanSpec scanSpec;
    private List<SchemaPath> columns;
    private Map<Integer, List<BaseMongoSubScanSpec>> endpointFragmentMapping;
    private Map<String, Set<ServerAddress>> chunksMapping;
    private Map<String, List<ChunkInfo>> chunksInverseMapping;
    private final Stopwatch watch = Stopwatch.createUnstarted();
    private boolean useAggregate;

    @JsonCreator
    public MongoGroupScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="mongoScanSpec") MongoScanSpec scanSpec, @JsonProperty(value="storage") MongoStoragePluginConfig storagePluginConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="useAggregate") boolean useAggregate, @JacksonInject StoragePluginRegistry pluginRegistry) {
        this(userName, (MongoStoragePlugin)pluginRegistry.resolve((StoragePluginConfig)storagePluginConfig, MongoStoragePlugin.class), scanSpec, columns, useAggregate);
    }

    public MongoGroupScan(String userName, MongoStoragePlugin storagePlugin, MongoScanSpec scanSpec, List<SchemaPath> columns, boolean useAggregate) {
        super(userName);
        this.storagePlugin = storagePlugin;
        this.storagePluginConfig = storagePlugin.getConfig();
        this.scanSpec = scanSpec;
        this.columns = columns;
        this.useAggregate = useAggregate;
        this.init();
    }

    private MongoGroupScan(MongoGroupScan that) {
        super((AbstractGroupScan)that);
        this.scanSpec = that.scanSpec;
        this.columns = that.columns;
        this.storagePlugin = that.storagePlugin;
        this.storagePluginConfig = that.storagePluginConfig;
        this.chunksMapping = that.chunksMapping;
        this.chunksInverseMapping = that.chunksInverseMapping;
        this.endpointFragmentMapping = that.endpointFragmentMapping;
        this.useAggregate = that.useAggregate;
    }

    private boolean isShardedCluster(MongoClient client) {
        MongoDatabase db = client.getDatabase(this.scanSpec.getDbName());
        String msg = db.runCommand((Bson)new Document("isMaster", (Object)1)).getString((Object)"msg");
        return msg != null && msg.equals("isdbgrid");
    }

    private void init() {
        List<String> h = this.storagePluginConfig.getHosts();
        ArrayList addresses = Lists.newArrayList();
        for (String host : h) {
            addresses.add(new ServerAddress(host));
        }
        MongoClient client = this.storagePlugin.getClient();
        this.chunksMapping = Maps.newHashMap();
        this.chunksInverseMapping = Maps.newLinkedHashMap();
        if (this.useAggregate && this.isShardedCluster(client)) {
            this.handleUnshardedCollection(this.getPrimaryShardInfo());
        } else if (this.isShardedCluster(client)) {
            MongoDatabase db = client.getDatabase("config");
            MongoCollection chunksCollection = db.getCollection("chunks");
            Document filter = new Document();
            filter.put("ns", (Object)(this.scanSpec.getDbName() + "." + this.scanSpec.getCollectionName()));
            Document projection = new Document();
            projection.put("shard", (Object)1);
            projection.put("min", (Object)1);
            projection.put("max", (Object)1);
            FindIterable chunkCursor = chunksCollection.find((Bson)filter).projection((Bson)projection);
            MongoCursor iterator = chunkCursor.iterator();
            MongoCollection shardsCollection = db.getCollection("shards");
            projection = new Document();
            projection.put("host", (Object)1);
            boolean hasChunks = false;
            while (iterator.hasNext()) {
                Document chunkObj = (Document)iterator.next();
                String shardName = (String)chunkObj.get((Object)"shard");
                String chunkId = chunkObj.get((Object)"_id").toString();
                filter = new Document("_id", (Object)shardName);
                FindIterable hostCursor = shardsCollection.find((Bson)filter).projection((Bson)projection);
                for (Document hostObj : hostCursor) {
                    String hostEntry = (String)hostObj.get((Object)"host");
                    String[] tagAndHost = StringUtils.split((String)hostEntry, (char)'/');
                    String[] hosts = tagAndHost.length > 1 ? StringUtils.split((String)tagAndHost[1], (char)',') : StringUtils.split((String)tagAndHost[0], (char)',');
                    HashSet addressList = this.getPreferredHosts(this.storagePlugin.getClient(addresses));
                    if (addressList == null) {
                        addressList = Sets.newHashSet();
                        for (String string : hosts) {
                            addressList.add(new ServerAddress(string));
                        }
                    }
                    this.chunksMapping.put(chunkId, addressList);
                    ServerAddress address = (ServerAddress)addressList.iterator().next();
                    List chunkList = this.chunksInverseMapping.computeIfAbsent(address.getHost(), k -> new ArrayList());
                    ArrayList<String> chunkHostsList = new ArrayList<String>();
                    for (ServerAddress serverAddr : addressList) {
                        chunkHostsList.add(serverAddr.toString());
                    }
                    ChunkInfo chunkInfo = new ChunkInfo(chunkHostsList, chunkId);
                    Document minMap = (Document)chunkObj.get((Object)"min");
                    HashMap minFilters = Maps.newHashMap();
                    Set keySet = minMap.keySet();
                    for (Object keyObj : keySet) {
                        Object object = minMap.get(keyObj);
                        if (object instanceof MinKey) continue;
                        minFilters.put(keyObj.toString(), object);
                    }
                    chunkInfo.setMinFilters(minFilters);
                    HashMap maxFilters = Maps.newHashMap();
                    Document maxMap = (Document)chunkObj.get((Object)"max");
                    keySet = maxMap.keySet();
                    for (Object keyObj : keySet) {
                        Object object = maxMap.get(keyObj);
                        if (object instanceof MaxKey) continue;
                        maxFilters.put(keyObj.toString(), object);
                    }
                    chunkInfo.setMaxFilters(maxFilters);
                    chunkList.add(chunkInfo);
                }
                hasChunks = true;
            }
            if (!hasChunks) {
                this.handleUnshardedCollection(this.getPrimaryShardInfo());
            }
        } else {
            this.handleUnshardedCollection(this.storagePluginConfig.getHosts());
        }
    }

    private void handleUnshardedCollection(List<String> hosts) {
        String chunkName = Joiner.on((char)'.').join((Object)this.scanSpec.getDbName(), (Object)this.scanSpec.getCollectionName(), new Object[0]);
        HashSet addressList = Sets.newHashSet();
        for (String host : hosts) {
            addressList.add(new ServerAddress(host));
        }
        this.chunksMapping.put(chunkName, addressList);
        String host = hosts.get(0);
        ServerAddress address = new ServerAddress(host);
        ChunkInfo chunkInfo = new ChunkInfo(hosts, chunkName);
        chunkInfo.setMinFilters(Collections.emptyMap());
        chunkInfo.setMaxFilters(Collections.emptyMap());
        ArrayList chunksList = Lists.newArrayList();
        chunksList.add(chunkInfo);
        this.chunksInverseMapping.put(address.getHost(), chunksList);
    }

    private List<String> getPrimaryShardInfo() {
        MongoDatabase database = this.storagePlugin.getClient().getDatabase("config");
        MongoCollection collection = database.getCollection("databases");
        Document filter = new Document("_id", (Object)this.scanSpec.getDbName());
        Document projection = new Document("primary", (Object)1);
        Document document = Objects.requireNonNull((Document)collection.find((Bson)filter).projection((Bson)projection).first());
        String shardName = document.getString((Object)"primary");
        Preconditions.checkNotNull((Object)shardName);
        MongoCollection shardsCol = database.getCollection("shards");
        filter = new Document("_id", (Object)shardName);
        projection = new Document("host", (Object)1);
        Document hostInfo = Objects.requireNonNull((Document)shardsCol.find((Bson)filter).projection((Bson)projection).first());
        String hostEntry = hostInfo.getString((Object)"host");
        Preconditions.checkNotNull((Object)hostEntry);
        String[] tagAndHost = StringUtils.split((String)hostEntry, (char)'/');
        Object[] hosts = tagAndHost.length > 1 ? StringUtils.split((String)tagAndHost[1], (char)',') : StringUtils.split((String)tagAndHost[0], (char)',');
        return Lists.newArrayList((Object[])hosts);
    }

    private Set<ServerAddress> getPreferredHosts(MongoClient client) {
        HashSet addressList = Sets.newHashSet();
        MongoDatabase db = client.getDatabase(this.scanSpec.getDbName());
        ReadPreference readPreference = db.getReadPreference();
        Document command = db.runCommand((Bson)new Document("isMaster", (Object)1));
        String primaryHost = command.getString((Object)"primary");
        List hostsList = (List)command.get((Object)"hosts");
        switch (readPreference.getName().toUpperCase()) {
            case "PRIMARY": 
            case "PRIMARYPREFERRED": {
                if (primaryHost == null) {
                    return null;
                }
                addressList.add(new ServerAddress(primaryHost));
                return addressList;
            }
            case "SECONDARY": 
            case "SECONDARYPREFERRED": {
                if (primaryHost == null || hostsList == null) {
                    return null;
                }
                hostsList.remove(primaryHost);
                for (String host : hostsList) {
                    addressList.add(new ServerAddress(host));
                }
                return addressList;
            }
            case "NEAREST": {
                if (hostsList == null) {
                    return null;
                }
                for (String host : hostsList) {
                    addressList.add(new ServerAddress(host));
                }
                return addressList;
            }
        }
        return null;
    }

    public GroupScan clone(List<SchemaPath> columns) {
        MongoGroupScan clone = new MongoGroupScan(this);
        clone.columns = columns;
        return clone;
    }

    public GroupScan clone(int maxRecords) {
        MongoGroupScan clone = new MongoGroupScan(this);
        clone.useAggregate = true;
        clone.getScanSpec().getOperations().add(new Document("$limit", (Object)maxRecords).toJson());
        return clone;
    }

    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
        logger.debug("Incoming endpoints :" + endpoints);
        this.watch.reset();
        this.watch.start();
        int numSlots = endpoints.size();
        int totalAssignmentsTobeDone = this.chunksMapping.size();
        Preconditions.checkArgument((numSlots <= totalAssignmentsTobeDone ? 1 : 0) != 0, (Object)String.format("Incoming endpoints %d is greater than number of chunks %d", numSlots, totalAssignmentsTobeDone));
        int minPerEndpointSlot = (int)Math.floor((double)totalAssignmentsTobeDone / (double)numSlots);
        int maxPerEndpointSlot = (int)Math.ceil((double)totalAssignmentsTobeDone / (double)numSlots);
        this.endpointFragmentMapping = Maps.newHashMapWithExpectedSize((int)numSlots);
        HashMap endpointHostIndexListMap = Maps.newHashMap();
        for (int i = 0; i < numSlots; ++i) {
            this.endpointFragmentMapping.put(i, new ArrayList(maxPerEndpointSlot));
            String hostname = endpoints.get(i).getAddress();
            Queue hostIndexQueue = endpointHostIndexListMap.computeIfAbsent(hostname, k -> new LinkedList());
            hostIndexQueue.add(i);
        }
        HashSet chunksToAssignSet = Sets.newHashSet(this.chunksInverseMapping.entrySet());
        Iterator chunksIterator = chunksToAssignSet.iterator();
        while (chunksIterator.hasNext()) {
            Map.Entry chunkEntry = (Map.Entry)chunksIterator.next();
            Queue slots = (Queue)endpointHostIndexListMap.get(chunkEntry.getKey());
            if (slots == null) continue;
            for (ChunkInfo chunkInfo : (List)chunkEntry.getValue()) {
                Integer slotIndex = (Integer)slots.poll();
                List<BaseMongoSubScanSpec> subScanSpecList = this.endpointFragmentMapping.get(slotIndex);
                subScanSpecList.add(this.buildSubScanSpecAndGet(chunkInfo));
                slots.offer((Integer)slotIndex);
            }
            chunksIterator.remove();
        }
        PriorityQueue<List<BaseMongoSubScanSpec>> minHeap = new PriorityQueue<List<BaseMongoSubScanSpec>>(numSlots, LIST_SIZE_COMPARATOR);
        PriorityQueue<List<BaseMongoSubScanSpec>> maxHeap = new PriorityQueue<List<BaseMongoSubScanSpec>>(numSlots, LIST_SIZE_COMPARATOR_REV);
        for (List list : this.endpointFragmentMapping.values()) {
            if (list.size() < minPerEndpointSlot) {
                minHeap.offer(list);
                continue;
            }
            if (list.size() <= minPerEndpointSlot) continue;
            maxHeap.offer(list);
        }
        if (chunksToAssignSet.size() > 0) {
            for (Map.Entry entry : chunksToAssignSet) {
                for (ChunkInfo chunkInfo : (List)entry.getValue()) {
                    List<BaseMongoSubScanSpec> smallestList = minHeap.poll();
                    smallestList.add(this.buildSubScanSpecAndGet(chunkInfo));
                    minHeap.offer(smallestList);
                }
            }
        }
        while (minHeap.peek() != null && minHeap.peek().size() < minPerEndpointSlot) {
            List<BaseMongoSubScanSpec> smallestList = minHeap.poll();
            List<BaseMongoSubScanSpec> list = maxHeap.poll();
            smallestList.add(list.remove(list.size() - 1));
            if (list.size() > minPerEndpointSlot) {
                maxHeap.offer(list);
            }
            if (smallestList.size() >= minPerEndpointSlot) continue;
            minHeap.offer(smallestList);
        }
        logger.debug("Built assignment map in {} \u00b5s.\nEndpoints: {}.\nAssignment Map: {}", new Object[]{this.watch.elapsed(TimeUnit.NANOSECONDS) / 1000L, endpoints, this.endpointFragmentMapping.toString()});
    }

    private BaseMongoSubScanSpec buildSubScanSpecAndGet(ChunkInfo chunkInfo) {
        if (this.useAggregate) {
            return ((MongoSubScan.MongoSubScanSpec.MongoSubScanSpecBuilder)((MongoSubScan.MongoSubScanSpec.MongoSubScanSpecBuilder)((MongoSubScan.MongoSubScanSpec.MongoSubScanSpecBuilder)MongoSubScan.MongoSubScanSpec.builder().operations(this.scanSpec.getOperations()).dbName(this.scanSpec.getDbName())).collectionName(this.scanSpec.getCollectionName())).hosts(chunkInfo.getChunkLocList())).build();
        }
        return ((MongoSubScan.ShardedMongoSubScanSpec.ShardedMongoSubScanSpecBuilder)((MongoSubScan.ShardedMongoSubScanSpec.ShardedMongoSubScanSpecBuilder)((MongoSubScan.ShardedMongoSubScanSpec.ShardedMongoSubScanSpecBuilder)MongoSubScan.ShardedMongoSubScanSpec.builder().minFilters(chunkInfo.getMinFilters()).maxFilters(chunkInfo.getMaxFilters()).filter(this.scanSpec.getFilters()).dbName(this.scanSpec.getDbName())).collectionName(this.scanSpec.getCollectionName())).hosts(chunkInfo.getChunkLocList())).build();
    }

    public MongoSubScan getSpecificScan(int minorFragmentId) {
        return new MongoSubScan(this.getUserName(), this.storagePlugin, this.storagePluginConfig, this.endpointFragmentMapping.get(minorFragmentId), this.columns);
    }

    public int getMaxParallelizationWidth() {
        return this.chunksMapping.size();
    }

    public String getDigest() {
        return this.toString();
    }

    public ScanStats getScanStats() {
        try {
            MongoClient client = this.storagePlugin.getClient();
            MongoDatabase db = client.getDatabase(this.scanSpec.getDbName());
            MongoCollection collection = db.getCollection(this.scanSpec.getCollectionName());
            long recordCount = collection.estimatedDocumentCount();
            float approxDiskCost = 0.0f;
            if (recordCount != 0L) {
                DocumentCodec codec = new DocumentCodec(db.getCodecRegistry(), new BsonTypeClassMap());
                String json = ((Document)collection.find().first()).toJson((Encoder)codec);
                approxDiskCost = (long)json.getBytes(StandardCharsets.UTF_8).length * recordCount;
            }
            return new ScanStats(ScanStats.GroupScanProperty.ESTIMATED_TOTAL_COST, (double)recordCount, 1.0, (double)approxDiskCost);
        }
        catch (Exception e) {
            throw new DrillRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new MongoGroupScan(this);
    }

    public List<EndpointAffinity> getOperatorAffinity() {
        this.watch.reset();
        this.watch.start();
        HashMap endpointMap = Maps.newHashMap();
        for (CoordinationProtos.DrillbitEndpoint endpoint : this.storagePlugin.getContext().getBits()) {
            endpointMap.put(endpoint.getAddress(), endpoint);
            logger.debug("Endpoint address: {}", (Object)endpoint.getAddress());
        }
        HashMap affinityMap = Maps.newHashMap();
        block1: for (Set<ServerAddress> addressList : this.chunksMapping.values()) {
            for (ServerAddress address : addressList) {
                CoordinationProtos.DrillbitEndpoint ep = (CoordinationProtos.DrillbitEndpoint)endpointMap.get(address.getHost());
                if (ep == null) continue;
                EndpointAffinity affinity = (EndpointAffinity)affinityMap.get(ep);
                if (affinity == null) {
                    affinityMap.put(ep, new EndpointAffinity(ep, 1.0));
                    continue block1;
                }
                affinity.addAffinity(1.0);
                continue block1;
            }
        }
        logger.debug("Took {} \u00b5s to get operator affinity", (Object)(this.watch.elapsed(TimeUnit.NANOSECONDS) / 1000L));
        logger.debug("Affined drillbits : " + affinityMap.values());
        return Lists.newArrayList(affinityMap.values());
    }

    public boolean supportsLimitPushdown() {
        return true;
    }

    public GroupScan applyLimit(int maxRecords) {
        return this.clone(maxRecords);
    }

    @JsonProperty
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="mongoScanSpec")
    public MongoScanSpec getScanSpec() {
        return this.scanSpec;
    }

    @JsonProperty(value="storage")
    public MongoStoragePluginConfig getStorageConfig() {
        return this.storagePluginConfig;
    }

    @JsonIgnore
    public MongoStoragePlugin getStoragePlugin() {
        return this.storagePlugin;
    }

    @JsonProperty(value="useAggregate")
    public void setUseAggregate(boolean useAggregate) {
        this.useAggregate = useAggregate;
    }

    @JsonProperty(value="useAggregate")
    public boolean isUseAggregate() {
        return this.useAggregate;
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("MongoScanSpec", (Object)this.scanSpec).field("columns", this.columns).field("useAggregate", (Object)this.useAggregate).toString();
    }

    @VisibleForTesting
    MongoGroupScan() {
        super((String)null);
    }

    @JsonIgnore
    @VisibleForTesting
    void setChunksMapping(Map<String, Set<ServerAddress>> chunksMapping) {
        this.chunksMapping = chunksMapping;
    }

    @JsonIgnore
    @VisibleForTesting
    void setScanSpec(MongoScanSpec scanSpec) {
        this.scanSpec = scanSpec;
    }

    @JsonIgnore
    @VisibleForTesting
    void setInverseChunksMapping(Map<String, List<ChunkInfo>> chunksInverseMapping) {
        this.chunksInverseMapping = chunksInverseMapping;
    }
}

