/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkUtils.class);
    private static final String LINUX_TSO_NET_IFACE_PREFIX = "eth";
    private static final String MAC_TSO_NET_IFACE_PREFIX = "en";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDefaultNetworkInterface() {
        try (DatagramSocket s2222 = new DatagramSocket();){
            s2222.connect(InetAddress.getByAddress(new byte[]{1, 1, 1, 1}), 0);
            String throwable3 = NetworkInterface.getByInetAddress(s2222.getLocalAddress()).getName();
            return throwable3;
        }
        catch (Exception s2222) {
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                String fallBackName = null;
                while (networkInterfaces.hasMoreElements()) {
                    boolean hasInet;
                    NetworkInterface nextElement = networkInterfaces.nextElement();
                    String name = nextElement.getDisplayName();
                    LOG.info("Iterating over network interfaces, found '{}'", (Object)name);
                    boolean bl = hasInet = Collections.list(nextElement.getInetAddresses()).size() > 1;
                    if (hasInet && fallBackName == null) {
                        fallBackName = name;
                    }
                    if (name.startsWith(MAC_TSO_NET_IFACE_PREFIX)) {
                        if (hasInet) return name;
                    }
                    if (!name.startsWith(LINUX_TSO_NET_IFACE_PREFIX)) continue;
                    return name;
                }
                if (fallBackName == null) throw new IllegalArgumentException(String.format("No network '%s*'/'%s*' interfaces found", MAC_TSO_NET_IFACE_PREFIX, LINUX_TSO_NET_IFACE_PREFIX));
                return fallBackName;
            }
            catch (SocketException ignored) {
                throw new RuntimeException("Failed to find any network interfaces", ignored);
            }
        }
    }
}

