/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.jsyslog.message;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.realityforge.jsyslog.message.Facility;
import org.realityforge.jsyslog.message.Severity;
import org.realityforge.jsyslog.message.StructuredDataParameter;

public class SyslogMessage {
    private static final String NILVALUE_STRING = "-";
    private static final char NILVALUE = '-';
    private static final char SP = ' ';
    private static final char PRI_START = '<';
    private static final char PRI_END = '>';
    private static final String VERSION = "1";
    private static final char SD_END = ']';
    private static final char SD_START = '[';
    private static final char SD_VALUE_QUOTE = '\"';
    private static final char SD_ASSIGN = '=';
    @Nullable
    private final Facility _facility;
    @Nullable
    private final Severity _level;
    @Nullable
    private final DateTime _timestamp;
    @Nullable
    private final String _hostname;
    @Nullable
    private final String _appName;
    @Nullable
    private final String _procId;
    @Nullable
    private final String _msgId;
    @Nullable
    private final Map<String, List<StructuredDataParameter>> _structuredData;
    @Nullable
    private final String _message;

    public SyslogMessage(@Nullable Facility facility, @Nullable Severity level, @Nullable DateTime timestamp, @Nullable String hostname, @Nullable String appName, @Nullable String procId, @Nullable String msgId, @Nullable Map<String, List<StructuredDataParameter>> structuredData, @Nullable String message) {
        this._facility = facility;
        this._level = level;
        this._timestamp = timestamp;
        this._hostname = hostname;
        this._appName = appName;
        this._procId = procId;
        this._msgId = msgId;
        this._structuredData = structuredData;
        this._message = message;
    }

    @Nullable
    public Facility getFacility() {
        return this._facility;
    }

    @Nullable
    public Severity getLevel() {
        return this._level;
    }

    @Nullable
    public DateTime getTimestamp() {
        return this._timestamp;
    }

    @Nullable
    public String getHostname() {
        return this._hostname;
    }

    @Nullable
    public String getAppName() {
        return this._appName;
    }

    @Nullable
    public String getProcId() {
        return this._procId;
    }

    @Nullable
    public String getMsgId() {
        return this._msgId;
    }

    @Nullable
    public Map<String, List<StructuredDataParameter>> getStructuredData() {
        return this._structuredData;
    }

    @Nullable
    public String getMessage() {
        return this._message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyslogMessage that = (SyslogMessage)o;
        if (this._facility != that._facility) {
            return false;
        }
        if (this._level != that._level) {
            return false;
        }
        if (this._appName != null ? !this._appName.equals(that._appName) : that._appName != null) {
            return false;
        }
        if (this._hostname != null ? !this._hostname.equals(that._hostname) : that._hostname != null) {
            return false;
        }
        if (this._message != null ? !this._message.equals(that._message) : that._message != null) {
            return false;
        }
        if (this._msgId != null ? !this._msgId.equals(that._msgId) : that._msgId != null) {
            return false;
        }
        if (this._procId != null ? !this._procId.equals(that._procId) : that._procId != null) {
            return false;
        }
        if (this._structuredData != null ? !this._structuredData.equals(that._structuredData) : that._structuredData != null) {
            return false;
        }
        return !(this._timestamp == null ? that._timestamp != null : !this._timestamp.equals((Object)that._timestamp));
    }

    public int hashCode() {
        int result = this._facility != null ? this._facility.ordinal() : 0;
        result = 31 * result + (this._level != null ? this._level.ordinal() : 0);
        result = 31 * result + (this._timestamp != null ? this._timestamp.hashCode() : 0);
        result = 31 * result + (this._hostname != null ? this._hostname.hashCode() : 0);
        result = 31 * result + (this._appName != null ? this._appName.hashCode() : 0);
        result = 31 * result + (this._procId != null ? this._procId.hashCode() : 0);
        result = 31 * result + (this._msgId != null ? this._msgId.hashCode() : 0);
        result = 31 * result + (this._structuredData != null ? this._structuredData.hashCode() : 0);
        result = 31 * result + (this._message != null ? this._message.hashCode() : 0);
        return result;
    }

    public static SyslogMessage parseRFC3164SyslogMessage(String rawMessage) {
        String message = rawMessage;
        Facility facility = null;
        Severity level = null;
        DateTime timestamp = null;
        String hostname = null;
        String appName = null;
        String procId = null;
        int index = 0;
        try {
            int openProcId;
            int priority;
            int endPri;
            if ('<' == rawMessage.charAt(index)) {
                // empty if block
            }
            if ((endPri = rawMessage.indexOf(62)) < 1 || endPri >= 5) {
                throw new IllegalArgumentException();
            }
            try {
                priority = Integer.parseInt(rawMessage.substring(1, endPri));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException();
            }
            facility = Facility.values()[priority >> 3];
            level = Severity.values()[priority - (facility.ordinal() << 3)];
            index = endPri + 1;
            message = rawMessage.substring(index);
            if (rawMessage.length() >= index + 16 && rawMessage.charAt(index + 15) == ' ' && rawMessage.charAt(index + 3) == ' ' && rawMessage.charAt(index + 6) == ' ') {
                String year = Integer.toString(Calendar.getInstance().get(1));
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss yyyy");
                    String dateString = rawMessage.substring(index, index + 15) + " " + year;
                    timestamp = new DateTime((Object)dateFormat.parse(dateString));
                    message = rawMessage.substring(index += 16);
                }
                catch (ParseException pe) {
                    timestamp = null;
                }
            }
            if (null == timestamp) {
                throw new IllegalArgumentException();
            }
            int endHost = rawMessage.indexOf(32, index);
            if (-1 != endHost) {
                try {
                    hostname = rawMessage.substring(index, endHost);
                    index = endHost + 1;
                    message = rawMessage.substring(endHost + 1);
                }
                catch (StringIndexOutOfBoundsException oob) {
                    hostname = null;
                }
            }
            if (null == hostname) {
                throw new IllegalArgumentException();
            }
            int tagEnd = rawMessage.indexOf(58, index);
            int nextSp = rawMessage.indexOf(32, index);
            if (-1 != nextSp && -1 != tagEnd && tagEnd < nextSp && nextSp == tagEnd + 1 && -1 != (openProcId = rawMessage.indexOf(91, index)) && ']' == rawMessage.charAt(tagEnd - 1)) {
                appName = rawMessage.substring(index, openProcId);
                procId = rawMessage.substring(openProcId + 1, tagEnd - 1);
                message = rawMessage.substring(nextSp + 1);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return new SyslogMessage(facility, level, timestamp, hostname, appName, procId, null, null, message);
    }

    public String toString() {
        return this.asStructuredSyslogMessage();
    }

    public String asStructuredSyslogMessage() {
        String sd;
        DateTime ts = this.getTimestamp();
        String timestamp = ts == null ? NILVALUE_STRING : SyslogMessage.emitTimestamp(ts);
        String hostname = this.getHostname() == null ? NILVALUE_STRING : this.getHostname();
        String appName = this.getAppName() == null ? NILVALUE_STRING : this.getAppName();
        String procId = this.getProcId() == null ? NILVALUE_STRING : this.getProcId();
        String msgId = this.getMsgId() == null ? NILVALUE_STRING : this.getMsgId();
        Severity level = this.getLevel();
        Facility facility = this.getFacility();
        int pri = (null != level ? level.ordinal() : 0) + ((null != facility ? facility.ordinal() : 0) << 3);
        Map<String, List<StructuredDataParameter>> structuredData = this.getStructuredData();
        if (null != structuredData) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, List<StructuredDataParameter>> entry : structuredData.entrySet()) {
                sb.append('[');
                sb.append(entry.getKey());
                for (StructuredDataParameter param : entry.getValue()) {
                    sb.append(' ');
                    sb.append(param.getName());
                    sb.append('=');
                    sb.append('\"');
                    sb.append(param.getValue().replace("\\", "\\\\").replace("]", "\\]").replace("\"", "\\\""));
                    sb.append('\"');
                }
                sb.append(']');
            }
            sd = sb.toString();
        } else {
            sd = NILVALUE_STRING;
        }
        String messageSuffix = this.getMessage() == null ? "" : ' ' + this.getMessage();
        return String.valueOf('<') + pri + String.valueOf('>') + VERSION + ' ' + timestamp + ' ' + hostname + ' ' + appName + ' ' + procId + ' ' + msgId + ' ' + sd + messageSuffix;
    }

    public static SyslogMessage parseStructuredSyslogMessage(String rawMessage) {
        try {
            String message;
            int endStructuredData;
            HashMap<String, List<StructuredDataParameter>> structuredData;
            int endTimestamp;
            DateTime timestamp;
            int priority;
            if ('<' != rawMessage.charAt(0)) {
                throw new IllegalArgumentException("Missing < to start PRI: " + rawMessage);
            }
            int endPri = rawMessage.indexOf(62);
            if (endPri < 1 || endPri >= 5) {
                throw new IllegalArgumentException("Missing > to finish PRI: " + rawMessage);
            }
            try {
                priority = Integer.parseInt(rawMessage.substring(1, endPri));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Failed to parse PRI: " + rawMessage);
            }
            Facility facility = Facility.values()[priority >> 3];
            Severity level = Severity.values()[priority - (facility.ordinal() << 3)];
            int startVersion = endPri + 1;
            int endVersion = rawMessage.indexOf(32, startVersion);
            if (-1 == endVersion) {
                throw new IllegalArgumentException("Missing SP to terminate version: " + rawMessage);
            }
            if (!VERSION.equals(rawMessage.substring(startVersion, endVersion))) {
                throw new IllegalArgumentException("Unknown version: " + rawMessage);
            }
            int startTimestamp = endVersion + 1;
            if ('-' == rawMessage.charAt(startTimestamp)) {
                timestamp = null;
                endTimestamp = startTimestamp + 1;
            } else {
                endTimestamp = rawMessage.indexOf(32, startTimestamp);
                if (-1 == endTimestamp) {
                    throw new IllegalArgumentException("Message truncated after timestamp: " + rawMessage);
                }
                timestamp = SyslogMessage.parseDateTime(rawMessage.substring(startTimestamp, endTimestamp));
            }
            int startHost = endTimestamp + 1;
            int endHost = rawMessage.indexOf(32, startHost);
            if (-1 == endHost) {
                throw new IllegalArgumentException("Message truncated after hostname: " + rawMessage);
            }
            String hostnameString = rawMessage.substring(startHost, endHost);
            String hostname = NILVALUE_STRING.equals(hostnameString) ? null : hostnameString;
            int startAppName = endHost + 1;
            int endAppName = rawMessage.indexOf(32, startAppName);
            if (-1 == endAppName) {
                throw new IllegalArgumentException("Message truncated after AppName: " + rawMessage);
            }
            String appNameString = rawMessage.substring(startAppName, endAppName);
            String appName = NILVALUE_STRING.equals(appNameString) ? null : appNameString;
            int startProcId = endAppName + 1;
            int endProcId = rawMessage.indexOf(32, startProcId);
            if (-1 == endProcId) {
                throw new IllegalArgumentException("Message truncated after ProcId: " + rawMessage);
            }
            String procIdString = rawMessage.substring(startProcId, endProcId);
            String procId = NILVALUE_STRING.equals(procIdString) ? null : procIdString;
            int startMsgId = endProcId + 1;
            int endMsgId = rawMessage.indexOf(32, startMsgId);
            if (-1 == endMsgId) {
                throw new IllegalArgumentException("Message truncated after MsgId: " + rawMessage);
            }
            String msgIdString = rawMessage.substring(startMsgId, endMsgId);
            String msgId = NILVALUE_STRING.equals(msgIdString) ? null : msgIdString;
            int startStructuredData = endMsgId + 1;
            if ('-' == rawMessage.charAt(startStructuredData)) {
                structuredData = null;
                endStructuredData = startStructuredData + 1;
            } else {
                structuredData = new HashMap<String, List<StructuredDataParameter>>();
                int index = startStructuredData;
                while ('[' == rawMessage.charAt(index)) {
                    char ch;
                    ++index;
                    StringBuilder sb = new StringBuilder();
                    while (SyslogMessage.isNameCharacter(ch = rawMessage.charAt(index))) {
                        sb.append(ch);
                        ++index;
                    }
                    String sdId = sb.toString();
                    sb.setLength(0);
                    ArrayList<StructuredDataParameter> params = new ArrayList<StructuredDataParameter>();
                    structuredData.put(sdId, params);
                    ch = rawMessage.charAt(index);
                    while (']' != ch) {
                        if (' ' != ch) {
                            throw new IllegalArgumentException("Missing space at start of param: " + rawMessage);
                        }
                        ++index;
                        while (SyslogMessage.isNameCharacter(ch = rawMessage.charAt(index))) {
                            sb.append(ch);
                            ++index;
                        }
                        String key = sb.toString();
                        sb.setLength(0);
                        if ('=' != rawMessage.charAt(index)) {
                            throw new IllegalArgumentException("Param name not followed by =: " + rawMessage);
                        }
                        if ('\"' != rawMessage.charAt(++index)) {
                            throw new IllegalArgumentException("Param value not started by \": " + rawMessage);
                        }
                        ++index;
                        while ('\"' != (ch = rawMessage.charAt(index))) {
                            ++index;
                            if ('\\' == ch) {
                                sb.append(rawMessage.charAt(index));
                                ++index;
                                continue;
                            }
                            sb.append(ch);
                        }
                        String value = sb.toString();
                        sb.setLength(0);
                        params.add(new StructuredDataParameter(key, value));
                        ch = rawMessage.charAt(++index);
                    }
                    if (++index != rawMessage.length()) continue;
                    break;
                }
                endStructuredData = index;
            }
            if (rawMessage.length() != endStructuredData) {
                if (' ' != rawMessage.charAt(endStructuredData)) {
                    throw new IllegalArgumentException("Missing SP after structured data: " + rawMessage);
                }
                int startMessage = endStructuredData + 1;
                message = rawMessage.substring(startMessage);
            } else {
                message = null;
            }
            return new SyslogMessage(facility, level, timestamp, hostname, appName, procId, msgId, structuredData, message);
        }
        catch (StringIndexOutOfBoundsException obe) {
            throw new IllegalArgumentException("Message terminated unexpectedly: " + rawMessage, obe);
        }
    }

    @Nonnull
    private static DateTime parseDateTime(@Nonnull String dateString) {
        return ISODateTimeFormat.dateTime().withOffsetParsed().parseDateTime(dateString);
    }

    @Nonnull
    private static String emitTimestamp(@Nonnull DateTime date) {
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();
        dateTimeFormatter.withChronology(date.getChronology());
        dateTimeFormatter.withZone(date.getZone());
        return dateTimeFormatter.print((ReadableInstant)date);
    }

    private static boolean isNameCharacter(char ch) {
        return ' ' != ch && '=' != ch & '\"' != ch;
    }
}

