/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.tokenformat;

import java.io.Serializable;
import java.util.EnumSet;
import nl.basjes.parse.core.Casts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenOutputField
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(TokenOutputField.class);
    private final String type;
    private final String name;
    private final EnumSet<Casts> casts;
    private String deprecated = null;

    public TokenOutputField(String type, String name, EnumSet<Casts> casts) {
        this.name = name.toLowerCase();
        this.type = type;
        this.casts = casts;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public EnumSet<Casts> getCasts() {
        return this.casts;
    }

    public TokenOutputField deprecateFor(String deprecatedFor) {
        this.deprecated = deprecatedFor;
        return this;
    }

    public boolean isDeprecated() {
        return this.deprecated != null;
    }

    public void wasUsed() {
        if (this.deprecated != null) {
            LOG.warn("------------------------------------------------------------------------");
            LOG.warn("The field \"{}:{}\" is deprecated. Use \"{}\" instead.", new Object[]{this.type, this.name, this.deprecated});
            LOG.warn("------------------------------------------------------------------------");
        }
    }

    public String toString() {
        String msg = "{ " + this.getType() + ':' + this.getName() + " --> " + this.casts + " }";
        if (this.deprecated != null) {
            return "DEPRECATED: " + msg;
        }
        return msg;
    }
}

