/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import hive.com.google.common.base.Function;
import hive.com.google.common.base.Predicate;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

public class ReplicationSpec {
    private boolean isInReplicationScope = false;
    private boolean isMetadataOnly = false;
    private String eventId = null;
    private String currStateId = null;
    private boolean isNoop = false;
    private boolean isLazy = false;
    private boolean isReplace = true;
    private String validWriteIdList = null;
    private Type specType = Type.DEFAULT;

    public ReplicationSpec(ASTNode node) {
        if (node != null) {
            if (ReplicationSpec.isApplicable(node)) {
                this.init(node);
                return;
            }
            for (int i = 1; i < node.getChildCount(); ++i) {
                ASTNode child = (ASTNode)node.getChild(i);
                if (!ReplicationSpec.isApplicable(child)) continue;
                this.init(child);
                return;
            }
        }
    }

    public ReplicationSpec() {
        this((ASTNode)null);
    }

    public ReplicationSpec(String fromId, String toId) {
        this(true, false, fromId, toId, false, true, false);
    }

    public ReplicationSpec(boolean isInReplicationScope, boolean isMetadataOnly, String eventReplicationState, String currentReplicationState, boolean isNoop, boolean isLazy, boolean isReplace) {
        this.isInReplicationScope = isInReplicationScope;
        this.isMetadataOnly = isMetadataOnly;
        this.eventId = eventReplicationState;
        this.currStateId = currentReplicationState;
        this.isNoop = isNoop;
        this.isLazy = isLazy;
        this.isReplace = isReplace;
        this.specType = Type.DEFAULT;
    }

    public ReplicationSpec(Function<String, String> keyFetcher) {
        String scope = keyFetcher.apply(KEY.REPL_SCOPE.toString());
        this.isInReplicationScope = false;
        this.isMetadataOnly = false;
        this.specType = Type.DEFAULT;
        if (scope != null) {
            if (scope.equalsIgnoreCase("metadata")) {
                this.isMetadataOnly = true;
                this.isInReplicationScope = true;
            } else if (scope.equalsIgnoreCase("all")) {
                this.isInReplicationScope = true;
            }
        }
        this.eventId = keyFetcher.apply(KEY.EVENT_ID.toString());
        this.currStateId = keyFetcher.apply(KEY.CURR_STATE_ID.toString());
        this.isNoop = Boolean.parseBoolean(keyFetcher.apply(KEY.NOOP.toString()));
        this.isLazy = Boolean.parseBoolean(keyFetcher.apply(KEY.LAZY.toString()));
        this.isReplace = Boolean.parseBoolean(keyFetcher.apply(KEY.IS_REPLACE.toString()));
        this.validWriteIdList = keyFetcher.apply(KEY.VALID_WRITEID_LIST.toString());
    }

    public static boolean isApplicable(ASTNode node) {
        return node.getToken().getType() == 963;
    }

    public boolean allowReplacement(String currReplState, String replacementReplState) {
        if (currReplState == null || currReplState.isEmpty()) {
            return true;
        }
        if (replacementReplState == null || replacementReplState.isEmpty()) {
            return false;
        }
        long currReplStateLong = Long.parseLong(currReplState.replaceAll("\\D", ""));
        long replacementReplStateLong = Long.parseLong(replacementReplState.replaceAll("\\D", ""));
        if (this.specType == Type.IMPORT) {
            return currReplStateLong <= replacementReplStateLong;
        }
        return currReplStateLong < replacementReplStateLong;
    }

    public boolean allowReplacementInto(Map<String, String> params) {
        return this.allowReplacement(ReplicationSpec.getLastReplicatedStateFromParameters(params), this.getCurrentReplicationState());
    }

    public boolean allowEventReplacementInto(Map<String, String> params) {
        return this.allowReplacement(ReplicationSpec.getLastReplicatedStateFromParameters(params), this.getReplicationState());
    }

    public Predicate<Partition> allowEventReplacementInto() {
        return new Predicate<Partition>(){

            @Override
            public boolean apply(@Nullable Partition partition) {
                if (partition == null) {
                    return false;
                }
                return ReplicationSpec.this.allowEventReplacementInto(partition.getParameters());
            }
        };
    }

    private void init(ASTNode node) {
        this.isInReplicationScope = true;
        this.eventId = PlanUtils.stripQuotes(node.getChild(0).getText());
        if (node.getChildCount() > 1 && node.getChild(1).getText().toLowerCase().equals("metadata")) {
            this.isMetadataOnly = true;
            try {
                if (Long.parseLong(this.eventId) >= 0L) {
                    this.currStateId = this.eventId;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getLastReplicatedStateFromParameters(Map<String, String> m) {
        if (m != null && m.containsKey(KEY.CURR_STATE_ID.toString())) {
            return m.get(KEY.CURR_STATE_ID.toString());
        }
        return null;
    }

    public Type getReplSpecType() {
        return this.specType;
    }

    public void setReplSpecType(Type specType) {
        this.specType = specType;
    }

    public boolean isInReplicationScope() {
        return this.isInReplicationScope;
    }

    public boolean isMetadataOnly() {
        return this.isMetadataOnly;
    }

    public void setIsMetadataOnly(boolean isMetadataOnly) {
        this.isMetadataOnly = isMetadataOnly;
    }

    public boolean isReplace() {
        return this.isReplace;
    }

    public void setIsReplace(boolean isReplace) {
        this.isReplace = isReplace;
    }

    public String getReplicationState() {
        return this.eventId;
    }

    public String getCurrentReplicationState() {
        return this.currStateId;
    }

    public void setCurrentReplicationState(String currStateId) {
        this.currStateId = currStateId;
    }

    public boolean isNoop() {
        return this.isNoop;
    }

    public void setNoop(boolean isNoop) {
        this.isNoop = isNoop;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public void setLazy(boolean isLazy) {
        this.isLazy = isLazy;
    }

    public String getValidWriteIdList() {
        return this.validWriteIdList;
    }

    public void setValidWriteIdList(String validWriteIdList) {
        this.validWriteIdList = validWriteIdList;
    }

    public boolean isTransactionalTableDump() {
        return this.validWriteIdList != null;
    }

    public String get(KEY key) {
        switch (key) {
            case REPL_SCOPE: {
                switch (this.getScope()) {
                    case MD_ONLY: {
                        return "metadata";
                    }
                    case REPL: {
                        return "all";
                    }
                    case NO_REPL: {
                        return "none";
                    }
                }
            }
            case EVENT_ID: {
                return this.getReplicationState();
            }
            case CURR_STATE_ID: {
                return this.getCurrentReplicationState();
            }
            case NOOP: {
                return String.valueOf(this.isNoop());
            }
            case LAZY: {
                return String.valueOf(this.isLazy());
            }
            case IS_REPLACE: {
                return String.valueOf(this.isReplace());
            }
            case VALID_WRITEID_LIST: {
                return this.getValidWriteIdList();
            }
        }
        return null;
    }

    public SCOPE getScope() {
        if (this.isInReplicationScope()) {
            if (this.isMetadataOnly()) {
                return SCOPE.MD_ONLY;
            }
            return SCOPE.REPL;
        }
        return SCOPE.NO_REPL;
    }

    public static enum Type {
        DEFAULT,
        INCREMENTAL_DUMP,
        IMPORT;

    }

    public static enum SCOPE {
        NO_REPL,
        MD_ONLY,
        REPL;

    }

    public static enum KEY {
        REPL_SCOPE("repl.scope"),
        EVENT_ID("repl.event.id"),
        CURR_STATE_ID("repl.last.id"),
        NOOP("repl.noop"),
        LAZY("repl.lazy"),
        IS_REPLACE("repl.is.replace"),
        VALID_WRITEID_LIST("repl.valid.writeid.list");

        private final String keyName;

        private KEY(String s) {
            this.keyName = s;
        }

        public String toString() {
            return this.keyName;
        }
    }
}

