/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import hive.com.google.common.annotations.VisibleForTesting;
import hive.com.google.common.base.Preconditions;
import hive.com.google.common.collect.Interner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.BlobStorageUtils;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.DemuxOperator;
import org.apache.hadoop.hive.ql.exec.DependencyCollectionTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MoveTask;
import org.apache.hadoop.hive.ql.exec.NodeUtils;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.io.orc.OrcFileStripeMergeInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileBlockMergeInputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.SamplePruner;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.ListBucketingPruner;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.BasicStatsWork;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverMergeFiles;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.DependencyCollectionWork;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileMergeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.IStatsGatherDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OrcFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.RCFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.session.LineageState;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenMapRedUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils");

    public static boolean needsTagging(ReduceWork rWork) {
        return rWork != null && (rWork.getReducer().getClass() == JoinOperator.class || rWork.getReducer().getClass() == DemuxOperator.class);
    }

    public static void initPlan(ReduceSinkOperator op, GenMRProcContext opProcCtx) throws SemanticException {
        Operator<OperatorDesc> reducer = op.getChildOperators().get(0);
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = opProcCtx.getMapCurrCtx();
        GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(op.getParentOperators().get(0));
        Task<? extends Serializable> currTask = mapredCtx.getCurrTask();
        MapredWork plan = (MapredWork)currTask.getWork();
        HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = opProcCtx.getOpTaskMap();
        TableScanOperator currTopOp = opProcCtx.getCurrTopOp();
        opTaskMap.put(reducer, currTask);
        plan.setReduceWork(new ReduceWork());
        plan.getReduceWork().setReducer(reducer);
        ReduceSinkDesc desc = (ReduceSinkDesc)op.getConf();
        plan.getReduceWork().setNumReduceTasks(desc.getNumReducers());
        if (GenMapRedUtils.needsTagging(plan.getReduceWork())) {
            plan.getReduceWork().setNeedsTagging(true);
        }
        assert (currTopOp != null);
        String currAliasId = opProcCtx.getCurrAliasId();
        if (!opProcCtx.isSeenOp(currTask, currTopOp)) {
            GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currTask, false, opProcCtx);
        }
        currTopOp = null;
        currAliasId = null;
        opProcCtx.setCurrTask(currTask);
        opProcCtx.setCurrTopOp(currTopOp);
        opProcCtx.setCurrAliasId(currAliasId);
    }

    public static void initUnionPlan(ReduceSinkOperator op, UnionOperator currUnionOp, GenMRProcContext opProcCtx, Task<? extends Serializable> unionTask) throws SemanticException {
        Operator<OperatorDesc> reducer = op.getChildOperators().get(0);
        MapredWork plan = (MapredWork)unionTask.getWork();
        HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = opProcCtx.getOpTaskMap();
        opTaskMap.put(reducer, unionTask);
        plan.setReduceWork(new ReduceWork());
        plan.getReduceWork().setReducer(reducer);
        plan.getReduceWork().setReducer(reducer);
        ReduceSinkDesc desc = (ReduceSinkDesc)op.getConf();
        plan.getReduceWork().setNumReduceTasks(desc.getNumReducers());
        if (GenMapRedUtils.needsTagging(plan.getReduceWork())) {
            plan.getReduceWork().setNeedsTagging(true);
        }
        GenMapRedUtils.initUnionPlan(opProcCtx, currUnionOp, unionTask, false);
    }

    private static void setUnionPlan(GenMRProcContext opProcCtx, boolean local, Task<? extends Serializable> currTask, GenMRProcContext.GenMRUnionCtx uCtx, boolean mergeTask) throws SemanticException {
        TableScanOperator currTopOp = opProcCtx.getCurrTopOp();
        if (currTopOp != null) {
            String currAliasId = opProcCtx.getCurrAliasId();
            if (mergeTask || !opProcCtx.isSeenOp(currTask, currTopOp)) {
                GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currTask, local, opProcCtx);
            }
            currTopOp = null;
            opProcCtx.setCurrTopOp(currTopOp);
        } else {
            List<String> taskTmpDirLst = uCtx.getTaskTmpDir();
            if (taskTmpDirLst != null && !taskTmpDirLst.isEmpty()) {
                List<TableDesc> tt_descLst = uCtx.getTTDesc();
                assert (!taskTmpDirLst.isEmpty() && !tt_descLst.isEmpty());
                assert (taskTmpDirLst.size() == tt_descLst.size());
                int size = taskTmpDirLst.size();
                assert (!local);
                List<TableScanOperator> topOperators = uCtx.getListTopOperators();
                MapredWork plan = (MapredWork)currTask.getWork();
                for (int pos = 0; pos < size; ++pos) {
                    String taskTmpDir = taskTmpDirLst.get(pos);
                    Path taskTmpDirPath = new Path(taskTmpDir);
                    MapWork mWork = plan.getMapWork();
                    if (mWork.getPathToAliases().containsKey(taskTmpDirPath)) continue;
                    taskTmpDir = taskTmpDir.intern();
                    StringInternUtils.internUriStringsInPath(taskTmpDirPath);
                    TableDesc tt_desc = tt_descLst.get(pos);
                    mWork.addPathToAlias(taskTmpDirPath, taskTmpDir);
                    mWork.addPathToPartitionInfo(taskTmpDirPath, new PartitionDesc(tt_desc, null));
                    mWork.getAliasToWork().put(taskTmpDir, topOperators.get(pos));
                }
            }
        }
    }

    public static void initUnionPlan(GenMRProcContext opProcCtx, UnionOperator currUnionOp, Task<? extends Serializable> currTask, boolean local) throws SemanticException {
        if (currUnionOp != null) {
            GenMRProcContext.GenMRUnionCtx uCtx = opProcCtx.getUnionTask(currUnionOp);
            assert (uCtx != null);
            GenMapRedUtils.setUnionPlan(opProcCtx, local, currTask, uCtx, false);
        }
    }

    public static void joinUnionPlan(GenMRProcContext opProcCtx, UnionOperator currUnionOp, Task<? extends Serializable> currentUnionTask, Task<? extends Serializable> existingTask, boolean local) throws SemanticException {
        assert (currUnionOp != null);
        GenMRProcContext.GenMRUnionCtx uCtx = opProcCtx.getUnionTask(currUnionOp);
        assert (uCtx != null);
        GenMapRedUtils.setUnionPlan(opProcCtx, local, existingTask, uCtx, true);
        ArrayList<Task<Serializable>> parTasks = null;
        if (opProcCtx.getRootTasks().contains(currentUnionTask)) {
            opProcCtx.getRootTasks().remove(currentUnionTask);
            if (!opProcCtx.getRootTasks().contains(existingTask) && (existingTask.getParentTasks() == null || existingTask.getParentTasks().isEmpty())) {
                opProcCtx.getRootTasks().add(existingTask);
            }
        }
        if (currentUnionTask != null && currentUnionTask.getParentTasks() != null && !currentUnionTask.getParentTasks().isEmpty()) {
            Object[] parTaskArr;
            parTasks = new ArrayList<Task<Serializable>>();
            parTasks.addAll(currentUnionTask.getParentTasks());
            for (Object parTask : parTaskArr = parTasks.toArray()) {
                ((Task)parTask).removeDependentTask(currentUnionTask);
            }
        }
        if (currentUnionTask != null && parTasks != null) {
            for (Task task : parTasks) {
                task.addDependentTask(existingTask);
                if (!opProcCtx.getRootTasks().contains(existingTask)) continue;
                opProcCtx.getRootTasks().remove(existingTask);
            }
        }
        opProcCtx.setCurrTask(existingTask);
    }

    public static void joinPlan(Task<? extends Serializable> currTask, Task<? extends Serializable> oldTask, GenMRProcContext opProcCtx) throws SemanticException {
        assert (currTask != null && oldTask != null);
        TableScanOperator currTopOp = opProcCtx.getCurrTopOp();
        ArrayList<Task<Serializable>> parTasks = null;
        if (currTask.getParentTasks() != null && !currTask.getParentTasks().isEmpty()) {
            Object[] parTaskArr;
            parTasks = new ArrayList<Task<Serializable>>();
            parTasks.addAll(currTask.getParentTasks());
            for (Object element : parTaskArr = parTasks.toArray()) {
                ((Task)element).removeDependentTask(currTask);
            }
        }
        if (currTopOp != null) {
            GenMapRedUtils.mergeInput(currTopOp, opProcCtx, oldTask, false);
        }
        if (parTasks != null) {
            for (Task task : parTasks) {
                task.addDependentTask(oldTask);
            }
        }
        if (oldTask instanceof MapRedTask && currTask instanceof MapRedTask) {
            ((MapredWork)((MapRedTask)currTask).getWork()).getMapWork().mergingInto(((MapredWork)((MapRedTask)oldTask).getWork()).getMapWork());
        }
        opProcCtx.setCurrTopOp(null);
        opProcCtx.setCurrTask(oldTask);
    }

    static boolean mergeInput(TableScanOperator currTopOp, GenMRProcContext opProcCtx, Task<? extends Serializable> task, boolean local) throws SemanticException {
        if (!opProcCtx.isSeenOp(task, currTopOp)) {
            String currAliasId = opProcCtx.getCurrAliasId();
            GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, task, local, opProcCtx);
            return true;
        }
        return false;
    }

    static void splitPlan(ReduceSinkOperator cRS, Task<? extends Serializable> parentTask, Task<? extends Serializable> childTask, GenMRProcContext opProcCtx) throws SemanticException {
        assert (parentTask != null && childTask != null);
        GenMapRedUtils.splitTasks(cRS, parentTask, childTask, opProcCtx);
    }

    static void splitPlan(ReduceSinkOperator cRS, GenMRProcContext opProcCtx) throws SemanticException {
        ParseContext parseCtx = opProcCtx.getParseCtx();
        Task<? extends Serializable> parentTask = opProcCtx.getCurrTask();
        MapredWork childPlan = GenMapRedUtils.getMapRedWork(parseCtx);
        Task<MapredWork> childTask = TaskFactory.get(childPlan);
        Operator<OperatorDesc> reducer = cRS.getChildOperators().get(0);
        ReduceWork rWork = new ReduceWork();
        childPlan.setReduceWork(rWork);
        rWork.setReducer(reducer);
        ReduceSinkDesc desc = (ReduceSinkDesc)cRS.getConf();
        childPlan.getReduceWork().setNumReduceTasks(new Integer(desc.getNumReducers()));
        opProcCtx.getOpTaskMap().put(reducer, childTask);
        GenMapRedUtils.splitTasks(cRS, parentTask, childTask, opProcCtx);
    }

    public static void setTaskPlan(String alias_id, TableScanOperator topOp, Task<?> task, boolean local, GenMRProcContext opProcCtx) throws SemanticException {
        GenMapRedUtils.setTaskPlan(alias_id, topOp, task, local, opProcCtx, null);
    }

    public static void setTaskPlan(String alias_id, TableScanOperator topOp, Task<?> task, boolean local, GenMRProcContext opProcCtx, PrunedPartitionList pList) throws SemanticException {
        GenMapRedUtils.setMapWork(((MapredWork)task.getWork()).getMapWork(), opProcCtx.getParseCtx(), opProcCtx.getInputs(), pList, topOp, alias_id, opProcCtx.getConf(), local);
        opProcCtx.addSeenOp(task, topOp);
    }

    public static void setMapWork(MapWork plan, ParseContext parseCtx, Set<ReadEntity> inputs, PrunedPartitionList partsList, TableScanOperator tsOp, String alias_id, HiveConf conf, boolean local) throws SemanticException {
        Map<String, String> props;
        ArrayList<Path> partDir = new ArrayList<Path>();
        ArrayList<PartitionDesc> partDesc = new ArrayList<PartitionDesc>();
        boolean isFullAcidTable = false;
        Path tblDir = null;
        plan.setNameToSplitSample(parseCtx.getNameToSplitSample());
        if (parseCtx.getAnalyzeRewrite() != null) {
            plan.setGatheringStats(true);
        }
        if (partsList == null) {
            partsList = PartitionPruner.prune(tsOp, parseCtx, alias_id);
            isFullAcidTable = ((TableScanDesc)tsOp.getConf()).isFullAcidTable();
        }
        Set<Partition> parts = partsList.getPartitions();
        TableDesc tableSpec = Utilities.getTableDesc(((TableScanDesc)tsOp.getConf()).getTableMetadata());
        PartitionDesc aliasPartnDesc = null;
        try {
            if (!parts.isEmpty()) {
                aliasPartnDesc = Utilities.getPartitionDesc(parts.iterator().next(), tableSpec);
            }
        }
        catch (HiveException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        if (aliasPartnDesc == null) {
            aliasPartnDesc = new PartitionDesc(tableSpec, null);
        }
        if ((props = ((TableScanDesc)tsOp.getConf()).getOpProps()) != null) {
            Properties target = aliasPartnDesc.getProperties();
            target.putAll(props);
        }
        plan.getAliasToPartnInfo().put(alias_id, aliasPartnDesc);
        long sizeNeeded = Integer.MAX_VALUE;
        int fileLimit = -1;
        if (parseCtx.getGlobalLimitCtx().isEnable()) {
            if (isFullAcidTable) {
                LOG.info("Skipping Global Limit optimization for an ACID table");
                parseCtx.getGlobalLimitCtx().disableOpt();
            } else {
                long sizePerRow = HiveConf.getLongVar(parseCtx.getConf(), HiveConf.ConfVars.HIVELIMITMAXROWSIZE);
                sizeNeeded = (long)(parseCtx.getGlobalLimitCtx().getGlobalOffset() + parseCtx.getGlobalLimitCtx().getGlobalLimit()) * sizePerRow;
                fileLimit = HiveConf.getIntVar(parseCtx.getConf(), HiveConf.ConfVars.HIVELIMITOPTLIMITFILE);
                if (sizePerRow <= 0L || fileLimit <= 0) {
                    LOG.info("Skip optimization to reduce input size of 'limit'");
                    parseCtx.getGlobalLimitCtx().disableOpt();
                } else if (parts.isEmpty()) {
                    LOG.info("Empty input: skip limit optimization");
                } else {
                    LOG.info("Try to reduce input size for 'limit' sizeNeeded: " + sizeNeeded + "  file limit : " + fileLimit);
                }
            }
        }
        boolean isFirstPart = true;
        boolean emptyInput = true;
        boolean singlePartition = parts.size() == 1;
        Map<String, ReadEntity> viewToInput = parseCtx.getViewAliasToInput();
        ReadEntity parentViewInfo = PlanUtils.getParentViewInfo(alias_id, viewToInput);
        boolean isDirectRead = parentViewInfo == null;
        TableDesc tblDesc = null;
        boolean initTableDesc = false;
        PlanUtils.addPartitionInputs(parts, inputs, parentViewInfo, isDirectRead);
        for (Partition part : parts) {
            ExprNodeDesc listBucketingPruner;
            Path[] paths = null;
            FilterDesc.SampleDesc sampleDescr = parseCtx.getOpToSamplePruner().get(tsOp);
            Map<String, ExprNodeDesc> partToPruner = parseCtx.getOpToPartToSkewedPruner().get(tsOp);
            ExprNodeDesc exprNodeDesc = listBucketingPruner = partToPruner != null ? partToPruner.get(part.getName()) : null;
            if (sampleDescr != null) {
                assert (listBucketingPruner == null) : "Sampling and list bucketing can't coexit.";
                paths = SamplePruner.prune(part, sampleDescr);
                parseCtx.getGlobalLimitCtx().disableOpt();
            } else if (listBucketingPruner != null) {
                assert (sampleDescr == null) : "Sampling and list bucketing can't coexist.";
                paths = ListBucketingPruner.prune(parseCtx, part, listBucketingPruner);
            } else {
                if (parseCtx.getGlobalLimitCtx().isEnable()) {
                    if (isFirstPart) {
                        long sizeLeft = sizeNeeded;
                        ArrayList<Path> retPathList = new ArrayList<Path>();
                        SamplePruner.LimitPruneRetStatus status = SamplePruner.limitPrune(part, sizeLeft, fileLimit, retPathList);
                        if (status.equals((Object)SamplePruner.LimitPruneRetStatus.NoFile)) continue;
                        if (status.equals((Object)SamplePruner.LimitPruneRetStatus.NotQualify)) {
                            LOG.info("Use full input -- first " + fileLimit + " files are more than " + sizeNeeded + " bytes");
                            parseCtx.getGlobalLimitCtx().disableOpt();
                        } else {
                            emptyInput = false;
                            paths = new Path[retPathList.size()];
                            int index = 0;
                            for (Path path : retPathList) {
                                paths[index++] = path;
                            }
                            if (status.equals((Object)SamplePruner.LimitPruneRetStatus.NeedAllFiles) && singlePartition) {
                                parseCtx.getGlobalLimitCtx().disableOpt();
                            }
                        }
                        isFirstPart = false;
                    } else {
                        paths = new Path[]{};
                    }
                }
                if (!parseCtx.getGlobalLimitCtx().isEnable()) {
                    paths = part.getPath();
                }
            }
            if (!part.getTable().isPartitioned()) {
                assert (tblDir == null);
                tblDir = paths[0];
                if (!initTableDesc) {
                    tblDesc = Utilities.getTableDesc(part.getTable());
                    initTableDesc = true;
                }
            } else if (tblDesc == null && !initTableDesc) {
                tblDesc = Utilities.getTableDesc(part.getTable());
                initTableDesc = true;
            }
            if (props != null) {
                Properties target = tblDesc.getProperties();
                target.putAll(props);
            }
            for (Path p : paths) {
                if (p == null) continue;
                String path = p.toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding " + path + " of table " + alias_id);
                }
                partDir.add(p);
                try {
                    if (part.getTable().isPartitioned()) {
                        partDesc.add(Utilities.getPartitionDesc(part, tblDesc));
                        continue;
                    }
                    partDesc.add(Utilities.getPartitionDescFromTableDesc(tblDesc, part, false));
                }
                catch (HiveException e) {
                    LOG.error(StringUtils.stringifyException((Throwable)e));
                    throw new SemanticException(e.getMessage(), e);
                }
            }
        }
        if (emptyInput) {
            parseCtx.getGlobalLimitCtx().disableOpt();
        }
        Utilities.addSchemaEvolutionToTableScanOperator(partsList.getSourceTable(), tsOp);
        Iterator iterPath = partDir.iterator();
        Iterator iterPartnDesc = partDesc.iterator();
        if (!local) {
            while (iterPath.hasNext()) {
                assert (iterPartnDesc.hasNext());
                Path path = (Path)iterPath.next();
                PartitionDesc prtDesc = (PartitionDesc)iterPartnDesc.next();
                plan.addPathToAlias(path, alias_id);
                plan.addPathToPartitionInfo(path, prtDesc);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Information added for path " + path);
            }
            assert (plan.getAliasToWork().get(alias_id) == null);
            plan.getAliasToWork().put(alias_id, tsOp);
        } else {
            MapredLocalWork localPlan = plan.getMapRedLocalWork();
            if (localPlan == null) {
                localPlan = new MapredLocalWork(new LinkedHashMap<String, Operator<? extends OperatorDesc>>(), new LinkedHashMap<String, FetchWork>());
            }
            assert (localPlan.getAliasToWork().get(alias_id) == null);
            assert (localPlan.getAliasToFetchWork().get(alias_id) == null);
            localPlan.getAliasToWork().put(alias_id, tsOp);
            if (tblDir == null) {
                tblDesc = Utilities.getTableDesc(partsList.getSourceTable());
                localPlan.getAliasToFetchWork().put(alias_id, new FetchWork(partDir, partDesc, tblDesc));
            } else {
                localPlan.getAliasToFetchWork().put(alias_id, new FetchWork(tblDir, tblDesc));
            }
            plan.setMapRedLocalWork(localPlan);
        }
    }

    public static void setTaskPlan(Path path, String alias, Operator<? extends OperatorDesc> topOp, MapWork plan, boolean local, TableDesc tt_desc) throws SemanticException {
        if (path == null || alias == null) {
            return;
        }
        if (topOp instanceof TableScanOperator) {
            try {
                Utilities.addSchemaEvolutionToTableScanOperator((StructObjectInspector)tt_desc.getDeserializer().getObjectInspector(), (TableScanOperator)topOp);
            }
            catch (Exception e) {
                throw new SemanticException(e);
            }
        }
        if (!local) {
            plan.addPathToAlias(path, alias);
            plan.addPathToPartitionInfo(path, new PartitionDesc(tt_desc, null));
            plan.getAliasToWork().put(alias, topOp);
        } else {
            MapredLocalWork localPlan = plan.getMapRedLocalWork();
            if (localPlan == null) {
                localPlan = new MapredLocalWork(new LinkedHashMap<String, Operator<? extends OperatorDesc>>(), new LinkedHashMap<String, FetchWork>());
            }
            assert (localPlan.getAliasToWork().get(alias) == null);
            assert (localPlan.getAliasToFetchWork().get(alias) == null);
            localPlan.getAliasToWork().put(alias, topOp);
            localPlan.getAliasToFetchWork().put(alias, new FetchWork(new Path(alias), tt_desc));
            plan.setMapRedLocalWork(localPlan);
        }
    }

    public static void setKeyAndValueDesc(ReduceWork work, ReduceSinkOperator rs) {
        work.setKeyDesc(((ReduceSinkDesc)rs.getConf()).getKeySerializeInfo());
        int tag = Math.max(0, ((ReduceSinkDesc)rs.getConf()).getTag());
        List<TableDesc> tagToSchema = work.getTagToValueDesc();
        while (tag + 1 > tagToSchema.size()) {
            tagToSchema.add(null);
        }
        tagToSchema.set(tag, ((ReduceSinkDesc)rs.getConf()).getValueSerializeInfo());
    }

    public static void setKeyAndValueDesc(ReduceWork plan, Operator<? extends OperatorDesc> topOp) {
        if (topOp == null) {
            return;
        }
        if (topOp instanceof ReduceSinkOperator) {
            ReduceSinkOperator rs = (ReduceSinkOperator)topOp;
            GenMapRedUtils.setKeyAndValueDesc(plan, rs);
        } else {
            List<Operator<OperatorDesc>> children = topOp.getChildOperators();
            if (children != null) {
                for (Operator<OperatorDesc> op : children) {
                    GenMapRedUtils.setKeyAndValueDesc(plan, op);
                }
            }
        }
    }

    public static void setKeyAndValueDescForTaskTree(Task<? extends Serializable> task) {
        AbstractOperatorDesc work;
        if (task instanceof ConditionalTask) {
            List<Task<? extends Serializable>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task<? extends Serializable> task2 : listTasks) {
                GenMapRedUtils.setKeyAndValueDescForTaskTree(task2);
            }
        } else if (task instanceof ExecDriver) {
            work = (MapredWork)task.getWork();
            ((MapredWork)work).getMapWork().deriveExplainAttributes();
            Iterator<BaseWork> opMap = ((MapredWork)work).getMapWork().getAliasToWork();
            if (opMap != null && !((HashMap)((Object)opMap)).isEmpty()) {
                for (Operator op : ((HashMap)((Object)opMap)).values()) {
                    GenMapRedUtils.setKeyAndValueDesc(((MapredWork)work).getReduceWork(), op);
                }
            }
        } else if (task != null && task.getWork() instanceof TezWork) {
            work = (TezWork)task.getWork();
            for (BaseWork baseWork : ((TezWork)work).getAllWorkUnsorted()) {
                if (!(baseWork instanceof MapWork)) continue;
                ((MapWork)baseWork).deriveExplainAttributes();
            }
        } else if (task instanceof SparkTask) {
            work = (SparkWork)task.getWork();
            for (BaseWork baseWork : ((SparkWork)work).getAllWorkUnsorted()) {
                if (!(baseWork instanceof MapWork)) continue;
                ((MapWork)baseWork).deriveExplainAttributes();
            }
        }
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<Serializable> childTask : task.getChildTasks()) {
            GenMapRedUtils.setKeyAndValueDescForTaskTree(childTask);
        }
    }

    public static void deriveFinalExplainAttributes(Task<? extends Serializable> task, Configuration conf) {
        AbstractOperatorDesc work;
        if (task instanceof ConditionalTask) {
            for (Task<? extends Serializable> task2 : ((ConditionalTask)task).getListTasks()) {
                GenMapRedUtils.deriveFinalExplainAttributes(task2, conf);
            }
        } else if (task instanceof ExecDriver) {
            work = (MapredWork)task.getWork();
            ((MapredWork)work).getMapWork().deriveLlap(conf, true);
        } else if (task != null && task.getWork() instanceof TezWork) {
            work = (TezWork)task.getWork();
            for (BaseWork w : ((TezWork)work).getAllWorkUnsorted()) {
                if (!(w instanceof MapWork)) continue;
                ((MapWork)w).deriveLlap(conf, false);
            }
        } else if (task instanceof SparkTask) {
            work = (SparkWork)task.getWork();
            for (BaseWork w : ((SparkWork)work).getAllWorkUnsorted()) {
                if (!(w instanceof MapWork)) continue;
                ((MapWork)w).deriveLlap(conf, false);
            }
        }
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<? extends Serializable> task3 : task.getChildTasks()) {
            GenMapRedUtils.deriveFinalExplainAttributes(task3, conf);
        }
    }

    public static void internTableDesc(Task<?> task, Interner<TableDesc> interner) {
        AbstractOperatorDesc work;
        if (task instanceof ConditionalTask) {
            for (Task<? extends Serializable> task2 : ((ConditionalTask)task).getListTasks()) {
                GenMapRedUtils.internTableDesc(task2, interner);
            }
        } else if (task instanceof ExecDriver) {
            work = (MapredWork)task.getWork();
            ((MapredWork)work).getMapWork().internTable(interner);
        } else if (task != null && task.getWork() instanceof TezWork) {
            work = (TezWork)task.getWork();
            for (BaseWork w : ((TezWork)work).getAllWorkUnsorted()) {
                if (!(w instanceof MapWork)) continue;
                ((MapWork)w).internTable(interner);
            }
        }
        if (task.getNumChild() > 0) {
            for (Task<? extends Serializable> task3 : task.getChildTasks()) {
                GenMapRedUtils.internTableDesc(task3, interner);
            }
        }
    }

    public static MapredWork getMapRedWork(ParseContext parseCtx) {
        MapredWork work = GenMapRedUtils.getMapRedWorkFromConf(parseCtx.getConf());
        work.getMapWork().setNameToSplitSample(parseCtx.getNameToSplitSample());
        return work;
    }

    public static MapredWork getMapRedWorkFromConf(HiveConf conf) {
        MapredWork mrWork = new MapredWork();
        MapWork work = mrWork.getMapWork();
        boolean mapperCannotSpanPartns = conf.getBoolVar(HiveConf.ConfVars.HIVE_MAPPER_CANNOT_SPAN_MULTIPLE_PARTITIONS);
        work.setMapperCannotSpanPartns(mapperCannotSpanPartns);
        work.setPathToAliases(new LinkedHashMap<Path, ArrayList<String>>());
        work.setPathToPartitionInfo(new LinkedHashMap<Path, PartitionDesc>());
        work.setAliasToWork(new LinkedHashMap<String, Operator<? extends OperatorDesc>>());
        return mrWork;
    }

    public static TableScanOperator createTemporaryTableScanOperator(CompilationOpContext ctx, RowSchema rowSchema) {
        TableScanOperator tableScanOp = (TableScanOperator)OperatorFactory.get(ctx, new TableScanDesc(null), rowSchema);
        ArrayList<Integer> neededColumnIds = new ArrayList<Integer>();
        ArrayList<String> neededColumnNames = new ArrayList<String>();
        ArrayList<ColumnInfo> parentColumnInfos = rowSchema.getSignature();
        for (int i = 0; i < parentColumnInfos.size(); ++i) {
            neededColumnIds.add(i);
            neededColumnNames.add(((ColumnInfo)parentColumnInfos.get(i)).getInternalName());
        }
        tableScanOp.setNeededColumnIDs(neededColumnIds);
        tableScanOp.setNeededColumns(neededColumnNames);
        tableScanOp.setReferencedColumns(neededColumnNames);
        return tableScanOp;
    }

    public static TableScanOperator createTemporaryFile(Operator<? extends OperatorDesc> parent, Operator<? extends OperatorDesc> child, Path taskTmpDir, TableDesc tt_desc, ParseContext parseCtx) {
        boolean compressIntermediate = parseCtx.getConf().getBoolVar(HiveConf.ConfVars.COMPRESSINTERMEDIATE);
        FileSinkDesc desc = new FileSinkDesc(taskTmpDir, tt_desc, compressIntermediate);
        if (compressIntermediate) {
            desc.setCompressCodec(parseCtx.getConf().getVar(HiveConf.ConfVars.COMPRESSINTERMEDIATECODEC));
            desc.setCompressType(parseCtx.getConf().getVar(HiveConf.ConfVars.COMPRESSINTERMEDIATETYPE));
        }
        Operator<FileSinkDesc> fileSinkOp = OperatorFactory.get(parent.getCompilationOpContext(), desc, parent.getSchema());
        parent.replaceChild(child, fileSinkOp);
        fileSinkOp.setParentOperators(Utilities.makeList(parent));
        TableScanOperator tableScanOp = GenMapRedUtils.createTemporaryTableScanOperator(parent.getCompilationOpContext(), parent.getSchema());
        tableScanOp.setChildOperators(Utilities.makeList(child));
        child.replaceParent(parent, tableScanOp);
        return tableScanOp;
    }

    private static void splitTasks(ReduceSinkOperator op, Task<? extends Serializable> parentTask, Task<? extends Serializable> childTask, GenMRProcContext opProcCtx) throws SemanticException {
        if (op.getNumParent() != 1) {
            throw new IllegalStateException("Expecting operator " + op + " to have one parent. But found multiple parents : " + op.getParentOperators());
        }
        ParseContext parseCtx = opProcCtx.getParseCtx();
        parentTask.addDependentTask(childTask);
        List<Task<? extends Serializable>> rootTasks = opProcCtx.getRootTasks();
        if (rootTasks.contains(childTask)) {
            rootTasks.remove(childTask);
        }
        Context baseCtx = parseCtx.getContext();
        Path taskTmpDir = baseCtx.getMRTmpPath();
        Operator<OperatorDesc> parent = op.getParentOperators().get(0);
        TableDesc tt_desc = PlanUtils.getIntermediateFileTableDesc(PlanUtils.getFieldSchemasFromRowSchema(parent.getSchema(), "temporarycol"));
        TableScanOperator tableScanOp = GenMapRedUtils.createTemporaryFile(parent, op, taskTmpDir, tt_desc, parseCtx);
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = opProcCtx.getMapCurrCtx();
        mapCurrCtx.put(tableScanOp, new GenMRProcContext.GenMapRedCtx(childTask, null));
        String streamDesc = taskTmpDir.toUri().toString();
        MapredWork cplan = (MapredWork)childTask.getWork();
        if (GenMapRedUtils.needsTagging(cplan.getReduceWork())) {
            Operator<?> reducerOp = cplan.getReduceWork().getReducer();
            String id = null;
            if (reducerOp instanceof JoinOperator) {
                if (parseCtx.getJoinOps().contains(reducerOp)) {
                    id = ((JoinDesc)((JoinOperator)reducerOp).getConf()).getId();
                }
            } else if (reducerOp instanceof MapJoinOperator) {
                if (parseCtx.getMapJoinOps().contains(reducerOp)) {
                    id = ((MapJoinDesc)((MapJoinOperator)reducerOp).getConf()).getId();
                }
            } else if (reducerOp instanceof SMBMapJoinOperator && parseCtx.getSmbMapJoinOps().contains(reducerOp)) {
                id = ((SMBJoinDesc)((SMBMapJoinOperator)reducerOp).getConf()).getId();
            }
            streamDesc = id != null ? id + ":$INTNAME" : "$INTNAME";
            String origStreamDesc = streamDesc;
            int pos = 0;
            while (cplan.getMapWork().getAliasToWork().get(streamDesc) != null) {
                streamDesc = origStreamDesc.concat(String.valueOf(++pos));
            }
            cplan.getReduceWork().setNeedsTagging(true);
        }
        GenMapRedUtils.setTaskPlan(taskTmpDir, streamDesc, tableScanOp, cplan.getMapWork(), false, tt_desc);
        opProcCtx.setCurrTopOp(null);
        opProcCtx.setCurrAliasId(null);
        opProcCtx.setCurrTask(childTask);
        opProcCtx.addRootIfPossible(parentTask);
    }

    static boolean hasBranchFinished(Object ... children) {
        for (Object child : children) {
            if (child != null) continue;
            return false;
        }
        return true;
    }

    public static void replaceMapWork(String sourceAlias, String targetAlias, MapWork source, MapWork target) {
        LinkedHashMap<Path, ArrayList<String>> sourcePathToAliases = source.getPathToAliases();
        LinkedHashMap<Path, PartitionDesc> sourcePathToPartitionInfo = source.getPathToPartitionInfo();
        LinkedHashMap<String, Operator<? extends OperatorDesc>> sourceAliasToWork = source.getAliasToWork();
        LinkedHashMap<String, PartitionDesc> sourceAliasToPartnInfo = source.getAliasToPartnInfo();
        LinkedHashMap<Path, ArrayList<String>> targetPathToAliases = target.getPathToAliases();
        LinkedHashMap<Path, PartitionDesc> targetPathToPartitionInfo = target.getPathToPartitionInfo();
        LinkedHashMap<String, Operator<? extends OperatorDesc>> targetAliasToWork = target.getAliasToWork();
        LinkedHashMap<String, PartitionDesc> targetAliasToPartnInfo = target.getAliasToPartnInfo();
        if (!sourceAliasToWork.containsKey(sourceAlias) || !targetAliasToWork.containsKey(targetAlias)) {
            return;
        }
        if (sourceAliasToWork.size() > 1) {
            return;
        }
        targetAliasToWork.remove(targetAlias);
        targetAliasToPartnInfo.remove(targetAlias);
        ArrayList<Path> pathsToRemove = new ArrayList<Path>();
        for (Map.Entry<Path, ArrayList<String>> entry : targetPathToAliases.entrySet()) {
            ArrayList<String> aliases = entry.getValue();
            aliases.remove(targetAlias);
            if (!aliases.isEmpty()) continue;
            pathsToRemove.add(entry.getKey());
        }
        for (Path pathToRemove : pathsToRemove) {
            targetPathToAliases.remove(pathToRemove);
            targetPathToPartitionInfo.remove(pathToRemove);
        }
        targetAliasToWork.put(sourceAlias, (Operator<? extends OperatorDesc>)sourceAliasToWork.get(sourceAlias));
        targetAliasToPartnInfo.putAll(sourceAliasToPartnInfo);
        targetPathToPartitionInfo.putAll(sourcePathToPartitionInfo);
        ArrayList pathsToAdd = new ArrayList();
        for (Map.Entry entry : sourcePathToAliases.entrySet()) {
            ArrayList aliases = (ArrayList)entry.getValue();
            if (!aliases.contains(sourceAlias)) continue;
            pathsToAdd.add(entry.getKey());
        }
        for (Path pathToAdd : pathsToAdd) {
            if (!targetPathToAliases.containsKey(pathToAdd)) {
                targetPathToAliases.put(pathToAdd, new ArrayList());
            }
            targetPathToAliases.get(pathToAdd).add(sourceAlias);
        }
        target.setPathToAliases(targetPathToAliases);
        target.setPathToPartitionInfo(targetPathToPartitionInfo);
    }

    public static void createMRWorkForMergingFiles(FileSinkOperator fsInput, Path finalName, DependencyCollectionTask dependencyTask, List<Task<MoveWork>> mvTasks, HiveConf conf, Task<? extends Serializable> currTask, LineageState lineageState) throws SemanticException {
        AbstractOperatorDesc work;
        MapWork cplan;
        DynamicPartitionCtx dpCtx;
        FileSinkDesc fsInputDesc = (FileSinkDesc)fsInput.getConf();
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Creating merge work from " + System.identityHashCode(fsInput) + " with write ID " + (fsInputDesc.isMmTable() ? Long.valueOf(fsInputDesc.getTableWriteId()) : null) + " into " + finalName);
        }
        boolean isBlockMerge = conf.getBoolVar(HiveConf.ConfVars.HIVEMERGERCFILEBLOCKLEVEL) && fsInputDesc.getTableInfo().getInputFileFormatClass().equals(RCFileInputFormat.class) || conf.getBoolVar(HiveConf.ConfVars.HIVEMERGEORCFILESTRIPELEVEL) && fsInputDesc.getTableInfo().getInputFileFormatClass().equals(OrcInputFormat.class);
        RowSchema inputRS = fsInput.getSchema();
        Long srcMmWriteId = fsInputDesc.isMmTable() ? Long.valueOf(fsInputDesc.getTableWriteId()) : null;
        FileSinkDesc fsOutputDesc = null;
        TableScanOperator tsMerge = null;
        if (!isBlockMerge) {
            tsMerge = GenMapRedUtils.createTemporaryTableScanOperator(fsInput.getCompilationOpContext(), inputRS);
            TableDesc ts = (TableDesc)fsInputDesc.getTableInfo().clone();
            Path mergeDest = srcMmWriteId == null ? finalName : finalName.getParent();
            fsOutputDesc = new FileSinkDesc(mergeDest, ts, conf.getBoolVar(HiveConf.ConfVars.COMPRESSRESULT));
            fsOutputDesc.setMmWriteId(srcMmWriteId);
            fsOutputDesc.setIsMerge(true);
            OperatorFactory.getAndMakeChild(fsOutputDesc, inputRS, (Operator)tsMerge, new Operator[0]);
        }
        if ((dpCtx = fsInputDesc.getDynPartCtx()) != null && dpCtx.getNumDPCols() > 0) {
            ArrayList<ColumnInfo> signature = inputRS.getSignature();
            String tblAlias = fsInputDesc.getTableInfo().getTableName();
            for (String dpCol : dpCtx.getDPColNames()) {
                ColumnInfo colInfo = new ColumnInfo(dpCol, TypeInfoFactory.stringTypeInfo, tblAlias, true);
                signature.add(colInfo);
            }
            inputRS.setSignature(signature);
            if (!isBlockMerge) {
                DynamicPartitionCtx dpCtx2 = new DynamicPartitionCtx(dpCtx);
                fsOutputDesc.setDynPartCtx(dpCtx2);
            }
            GenMapRedUtils.usePartitionColumns(fsInputDesc.getTableInfo().getProperties(), dpCtx.getDPColNames());
        } else {
            fsInputDesc.getTableInfo().getProperties().remove("partition_columns");
        }
        Path inputDirName = fsInputDesc.getMergeInputDirName();
        if (isBlockMerge) {
            cplan = GenMapRedUtils.createMergeTask(fsInputDesc, finalName, dpCtx != null && dpCtx.getNumDPCols() > 0, fsInput.getCompilationOpContext());
            if (conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                work = new TezWork(conf.getVar(HiveConf.ConfVars.HIVEQUERYID), conf);
                cplan.setName("File Merge");
                work.add(cplan);
            } else if (conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark")) {
                work = new SparkWork(conf.getVar(HiveConf.ConfVars.HIVEQUERYID));
                cplan.setName("Spark Merge File Work");
                ((SparkWork)work).add(cplan);
            } else {
                work = cplan;
            }
        } else {
            cplan = GenMapRedUtils.createMRWorkForMergingFiles(conf, tsMerge, fsInputDesc);
            if (conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                work = new TezWork(conf.getVar(HiveConf.ConfVars.HIVEQUERYID), conf);
                cplan.setName("File Merge");
                work.add(cplan);
            } else if (conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark")) {
                work = new SparkWork(conf.getVar(HiveConf.ConfVars.HIVEQUERYID));
                cplan.setName("Spark Merge File Work");
                ((SparkWork)work).add(cplan);
            } else {
                work = new MapredWork();
                ((MapredWork)work).setMapWork(cplan);
            }
        }
        cplan.setInputformat("org.apache.hadoop.hive.ql.io.CombineHiveInputFormat");
        MoveWork dummyMv = null;
        if (srcMmWriteId == null) {
            dummyMv = new MoveWork(null, null, null, new LoadFileDesc(inputDirName, finalName, true, null, null, false), false);
        }
        Path fsopPath = srcMmWriteId != null ? fsInputDesc.getFinalDirName() : finalName;
        Task<MoveWork> mvTask = GenMapRedUtils.findMoveTaskForFsopOutput(mvTasks, fsopPath, fsInputDesc.isMmTable());
        ConditionalTask cndTsk = GenMapRedUtils.createCondTask(conf, currTask, dummyMv, work, fsInputDesc.getMergeInputDirName(), finalName, mvTask, dependencyTask, lineageState);
        ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx mrCtx = (ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx)cndTsk.getResolverCtx();
        mrCtx.setDPCtx(fsInputDesc.getDynPartCtx());
        mrCtx.setLbCtx(fsInputDesc.getLbCtx());
    }

    private static void linkMoveTask(Task<MoveWork> mvTask, Task<? extends Serializable> task, HiveConf hconf, DependencyCollectionTask dependencyTask) {
        if (task.getDependentTasks() == null || task.getDependentTasks().isEmpty()) {
            GenMapRedUtils.addDependentMoveTasks(mvTask, hconf, task, dependencyTask);
        } else {
            for (Task<Serializable> childTask : task.getDependentTasks()) {
                GenMapRedUtils.linkMoveTask(mvTask, childTask, hconf, dependencyTask);
            }
        }
    }

    public static void addDependentMoveTasks(Task<MoveWork> mvTask, HiveConf hconf, Task<? extends Serializable> parentTask, DependencyCollectionTask dependencyTask) {
        if (mvTask != null) {
            if (dependencyTask != null) {
                parentTask.addDependentTask(dependencyTask);
                if (mvTask.getWork().getLoadTableWork() != null) {
                    dependencyTask.addDependentTask(mvTask);
                } else {
                    parentTask.addDependentTask(mvTask);
                }
            } else {
                parentTask.addDependentTask(mvTask);
            }
        }
    }

    private static Path getTableLocationPath(HiveConf hconf, TableDesc tableDesc) {
        Table table = null;
        try {
            Hive hive = Hive.get(hconf);
            table = hive.getTable(tableDesc.getTableName());
        }
        catch (HiveException e) {
            LOG.warn("Unable to get the table location path for: " + tableDesc.getTableName(), (Throwable)e);
        }
        return table != null ? table.getPath() : null;
    }

    public static void addStatsTask(FileSinkOperator nd, MoveTask mvTask, Task<? extends Serializable> currTask, HiveConf hconf) {
        AbstractOperatorDesc work;
        MoveWork mvWork = (MoveWork)mvTask.getWork();
        BasicStatsWork statsWork = null;
        Table table = null;
        boolean truncate = false;
        if (mvWork.getLoadTableWork() != null) {
            statsWork = new BasicStatsWork(mvWork.getLoadTableWork());
            String tableName = mvWork.getLoadTableWork().getTable().getTableName();
            truncate = mvWork.getLoadTableWork().getReplace();
            try {
                table = Hive.get().getTable(SessionState.get().getCurrentDatabase(), tableName);
            }
            catch (HiveException e) {
                throw new RuntimeException("unexpected; table should be present already..: " + tableName, e);
            }
        } else if (mvWork.getLoadFileWork() != null) {
            statsWork = new BasicStatsWork(mvWork.getLoadFileWork());
            truncate = true;
            if (mvWork.getLoadFileWork().getCtasCreateTableDesc() != null) {
                try {
                    table = mvWork.getLoadFileWork().getCtasCreateTableDesc().toTable(hconf);
                }
                catch (HiveException e) {
                    LOG.debug("can't pre-create table for CTAS", (Throwable)e);
                    table = null;
                }
            } else if (mvWork.getLoadFileWork().getCreateViewDesc() != null) {
                try {
                    table = mvWork.getLoadFileWork().getCreateViewDesc().toTable(hconf);
                }
                catch (HiveException e) {
                    LOG.debug("can't pre-create table for MV", (Throwable)e);
                    table = null;
                }
            } else {
                throw new RuntimeException("unexpected; this should be a CTAS or a CREATE/REBUILD MV - however no desc present");
            }
        }
        assert (statsWork != null) : "Error when generating StatsTask";
        if (currTask.getWork() instanceof MapredWork) {
            MapredWork mrWork = (MapredWork)currTask.getWork();
            mrWork.getMapWork().setGatheringStats(true);
            if (mrWork.getReduceWork() != null) {
                mrWork.getReduceWork().setGatheringStats(true);
            }
        } else if (currTask.getWork() instanceof SparkWork) {
            work = (SparkWork)currTask.getWork();
            for (BaseWork w : ((SparkWork)work).getAllWork()) {
                w.setGatheringStats(true);
            }
        } else {
            work = (TezWork)currTask.getWork();
            for (BaseWork w : ((TezWork)work).getAllWork()) {
                w.setGatheringStats(true);
            }
        }
        StatsWork columnStatsWork = new StatsWork(table, statsWork, hconf);
        columnStatsWork.collectStatsFromAggregator((IStatsGatherDesc)nd.getConf());
        columnStatsWork.truncateExisting(truncate);
        columnStatsWork.setSourceTask(currTask);
        Task<StatsWork> statsTask = TaskFactory.get(columnStatsWork);
        mvTask.addDependentTask(statsTask);
        statsTask.subscribeFeed(mvTask);
    }

    public static boolean isInsertInto(ParseContext parseCtx, FileSinkOperator fsOp) {
        return ((FileSinkDesc)fsOp.getConf()).getTableInfo().getTableName() != null;
    }

    private static MapWork createMRWorkForMergingFiles(HiveConf conf, TableScanOperator topOp, FileSinkDesc fsDesc) {
        ArrayList<String> aliases = new ArrayList<String>();
        Path inputDir = StringInternUtils.internUriStringsInPath(fsDesc.getMergeInputDirName());
        String inputDirStr = inputDir.toString().intern();
        TableDesc tblDesc = fsDesc.getTableInfo();
        aliases.add(inputDirStr);
        MapredWork cMrPlan = GenMapRedUtils.getMapRedWorkFromConf(conf);
        MapWork cplan = cMrPlan.getMapWork();
        cplan.addPathToAlias(inputDir, aliases);
        cplan.addPathToPartitionInfo(inputDir, new PartitionDesc(tblDesc, null));
        cplan.getAliasToWork().put(inputDirStr, topOp);
        cplan.setMapperCannotSpanPartns(true);
        return cplan;
    }

    public static MapWork createMergeTask(FileSinkDesc fsInputDesc, Path finalName, boolean hasDynamicPartitions, CompilationOpContext ctx) throws SemanticException {
        Class internalIFClass;
        Path inputDir = fsInputDesc.getMergeInputDirName();
        TableDesc tblDesc = fsInputDesc.getTableInfo();
        ArrayList<Path> inputDirs = new ArrayList<Path>(1);
        ArrayList<String> inputDirstr = new ArrayList<String>(1);
        if (!hasDynamicPartitions && !GenMapRedUtils.isSkewedStoredAsDirs(fsInputDesc)) {
            inputDirs.add(inputDir);
        }
        inputDirstr.add(inputDir.toString());
        if (tblDesc.getInputFileFormatClass().equals(RCFileInputFormat.class)) {
            internalIFClass = RCFileBlockMergeInputFormat.class;
        } else if (tblDesc.getInputFileFormatClass().equals(OrcInputFormat.class)) {
            internalIFClass = OrcFileStripeMergeInputFormat.class;
        } else {
            throw new SemanticException("createMergeTask called on a table with file format other than RCFile or ORCFile");
        }
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("creating mergefilework from " + inputDirs + " to " + finalName);
        }
        MergeFileWork work = new MergeFileWork(inputDirs, finalName, hasDynamicPartitions, tblDesc.getInputFileFormatClass().getName(), tblDesc);
        LinkedHashMap<Path, ArrayList<String>> pathToAliases = new LinkedHashMap<Path, ArrayList<String>>();
        pathToAliases.put(inputDir, inputDirstr);
        work.setMapperCannotSpanPartns(true);
        work.setPathToAliases(pathToAliases);
        PartitionDesc pDesc = new PartitionDesc(tblDesc, null);
        pDesc.setInputFileFormatClass(internalIFClass);
        work.addPathToPartitionInfo(inputDir, pDesc);
        work.setListBucketingCtx(fsInputDesc.getLbCtx());
        LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = new LinkedHashMap<String, Operator<? extends OperatorDesc>>();
        Operator<FileMergeDesc> mergeOp = null;
        FileMergeDesc fmd = tblDesc.getInputFileFormatClass().equals(RCFileInputFormat.class) ? new RCFileMergeDesc() : new OrcFileMergeDesc();
        fmd.setIsMmTable(fsInputDesc.isMmTable());
        fmd.setWriteId(fsInputDesc.getTableWriteId());
        int stmtId = fsInputDesc.getStatementId();
        fmd.setStmtId(stmtId == -1 ? 0 : stmtId);
        fmd.setDpCtx(fsInputDesc.getDynPartCtx());
        fmd.setOutputPath(finalName);
        fmd.setHasDynamicPartitions(work.hasDynamicPartitions());
        fmd.setListBucketingAlterTableConcatenate(work.isListBucketingAlterTableConcatenate());
        int lbLevel = work.getListBucketingCtx() == null ? 0 : work.getListBucketingCtx().calculateListBucketingLevel();
        fmd.setListBucketingDepth(lbLevel);
        mergeOp = OperatorFactory.get(ctx, fmd);
        aliasToWork.put(inputDir.toString(), mergeOp);
        work.setAliasToWork(aliasToWork);
        return work;
    }

    @VisibleForTesting
    protected static boolean shouldMergeMovePaths(HiveConf conf, Path condInputPath, Path condOutputPath, MoveWork linkedMoveWork) {
        Path linkedTargetPath;
        Path linkedSourcePath;
        if (linkedMoveWork == null || !BlobStorageUtils.areOptimizationsEnabled(conf)) {
            return false;
        }
        if (linkedMoveWork.getLoadFileWork() != null && linkedMoveWork.getLoadTableWork() == null) {
            linkedSourcePath = linkedMoveWork.getLoadFileWork().getSourcePath();
            linkedTargetPath = linkedMoveWork.getLoadFileWork().getTargetDir();
        } else if (linkedMoveWork.getLoadTableWork() != null && linkedMoveWork.getLoadFileWork() == null) {
            linkedSourcePath = linkedMoveWork.getLoadTableWork().getSourcePath();
            linkedTargetPath = GenMapRedUtils.getTableLocationPath(conf, linkedMoveWork.getLoadTableWork().getTable());
        } else {
            return false;
        }
        return condOutputPath.equals((Object)linkedSourcePath) && BlobStorageUtils.isBlobStoragePath(conf, condInputPath) && BlobStorageUtils.isBlobStoragePath(conf, linkedTargetPath);
    }

    @VisibleForTesting
    protected static MoveWork mergeMovePaths(Path condInputPath, MoveWork linkedMoveWork, LineageState lineageState) {
        MoveWork newWork = new MoveWork(linkedMoveWork);
        LoadFileDesc fileDesc = null;
        LoadTableDesc tableDesc = null;
        if (linkedMoveWork.getLoadFileWork() != null) {
            fileDesc = new LoadFileDesc(linkedMoveWork.getLoadFileWork());
            fileDesc.setSourcePath(condInputPath);
            lineageState.updateDirToOpMap(condInputPath, linkedMoveWork.getLoadFileWork().getSourcePath());
        } else if (linkedMoveWork.getLoadTableWork() != null) {
            tableDesc = new LoadTableDesc(linkedMoveWork.getLoadTableWork());
            tableDesc.setSourcePath(condInputPath);
            lineageState.updateDirToOpMap(condInputPath, linkedMoveWork.getLoadTableWork().getSourcePath());
        } else {
            throw new IllegalArgumentException("Merging a path with a MoveWork with multi-files work is not allowed.");
        }
        newWork.setLoadFileWork(fileDesc);
        newWork.setLoadTableWork(tableDesc);
        return newWork;
    }

    private static ConditionalTask createCondTask(HiveConf conf, Task<? extends Serializable> currTask, MoveWork mvWork, Serializable mergeWork, Path condInputPath, Path condOutputPath, Task<MoveWork> moveTaskToLink, DependencyCollectionTask dependencyTask, LineageState lineageState) {
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Creating conditional merge task for " + condInputPath);
        }
        Serializable moveWork = mvWork != null ? mvWork : new DependencyCollectionWork();
        boolean shouldMergeMovePaths = moveTaskToLink != null && dependencyTask == null && GenMapRedUtils.shouldMergeMovePaths(conf, condInputPath, condOutputPath, moveTaskToLink.getWork());
        Serializable workForMoveOnlyTask = moveWork;
        if (shouldMergeMovePaths) {
            workForMoveOnlyTask = GenMapRedUtils.mergeMovePaths(condInputPath, moveTaskToLink.getWork(), lineageState);
        }
        Task<Serializable> mergeOnlyMergeTask = TaskFactory.get(mergeWork);
        Task<MoveWork> moveOnlyMoveTask = TaskFactory.get(workForMoveOnlyTask);
        Task<Serializable> mergeAndMoveMergeTask = TaskFactory.get(mergeWork);
        Task<MoveWork> mergeAndMoveMoveTask = TaskFactory.get(moveWork);
        mergeAndMoveMergeTask.addDependentTask(mergeAndMoveMoveTask);
        ArrayList<Serializable> listWorks = new ArrayList<Serializable>();
        listWorks.add(workForMoveOnlyTask);
        listWorks.add(mergeWork);
        ConditionalWork cndWork = new ConditionalWork(listWorks);
        ArrayList<Task<? extends Serializable>> listTasks = new ArrayList<Task<? extends Serializable>>();
        listTasks.add(moveOnlyMoveTask);
        listTasks.add(mergeOnlyMergeTask);
        listTasks.add(mergeAndMoveMergeTask);
        ConditionalTask cndTsk = (ConditionalTask)TaskFactory.get(cndWork);
        cndTsk.setListTasks(listTasks);
        cndTsk.setResolver(new ConditionalResolverMergeFiles());
        ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx mrCtx = new ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx(listTasks, condInputPath.toString());
        cndTsk.setResolverCtx(mrCtx);
        currTask.addDependentTask(cndTsk);
        if (shouldMergeMovePaths) {
            if (moveTaskToLink.getDependentTasks() != null) {
                for (Task<Serializable> dependentTask : moveTaskToLink.getDependentTasks()) {
                    moveOnlyMoveTask.addDependentTask(dependentTask);
                }
            }
        } else {
            GenMapRedUtils.addDependentMoveTasks(moveTaskToLink, conf, moveOnlyMoveTask, dependencyTask);
        }
        GenMapRedUtils.addDependentMoveTasks(moveTaskToLink, conf, mergeOnlyMergeTask, dependencyTask);
        GenMapRedUtils.addDependentMoveTasks(moveTaskToLink, conf, mergeAndMoveMoveTask, dependencyTask);
        return cndTsk;
    }

    public static boolean isSkewedStoredAsDirs(FileSinkDesc fsInputDesc) {
        return fsInputDesc.getLbCtx() == null ? false : fsInputDesc.getLbCtx().isSkewedStoredAsDir();
    }

    public static Task<MoveWork> findMoveTaskForFsopOutput(List<Task<MoveWork>> mvTasks, Path fsopFinalDir, boolean isMmFsop) {
        for (Task<MoveWork> mvTsk : mvTasks) {
            MoveWork mvWork = mvTsk.getWork();
            Path srcDir = null;
            boolean isLfd = false;
            if (mvWork.getLoadFileWork() != null) {
                srcDir = mvWork.getLoadFileWork().getSourcePath();
                isLfd = true;
                if (isMmFsop) {
                    srcDir = srcDir.getParent();
                }
            } else if (mvWork.getLoadTableWork() != null) {
                srcDir = mvWork.getLoadTableWork().getSourcePath();
            }
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Observing MoveWork " + System.identityHashCode(mvWork) + " with " + srcDir + "(from " + (isLfd ? "LFD" : "LTD") + ") while looking for " + fsopFinalDir + "(mm = " + isMmFsop + ")");
            }
            if (srcDir == null || !srcDir.equals((Object)fsopFinalDir)) continue;
            return mvTsk;
        }
        return null;
    }

    public static boolean isMergeRequired(List<Task<MoveWork>> mvTasks, HiveConf hconf, FileSinkOperator fsOp, Task<? extends Serializable> currTask, boolean isInsertTable) {
        if (mvTasks == null || mvTasks.isEmpty()) {
            return false;
        }
        MoveTask mvTask = (MoveTask)GenMapRedUtils.findMoveTaskForFsopOutput(mvTasks, ((FileSinkDesc)fsOp.getConf()).getFinalDirName(), ((FileSinkDesc)fsOp.getConf()).isMmTable());
        if (mvTask != null && isInsertTable && hconf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER) && !((FileSinkDesc)fsOp.getConf()).isMaterialization()) {
            ((FileSinkDesc)fsOp.getConf()).setGatherStats(true);
            ((FileSinkDesc)fsOp.getConf()).setStatsReliable(hconf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
            if (!mvTask.hasFollowingStatsTask()) {
                GenMapRedUtils.addStatsTask(fsOp, mvTask, currTask, hconf);
            }
        }
        if (mvTask == null || mvTask.isLocal() || !((FileSinkDesc)fsOp.getConf()).canBeMerged()) {
            return false;
        }
        if (currTask.getWork() instanceof TezWork) {
            return hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGETEZFILES);
        }
        if (currTask.getWork() instanceof SparkWork) {
            return hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGESPARKFILES);
        }
        return GenMapRedUtils.isMergeRequiredForMr(hconf, fsOp, currTask);
    }

    private static boolean isMergeRequiredForMr(HiveConf hconf, FileSinkOperator fsOp, Task<? extends Serializable> currTask) {
        if (((FileSinkDesc)fsOp.getConf()).isLinkedFileSink()) {
            return hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPFILES) || hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPREDFILES);
        }
        if (currTask.getWork() instanceof MapredWork) {
            boolean mergeMapRed;
            ReduceWork reduceWork = ((MapredWork)currTask.getWork()).getReduceWork();
            boolean mergeMapOnly = hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPFILES) && reduceWork == null;
            boolean bl = mergeMapRed = hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPREDFILES) && reduceWork != null;
            if (mergeMapOnly || mergeMapRed) {
                return true;
            }
        }
        return false;
    }

    public static Path createMoveTask(Task<? extends Serializable> currTask, boolean chDir, FileSinkOperator fsOp, ParseContext parseCtx, List<Task<MoveWork>> mvTasks, HiveConf hconf, DependencyCollectionTask dependencyTask) {
        Path dest = null;
        FileSinkDesc fileSinkDesc = (FileSinkDesc)fsOp.getConf();
        boolean isMmTable = fileSinkDesc.isMmTable();
        if (chDir) {
            dest = fileSinkDesc.getMergeInputDirName();
            if (!isMmTable) {
                Context baseCtx = parseCtx.getContext();
                Path tmpDir = baseCtx.getTempDirForFinalJobPath(fileSinkDesc.getDestPath());
                if (fileSinkDesc.isLinkedFileSink()) {
                    for (FileSinkDesc fsConf : fileSinkDesc.getLinkedFileSinkDesc()) {
                        fsConf.setDirName(new Path(tmpDir, fsConf.getDirName().getName()));
                        if (!Utilities.FILE_OP_LOGGER.isTraceEnabled()) continue;
                        Utilities.FILE_OP_LOGGER.trace("createMoveTask setting tmpDir for LinkedFileSink chDir " + fsConf.getDirName() + "; dest was " + fileSinkDesc.getDestPath());
                    }
                } else {
                    fileSinkDesc.setDirName(tmpDir);
                    if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                        Utilities.FILE_OP_LOGGER.trace("createMoveTask setting tmpDir chDir " + tmpDir + "; dest was " + fileSinkDesc.getDestPath());
                    }
                }
            }
        }
        Task<MoveWork> mvTask = null;
        if (!chDir) {
            mvTask = GenMapRedUtils.findMoveTaskForFsopOutput(mvTasks, ((FileSinkDesc)fsOp.getConf()).getFinalDirName(), ((FileSinkDesc)fsOp.getConf()).isMmTable());
        }
        if (mvTask != null) {
            GenMapRedUtils.addDependentMoveTasks(mvTask, hconf, currTask, dependencyTask);
        }
        return dest;
    }

    public static Set<Partition> getConfirmedPartitionsForScan(TableScanOperator tableScanOp) {
        HashSet<Partition> confirmedPartns = new HashSet<Partition>();
        BaseSemanticAnalyzer.TableSpec tblSpec = ((TableScanDesc)tableScanOp.getConf()).getTableMetadata().getTableSpec();
        if (tblSpec.specType == BaseSemanticAnalyzer.TableSpec.SpecType.STATIC_PARTITION) {
            if (tblSpec.partHandle != null) {
                confirmedPartns.add(tblSpec.partHandle);
            } else {
                confirmedPartns.addAll(tblSpec.partitions);
            }
        } else if (tblSpec.specType == BaseSemanticAnalyzer.TableSpec.SpecType.DYNAMIC_PARTITION) {
            confirmedPartns.addAll(tblSpec.partitions);
        }
        return confirmedPartns;
    }

    public static List<String> getPartitionColumns(TableScanOperator tableScanOp) {
        BaseSemanticAnalyzer.TableSpec tblSpec = ((TableScanDesc)tableScanOp.getConf()).getTableMetadata().getTableSpec();
        if (tblSpec.tableHandle.isPartitioned()) {
            return new ArrayList<String>(tblSpec.getPartSpec().keySet());
        }
        return Collections.emptyList();
    }

    public static Set<String> findAliases(MapWork work, Operator<?> startOp) {
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        for (Operator<?> topOp : GenMapRedUtils.findTopOps(startOp, null)) {
            String alias = GenMapRedUtils.findAlias(work, topOp);
            if (alias == null) continue;
            aliases.add(alias);
        }
        return aliases;
    }

    public static Set<Operator<?>> findTopOps(Operator<?> startOp, final Class<?> clazz) {
        final LinkedHashSet operators = new LinkedHashSet();
        OperatorUtils.iterateParents(startOp, new NodeUtils.Function<Operator<?>>(){

            @Override
            public void apply(Operator<?> argument) {
                if (argument.getNumParent() == 0 && (clazz == null || clazz.isInstance(argument))) {
                    operators.add(argument);
                }
            }
        });
        return operators;
    }

    public static String findAlias(MapWork work, Operator<?> operator) {
        for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : work.getAliasToWork().entrySet()) {
            if (entry.getValue() != operator) continue;
            return entry.getKey();
        }
        return null;
    }

    static void usePartitionColumns(Properties properties, List<String> partColNames) {
        Preconditions.checkArgument(!partColNames.isEmpty(), "No partition columns provided to use");
        Preconditions.checkArgument(new HashSet<String>(partColNames).size() == partColNames.size(), "Partition columns should be unique: " + partColNames);
        Object[] partNames = properties.getProperty("partition_columns").split("/");
        Object[] partTypes = properties.getProperty("partition_columns.types").split(":");
        Preconditions.checkArgument(partNames.length == partTypes.length, "Partition Names, " + Arrays.toString(partNames) + " don't match partition Types, " + Arrays.toString(partTypes));
        HashMap<Object, Object> typeMap = new HashMap<Object, Object>();
        for (int i = 0; i < partNames.length; ++i) {
            String previousValue = (String)typeMap.put(partNames[i], partTypes[i]);
            Preconditions.checkArgument(previousValue == null, "Partition columns configuration is inconsistent. There are duplicates in partition column names: " + partNames);
        }
        StringBuilder partNamesBuf = new StringBuilder();
        StringBuilder partTypesBuf = new StringBuilder();
        for (String partName : partColNames) {
            partNamesBuf.append(partName).append('/');
            String partType = (String)typeMap.get(partName);
            if (partType == null) {
                throw new RuntimeException("Type information for partition column " + partName + " is missing.");
            }
            partTypesBuf.append(partType).append(':');
        }
        partNamesBuf.setLength(partNamesBuf.length() - 1);
        partTypesBuf.setLength(partTypesBuf.length() - 1);
        properties.setProperty("partition_columns", partNamesBuf.toString());
        properties.setProperty("partition_columns.types", partTypesBuf.toString());
    }

    private GenMapRedUtils() {
    }
}

