/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ConstantVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorFilterDesc;

public class VectorFilterOperator
extends FilterOperator
implements VectorizationOperator {
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    private VectorFilterDesc vectorDesc;
    private VectorExpression predicateExpression = null;
    private transient int[] temporarySelected;
    private transient int filterMode = 0;

    public VectorFilterOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        this(ctx);
        this.conf = (FilterDesc)conf;
        this.vContext = vContext;
        this.vectorDesc = (VectorFilterDesc)vectorDesc;
        this.predicateExpression = this.vectorDesc.getPredicateExpression();
    }

    @VisibleForTesting
    public VectorFilterOperator() {
    }

    public VectorFilterOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        VectorExpression.doTransientInit(this.predicateExpression);
        try {
            this.heartbeatInterval = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVESENDHEARTBEAT);
            this.predicateExpression.init(hconf);
        }
        catch (Throwable e) {
            throw new HiveException(e);
        }
        if (this.predicateExpression instanceof ConstantVectorExpression) {
            ConstantVectorExpression cve = (ConstantVectorExpression)this.predicateExpression;
            this.filterMode = cve.getLongValue() == 1L ? 1 : -1;
        }
        this.temporarySelected = new int[1024];
    }

    public void setFilterCondition(VectorExpression expr) {
        this.predicateExpression = expr;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        VectorizedRowBatch vrg = (VectorizedRowBatch)row;
        System.arraycopy(vrg.selected, 0, this.temporarySelected, 0, vrg.size);
        int[] selectedBackup = vrg.selected;
        vrg.selected = this.temporarySelected;
        int sizeBackup = vrg.size;
        boolean selectedInUseBackup = vrg.selectedInUse;
        switch (this.filterMode) {
            case 0: {
                this.predicateExpression.evaluate(vrg);
                break;
            }
            case -1: {
                vrg.size = 0;
                break;
            }
        }
        if (vrg.size > 0) {
            this.forward(vrg, null, true);
        }
        vrg.selected = selectedBackup;
        vrg.size = sizeBackup;
        vrg.selectedInUse = selectedInUseBackup;
    }

    public static String getOperatorName() {
        return "FIL";
    }

    public VectorExpression getPredicateExpression() {
        return this.predicateExpression;
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }
}

