/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import hive.com.google.common.base.Preconditions;
import hive.org.apache.commons.lang.ArrayUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.ql.exec.tez.HostAffinitySplitLocationProvider;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.slf4j.Logger;

public class Utils {
    public static SplitLocationProvider getSplitLocationProvider(Configuration conf, Logger LOG) throws IOException {
        return Utils.getSplitLocationProvider(conf, true, LOG);
    }

    public static SplitLocationProvider getSplitLocationProvider(Configuration conf, boolean useCacheAffinity, Logger LOG) throws IOException {
        Object splitLocationProvider;
        boolean useCustomLocations = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_MODE).equals("llap") && HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_CLIENT_CONSISTENT_SPLITS) && useCacheAffinity;
        LOG.info("SplitGenerator using llap affinitized locations: " + useCustomLocations);
        if (useCustomLocations) {
            LlapRegistryService serviceRegistry = LlapRegistryService.getClient(conf);
            LOG.info("Using LLAP instance " + serviceRegistry.getApplicationId());
            Collection<LlapServiceInstance> serviceInstances = serviceRegistry.getInstances().getAllInstancesOrdered(true);
            Preconditions.checkArgument(!serviceInstances.isEmpty(), "No running LLAP daemons! Please check LLAP service status and zookeeper configuration");
            ArrayList<String> locations = new ArrayList<String>(serviceInstances.size());
            for (LlapServiceInstance serviceInstance : serviceInstances) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding " + serviceInstance.getWorkerIdentity() + " with hostname=" + serviceInstance.getHost() + " to list for split locations");
                }
                locations.add(serviceInstance.getHost());
            }
            splitLocationProvider = new HostAffinitySplitLocationProvider(locations);
        } else {
            splitLocationProvider = new SplitLocationProvider(){

                public String[] getLocations(InputSplit split) throws IOException {
                    if (split == null) {
                        return null;
                    }
                    String[] locations = split.getLocations();
                    if (locations != null && locations.length == 1 && "localhost".equals(locations[0])) {
                        return ArrayUtils.EMPTY_STRING_ARRAY;
                    }
                    return locations;
                }
            };
        }
        return splitLocationProvider;
    }
}

