/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.cache;

import hive.org.apache.commons.lang.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.cache.SharedCache;

public class CacheUtils {
    private static final String delimit = "\u0001";

    public static String buildCatalogKey(String catName) {
        return catName;
    }

    public static String buildDbKey(String catName, String dbName) {
        return CacheUtils.buildKey(catName.toLowerCase(), dbName.toLowerCase());
    }

    public static String buildPartitionCacheKey(List<String> partVals) {
        if (partVals == null || partVals.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)delimit, partVals);
    }

    public static String buildTableKey(String catName, String dbName, String tableName) {
        return CacheUtils.buildKey(catName.toLowerCase(), dbName.toLowerCase(), tableName.toLowerCase());
    }

    public static String buildTableColKey(String catName, String dbName, String tableName, String colName) {
        return CacheUtils.buildKey(catName, dbName, tableName, colName);
    }

    private static String buildKey(String ... elements) {
        return StringUtils.join((Object[])elements, delimit);
    }

    public static String[] splitDbName(String key) {
        String[] names = key.split(delimit);
        assert (names.length == 2);
        return names;
    }

    public static String buildPartitonColStatsCacheKey(List<String> partVals, String colName) {
        return CacheUtils.buildPartitionCacheKey(partVals) + delimit + colName;
    }

    static Table assemble(SharedCache.TableWrapper wrapper, SharedCache sharedCache) {
        Table t = wrapper.getTable().deepCopy();
        if (wrapper.getSdHash() != null) {
            StorageDescriptor sdCopy = sharedCache.getSdFromCache(wrapper.getSdHash()).deepCopy();
            if (sdCopy.getBucketCols() == null) {
                sdCopy.setBucketCols(Collections.emptyList());
            }
            if (sdCopy.getSortCols() == null) {
                sdCopy.setSortCols(Collections.emptyList());
            }
            if (sdCopy.getSkewedInfo() == null) {
                sdCopy.setSkewedInfo(new SkewedInfo(Collections.emptyList(), Collections.emptyList(), Collections.emptyMap()));
            }
            sdCopy.setLocation(wrapper.getLocation());
            sdCopy.setParameters(wrapper.getParameters());
            t.setSd(sdCopy);
        }
        return t;
    }

    static Partition assemble(SharedCache.PartitionWrapper wrapper, SharedCache sharedCache) {
        Partition p = wrapper.getPartition().deepCopy();
        if (wrapper.getSdHash() != null) {
            StorageDescriptor sdCopy = sharedCache.getSdFromCache(wrapper.getSdHash()).deepCopy();
            if (sdCopy.getBucketCols() == null) {
                sdCopy.setBucketCols(Collections.emptyList());
            }
            if (sdCopy.getSortCols() == null) {
                sdCopy.setSortCols(Collections.emptyList());
            }
            if (sdCopy.getSkewedInfo() == null) {
                sdCopy.setSkewedInfo(new SkewedInfo(Collections.emptyList(), Collections.emptyList(), Collections.emptyMap()));
            }
            sdCopy.setLocation(wrapper.getLocation());
            sdCopy.setParameters(wrapper.getParameters());
            p.setSd(sdCopy);
        }
        return p;
    }

    public static boolean matches(String name, String pattern) {
        String[] subpatterns;
        for (String subpattern : subpatterns = pattern.trim().split("\\|")) {
            subpattern = "(?i)" + subpattern.replaceAll("\\?", ".{1}").replaceAll("\\*", ".*").replaceAll("\\^", "\\\\^").replaceAll("\\$", "\\\\$");
            if (!Pattern.matches(subpattern, org.apache.hadoop.hive.metastore.utils.StringUtils.normalizeIdentifier(name))) continue;
            return true;
        }
        return false;
    }
}

