/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import hive.com.google.common.cache.CacheBuilder;
import hive.com.google.common.cache.CacheLoader;
import hive.com.google.common.cache.LoadingCache;

public class LlapNodeId {
    private static final LoadingCache<LlapNodeId, LlapNodeId> CACHE = CacheBuilder.newBuilder().softValues().build(new CacheLoader<LlapNodeId, LlapNodeId>(){

        @Override
        public LlapNodeId load(LlapNodeId key) throws Exception {
            return key;
        }
    });
    private final String hostname;
    private final int port;

    public static LlapNodeId getInstance(String hostname, int port) {
        return CACHE.getUnchecked(new LlapNodeId(hostname, port));
    }

    private LlapNodeId(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LlapNodeId that = (LlapNodeId)o;
        if (this.port != that.port) {
            return false;
        }
        return this.hostname.equals(that.hostname);
    }

    public int hashCode() {
        int result = this.hostname.hashCode();
        result = 1009 * result + this.port;
        return result;
    }

    public String toString() {
        return this.hostname + ":" + this.port;
    }
}

