/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.it.unimi.dsi.fastutil;

import hive.org.apache.parquet.it.unimi.dsi.fastutil.Swapper;
import hive.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntComparator;

public class Arrays {
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;

    private Arrays() {
    }

    public static void ensureFromTo(int arrayLength, int from, int to) {
        if (from < 0) {
            throw new ArrayIndexOutOfBoundsException("Start index (" + from + ") is negative");
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        if (to > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("End index (" + to + ") is greater than array length (" + arrayLength + ")");
        }
    }

    public static void ensureOffsetLength(int arrayLength, int offset, int length) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length (" + length + ") is negative");
        }
        if (offset + length > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("Last index (" + (offset + length) + ") is greater than array length (" + arrayLength + ")");
        }
    }

    private static void inPlaceMerge(int from, int mid, int to, IntComparator comp, Swapper swapper) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(mid, from) < 0) {
                swapper.swap(from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = Arrays.lowerBound(mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = Arrays.upperBound(from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                swapper.swap(first1++, last1);
            }
        }
        mid = firstCut + (secondCut - mid);
        Arrays.inPlaceMerge(from, firstCut, mid, comp, swapper);
        Arrays.inPlaceMerge(mid, secondCut, to, comp, swapper);
    }

    private static int lowerBound(int from, int to, int pos, IntComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(middle, pos) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static int upperBound(int from, int mid, int pos, IntComparator comp) {
        int len = mid - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(pos, middle) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    private static int med3(int a, int b, int c, IntComparator comp) {
        int ab = comp.compare(a, b);
        int ac = comp.compare(a, c);
        int bc = comp.compare(b, c);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void mergeSort(int from, int to, IntComparator c, Swapper swapper) {
        int length = to - from;
        if (length < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && c.compare(j - 1, j) > 0; --j) {
                    swapper.swap(j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        Arrays.mergeSort(from, mid, c, swapper);
        Arrays.mergeSort(mid, to, c, swapper);
        if (c.compare(mid - 1, mid) <= 0) {
            return;
        }
        Arrays.inPlaceMerge(from, mid, to, c, swapper);
    }

    public static void quickSort(int from, int to, IntComparator comp, Swapper swapper) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && comp.compare(j - 1, j) > 0; --j) {
                    swapper.swap(j, j - 1);
                }
            }
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 40) {
                int s = len / 8;
                l = Arrays.med3(l, l + s, l + 2 * s, comp);
                m = Arrays.med3(m - s, m, m + s, comp);
                n = Arrays.med3(n - 2 * s, n - s, n, comp);
            }
            m = Arrays.med3(l, m, n, comp);
        }
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(b, m)) <= 0) {
                if (comparison == 0) {
                    if (a == m) {
                        m = b;
                    } else if (b == m) {
                        m = a;
                    }
                    swapper.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(c, m)) >= 0) {
                if (comparison == 0) {
                    if (c == m) {
                        m = d;
                    } else if (d == m) {
                        m = c;
                    }
                    swapper.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            if (b == m) {
                m = d;
            } else if (c == m) {
                m = c;
            }
            swapper.swap(b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        Arrays.vecSwap(swapper, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Arrays.vecSwap(swapper, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Arrays.quickSort(from, from + s, comp, swapper);
        }
        if ((s = d - c) > 1) {
            Arrays.quickSort(n - s, n, comp, swapper);
        }
    }

    private static void vecSwap(Swapper swapper, int from, int l, int s) {
        int i = 0;
        while (i < s) {
            swapper.swap(from, l);
            ++i;
            ++from;
            ++l;
        }
    }
}

