/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.values.plain;

import hive.org.apache.parquet.bytes.BytesInput;
import hive.org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import hive.org.apache.parquet.bytes.LittleEndianDataOutputStream;
import hive.org.apache.parquet.column.Encoding;
import hive.org.apache.parquet.column.values.ValuesWriter;
import hive.org.apache.parquet.column.values.plain.PlainValuesWriter;
import hive.org.apache.parquet.io.ParquetEncodingException;
import hive.org.apache.parquet.io.api.Binary;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedLenByteArrayPlainValuesWriter
extends ValuesWriter {
    private static final Logger LOG = LoggerFactory.getLogger(PlainValuesWriter.class);
    private CapacityByteArrayOutputStream arrayOut;
    private LittleEndianDataOutputStream out;
    private int length;

    public FixedLenByteArrayPlainValuesWriter(int length, int initialSize, int pageSize) {
        this.length = length;
        this.arrayOut = new CapacityByteArrayOutputStream(initialSize, pageSize);
        this.out = new LittleEndianDataOutputStream(this.arrayOut);
    }

    @Override
    public final void writeBytes(Binary v) {
        if (v.length() != this.length) {
            throw new IllegalArgumentException("Fixed Binary size " + v.length() + " does not match field type length " + this.length);
        }
        try {
            v.writeTo(this.out);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write fixed bytes", e);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.arrayOut.size();
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page", e);
        }
        LOG.debug("writing a buffer of size {}", (Object)this.arrayOut.size());
        return BytesInput.from(this.arrayOut);
    }

    @Override
    public void reset() {
        this.arrayOut.reset();
    }

    @Override
    public long getAllocatedSize() {
        return this.arrayOut.getCapacity();
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.PLAIN;
    }

    @Override
    public String memUsageString(String prefix) {
        return this.arrayOut.memUsageString(prefix + " PLAIN");
    }
}

