/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column;

import hive.org.apache.parquet.Preconditions;
import hive.org.apache.parquet.bytes.BytesUtils;
import hive.org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import hive.org.apache.parquet.column.ColumnDescriptor;
import hive.org.apache.parquet.column.ColumnWriteStore;
import hive.org.apache.parquet.column.Encoding;
import hive.org.apache.parquet.column.impl.ColumnWriteStoreV1;
import hive.org.apache.parquet.column.impl.ColumnWriteStoreV2;
import hive.org.apache.parquet.column.page.PageWriteStore;
import hive.org.apache.parquet.column.values.ValuesWriter;
import hive.org.apache.parquet.column.values.boundedint.DevNullValuesWriter;
import hive.org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import hive.org.apache.parquet.column.values.deltastrings.DeltaByteArrayWriter;
import hive.org.apache.parquet.column.values.dictionary.DictionaryValuesWriter;
import hive.org.apache.parquet.column.values.fallback.FallbackValuesWriter;
import hive.org.apache.parquet.column.values.plain.BooleanPlainValuesWriter;
import hive.org.apache.parquet.column.values.plain.FixedLenByteArrayPlainValuesWriter;
import hive.org.apache.parquet.column.values.plain.PlainValuesWriter;
import hive.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import hive.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import hive.org.apache.parquet.schema.MessageType;

public class ParquetProperties {
    public static final int DEFAULT_PAGE_SIZE = 0x100000;
    public static final int DEFAULT_DICTIONARY_PAGE_SIZE = 0x100000;
    public static final boolean DEFAULT_IS_DICTIONARY_ENABLED = true;
    public static final WriterVersion DEFAULT_WRITER_VERSION = WriterVersion.PARQUET_1_0;
    public static final boolean DEFAULT_ESTIMATE_ROW_COUNT_FOR_PAGE_SIZE_CHECK = true;
    public static final int DEFAULT_MINIMUM_RECORD_COUNT_FOR_CHECK = 100;
    public static final int DEFAULT_MAXIMUM_RECORD_COUNT_FOR_CHECK = 10000;
    private static final int MIN_SLAB_SIZE = 64;
    private final int pageSizeThreshold;
    private final int dictionaryPageSizeThreshold;
    private final WriterVersion writerVersion;
    private final boolean enableDictionary;
    private final int minRowCountForPageSizeCheck;
    private final int maxRowCountForPageSizeCheck;
    private final boolean estimateNextSizeCheck;
    private final int initialSlabSize;

    private ParquetProperties(WriterVersion writerVersion, int pageSize, int dictPageSize, boolean enableDict, int minRowCountForPageSizeCheck, int maxRowCountForPageSizeCheck, boolean estimateNextSizeCheck) {
        this.pageSizeThreshold = pageSize;
        this.initialSlabSize = CapacityByteArrayOutputStream.initialSlabSizeHeuristic(64, this.pageSizeThreshold, 10);
        this.dictionaryPageSizeThreshold = dictPageSize;
        this.writerVersion = writerVersion;
        this.enableDictionary = enableDict;
        this.minRowCountForPageSizeCheck = minRowCountForPageSizeCheck;
        this.maxRowCountForPageSizeCheck = maxRowCountForPageSizeCheck;
        this.estimateNextSizeCheck = estimateNextSizeCheck;
    }

    public ValuesWriter newRepetitionLevelWriter(ColumnDescriptor path) {
        return this.newColumnDescriptorValuesWriter(path.getMaxRepetitionLevel());
    }

    public ValuesWriter newDefinitionLevelWriter(ColumnDescriptor path) {
        return this.newColumnDescriptorValuesWriter(path.getMaxDefinitionLevel());
    }

    private ValuesWriter newColumnDescriptorValuesWriter(int maxLevel) {
        if (maxLevel == 0) {
            return new DevNullValuesWriter();
        }
        return new RunLengthBitPackingHybridValuesWriter(BytesUtils.getWidthFromMaxInt(maxLevel), 64, this.pageSizeThreshold);
    }

    public RunLengthBitPackingHybridEncoder newRepetitionLevelEncoder(ColumnDescriptor path) {
        return this.newLevelEncoder(path.getMaxRepetitionLevel());
    }

    public RunLengthBitPackingHybridEncoder newDefinitionLevelEncoder(ColumnDescriptor path) {
        return this.newLevelEncoder(path.getMaxDefinitionLevel());
    }

    private RunLengthBitPackingHybridEncoder newLevelEncoder(int maxLevel) {
        return new RunLengthBitPackingHybridEncoder(BytesUtils.getWidthFromMaxInt(maxLevel), 64, this.pageSizeThreshold);
    }

    private ValuesWriter plainWriter(ColumnDescriptor path) {
        switch (path.getType()) {
            case BOOLEAN: {
                return new BooleanPlainValuesWriter();
            }
            case INT96: {
                return new FixedLenByteArrayPlainValuesWriter(12, this.initialSlabSize, this.pageSizeThreshold);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new FixedLenByteArrayPlainValuesWriter(path.getTypeLength(), this.initialSlabSize, this.pageSizeThreshold);
            }
            case BINARY: 
            case INT32: 
            case INT64: 
            case DOUBLE: 
            case FLOAT: {
                return new PlainValuesWriter(this.initialSlabSize, this.pageSizeThreshold);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
    }

    private DictionaryValuesWriter dictionaryWriter(ColumnDescriptor path) {
        Encoding encodingForDictionaryPage;
        Encoding encodingForDataPage;
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                encodingForDataPage = Encoding.PLAIN_DICTIONARY;
                encodingForDictionaryPage = Encoding.PLAIN_DICTIONARY;
                break;
            }
            case PARQUET_2_0: {
                encodingForDataPage = Encoding.RLE_DICTIONARY;
                encodingForDictionaryPage = Encoding.PLAIN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown version: " + (Object)((Object)this.writerVersion));
            }
        }
        switch (path.getType()) {
            case BOOLEAN: {
                throw new IllegalArgumentException("no dictionary encoding for BOOLEAN");
            }
            case BINARY: {
                return new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case INT32: {
                return new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case INT64: {
                return new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case INT96: {
                return new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(this.dictionaryPageSizeThreshold, 12, encodingForDataPage, encodingForDictionaryPage);
            }
            case DOUBLE: {
                return new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case FLOAT: {
                return new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(this.dictionaryPageSizeThreshold, encodingForDataPage, encodingForDictionaryPage);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(this.dictionaryPageSizeThreshold, path.getTypeLength(), encodingForDataPage, encodingForDictionaryPage);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
    }

    private ValuesWriter writerToFallbackTo(ColumnDescriptor path) {
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                return this.plainWriter(path);
            }
            case PARQUET_2_0: {
                switch (path.getType()) {
                    case BOOLEAN: {
                        return new RunLengthBitPackingHybridValuesWriter(1, this.initialSlabSize, this.pageSizeThreshold);
                    }
                    case FIXED_LEN_BYTE_ARRAY: 
                    case BINARY: {
                        return new DeltaByteArrayWriter(this.initialSlabSize, this.pageSizeThreshold);
                    }
                    case INT32: {
                        return new DeltaBinaryPackingValuesWriter(this.initialSlabSize, this.pageSizeThreshold);
                    }
                    case INT96: 
                    case INT64: 
                    case DOUBLE: 
                    case FLOAT: {
                        return this.plainWriter(path);
                    }
                }
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
            }
        }
        throw new IllegalArgumentException("Unknown version: " + (Object)((Object)this.writerVersion));
    }

    private ValuesWriter dictWriterWithFallBack(ColumnDescriptor path) {
        ValuesWriter writerToFallBackTo = this.writerToFallbackTo(path);
        if (this.enableDictionary) {
            return FallbackValuesWriter.of(this.dictionaryWriter(path), writerToFallBackTo);
        }
        return writerToFallBackTo;
    }

    public ValuesWriter newValuesWriter(ColumnDescriptor path) {
        switch (path.getType()) {
            case BOOLEAN: {
                return this.writerToFallbackTo(path);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                if (this.writerVersion == WriterVersion.PARQUET_2_0) {
                    return this.dictWriterWithFallBack(path);
                }
                return this.writerToFallbackTo(path);
            }
            case INT96: 
            case BINARY: 
            case INT32: 
            case INT64: 
            case DOUBLE: 
            case FLOAT: {
                return this.dictWriterWithFallBack(path);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
    }

    public int getPageSizeThreshold() {
        return this.pageSizeThreshold;
    }

    public int getDictionaryPageSizeThreshold() {
        return this.dictionaryPageSizeThreshold;
    }

    public WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    public boolean isEnableDictionary() {
        return this.enableDictionary;
    }

    public ColumnWriteStore newColumnWriteStore(MessageType schema, PageWriteStore pageStore) {
        switch (this.writerVersion) {
            case PARQUET_1_0: {
                return new ColumnWriteStoreV1(pageStore, this);
            }
            case PARQUET_2_0: {
                return new ColumnWriteStoreV2(schema, pageStore, this);
            }
        }
        throw new IllegalArgumentException("unknown version " + (Object)((Object)this.writerVersion));
    }

    public int getMinRowCountForPageSizeCheck() {
        return this.minRowCountForPageSizeCheck;
    }

    public int getMaxRowCountForPageSizeCheck() {
        return this.maxRowCountForPageSizeCheck;
    }

    public boolean estimateNextSizeCheck() {
        return this.estimateNextSizeCheck;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder copy(ParquetProperties toCopy) {
        return new Builder(toCopy);
    }

    public static class Builder {
        private int pageSize = 0x100000;
        private int dictPageSize = 0x100000;
        private boolean enableDict = true;
        private WriterVersion writerVersion = DEFAULT_WRITER_VERSION;
        private int minRowCountForPageSizeCheck = 100;
        private int maxRowCountForPageSizeCheck = 10000;
        private boolean estimateNextSizeCheck = true;

        private Builder() {
        }

        private Builder(ParquetProperties toCopy) {
            this.enableDict = toCopy.enableDictionary;
            this.dictPageSize = toCopy.dictionaryPageSizeThreshold;
            this.writerVersion = toCopy.writerVersion;
            this.minRowCountForPageSizeCheck = toCopy.minRowCountForPageSizeCheck;
            this.maxRowCountForPageSizeCheck = toCopy.maxRowCountForPageSizeCheck;
            this.estimateNextSizeCheck = toCopy.estimateNextSizeCheck;
        }

        public Builder withPageSize(int pageSize) {
            Preconditions.checkArgument(pageSize > 0, "Invalid page size (negative): %s", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder withDictionaryEncoding(boolean enableDictionary) {
            this.enableDict = enableDictionary;
            return this;
        }

        public Builder withDictionaryPageSize(int dictionaryPageSize) {
            Preconditions.checkArgument(dictionaryPageSize > 0, "Invalid dictionary page size (negative): %s", dictionaryPageSize);
            this.dictPageSize = dictionaryPageSize;
            return this;
        }

        public Builder withWriterVersion(WriterVersion version) {
            this.writerVersion = version;
            return this;
        }

        public Builder withMinRowCountForPageSizeCheck(int min) {
            Preconditions.checkArgument(min > 0, "Invalid row count for page size check (negative): %s", min);
            this.minRowCountForPageSizeCheck = min;
            return this;
        }

        public Builder withMaxRowCountForPageSizeCheck(int max) {
            Preconditions.checkArgument(max > 0, "Invalid row count for page size check (negative): %s", max);
            this.maxRowCountForPageSizeCheck = max;
            return this;
        }

        public Builder estimateRowCountForPageSizeCheck(boolean estimateNextSizeCheck) {
            this.estimateNextSizeCheck = estimateNextSizeCheck;
            return this;
        }

        public ParquetProperties build() {
            return new ParquetProperties(this.writerVersion, this.pageSize, this.dictPageSize, this.enableDict, this.minRowCountForPageSizeCheck, this.maxRowCountForPageSizeCheck, this.estimateNextSizeCheck);
        }
    }

    public static enum WriterVersion {
        PARQUET_1_0("v1"),
        PARQUET_2_0("v2");

        private final String shortName;

        private WriterVersion(String shortname) {
            this.shortName = shortname;
        }

        public static WriterVersion fromString(String name) {
            for (WriterVersion v : WriterVersion.values()) {
                if (!v.shortName.equals(name)) continue;
                return v;
            }
            return WriterVersion.valueOf(name);
        }
    }
}

