/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.mapreduce;

import hive.org.apache.avro.Schema;
import hive.org.apache.avro.mapred.AvroKey;
import hive.org.apache.avro.mapreduce.AvroJob;
import hive.org.apache.avro.mapreduce.AvroKeyRecordReader;
import java.io.IOException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroKeyInputFormat<T>
extends FileInputFormat<AvroKey<T>, NullWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(AvroKeyInputFormat.class);

    public RecordReader<AvroKey<T>, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Schema readerSchema = AvroJob.getInputKeySchema(context.getConfiguration());
        if (null == readerSchema) {
            LOG.warn("Reader schema was not set. Use AvroJob.setInputKeySchema() if desired.");
            LOG.info("Using a reader schema equal to the writer schema.");
        }
        return new AvroKeyRecordReader(readerSchema);
    }
}

