/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.mapred;

import hive.org.apache.avro.Schema;
import hive.org.apache.avro.generic.GenericData;
import hive.org.apache.avro.io.BinaryDecoder;
import hive.org.apache.avro.io.BinaryEncoder;
import hive.org.apache.avro.io.DatumReader;
import hive.org.apache.avro.io.DatumWriter;
import hive.org.apache.avro.io.DecoderFactory;
import hive.org.apache.avro.io.EncoderFactory;
import hive.org.apache.avro.mapred.AvroJob;
import hive.org.apache.avro.mapred.AvroKey;
import hive.org.apache.avro.mapred.AvroValue;
import hive.org.apache.avro.mapred.AvroWrapper;
import hive.org.apache.avro.mapred.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class AvroSerialization<T>
extends Configured
implements Serialization<AvroWrapper<T>> {
    private static final DecoderFactory FACTORY = DecoderFactory.get();

    public boolean accept(Class<?> c) {
        return AvroWrapper.class.isAssignableFrom(c);
    }

    public Deserializer<AvroWrapper<T>> getDeserializer(Class<AvroWrapper<T>> c) {
        Configuration conf = this.getConf();
        boolean isKey = AvroKey.class.isAssignableFrom(c);
        Schema schema = isKey ? Pair.getKeySchema(AvroJob.getMapOutputSchema(conf)) : Pair.getValueSchema(AvroJob.getMapOutputSchema(conf));
        GenericData dataModel = AvroJob.createMapOutputDataModel(conf);
        DatumReader datumReader = dataModel.createDatumReader(schema);
        return new AvroWrapperDeserializer(datumReader, isKey);
    }

    public Serializer<AvroWrapper<T>> getSerializer(Class<AvroWrapper<T>> c) {
        boolean isFinalOutput = c.equals(AvroWrapper.class);
        Configuration conf = this.getConf();
        Schema schema = isFinalOutput ? AvroJob.getOutputSchema(conf) : (AvroKey.class.isAssignableFrom(c) ? Pair.getKeySchema(AvroJob.getMapOutputSchema(conf)) : Pair.getValueSchema(AvroJob.getMapOutputSchema(conf)));
        GenericData dataModel = AvroJob.createDataModel(conf);
        return new AvroWrapperSerializer(dataModel.createDatumWriter(schema));
    }

    private class AvroWrapperSerializer
    implements Serializer<AvroWrapper<T>> {
        private DatumWriter<T> writer;
        private OutputStream out;
        private BinaryEncoder encoder;

        public AvroWrapperSerializer(DatumWriter<T> writer) {
            this.writer = writer;
        }

        public void open(OutputStream out) {
            this.out = out;
            this.encoder = new EncoderFactory().configureBlockSize(512).binaryEncoder(out, null);
        }

        public void serialize(AvroWrapper<T> wrapper) throws IOException {
            this.writer.write(wrapper.datum(), this.encoder);
            this.encoder.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    private class AvroWrapperDeserializer
    implements Deserializer<AvroWrapper<T>> {
        private DatumReader<T> reader;
        private BinaryDecoder decoder;
        private boolean isKey;

        public AvroWrapperDeserializer(DatumReader<T> reader, boolean isKey) {
            this.reader = reader;
            this.isKey = isKey;
        }

        public void open(InputStream in) {
            this.decoder = FACTORY.directBinaryDecoder(in, this.decoder);
        }

        public AvroWrapper<T> deserialize(AvroWrapper<T> wrapper) throws IOException {
            Object datum = this.reader.read(wrapper == null ? null : (Object)wrapper.datum(), this.decoder);
            if (wrapper == null) {
                wrapper = this.isKey ? new AvroKey<Object>(datum) : new AvroValue<Object>(datum);
            } else {
                wrapper.datum(datum);
            }
            return wrapper;
        }

        public void close() throws IOException {
            this.decoder.inputStream().close();
        }
    }
}

