/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid.druid;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.store.druid.common.DruidFilter;
import org.apache.drill.exec.store.druid.druid.ScanQuery;

public class ScanQueryBuilder {
    private static final ObjectMapper objectMapper = JacksonUtils.createObjectMapper();

    public ScanQuery build(String datasource, List<String> columns, DruidFilter druidFilter, BigInteger nextOffset, int queryThreshold, String minTime, String maxTime) throws JsonProcessingException {
        ArrayList<JsonNode> userInputIntervals = druidFilter == null ? new ArrayList() : this.parseIntervalsFromFilter(druidFilter.toJson());
        List<String> queryIntervals = this.getQueryIntervals(userInputIntervals, minTime, maxTime);
        ObjectNode finalFilter = druidFilter == null ? null : (ObjectNode)objectMapper.readTree(this.removeIntervalFilter(druidFilter.toJson(), userInputIntervals));
        return new ScanQuery(datasource, columns, finalFilter, queryIntervals, nextOffset, queryThreshold);
    }

    private List<JsonNode> parseIntervalsFromFilter(String filter) throws JsonProcessingException {
        JsonNode filterNode = objectMapper.readTree(filter);
        return filterNode.findValues("eventInterval");
    }

    private List<String> getQueryIntervals(List<JsonNode> userInputIntervals, String minTime, String maxTime) {
        if (userInputIntervals.isEmpty()) {
            String interval = String.format("%s/%s", minTime, maxTime);
            return Stream.of(interval).collect(Collectors.toList());
        }
        JsonNode firstIntervalNode = userInputIntervals.get(0);
        String interval = firstIntervalNode.asText();
        return Stream.of(interval).collect(Collectors.toList());
    }

    private String removeIntervalFilter(String filter, List<JsonNode> userInputIntervals) {
        for (JsonNode intervalNode : userInputIntervals) {
            String interval = intervalNode.asText();
            String intervalSubString1 = ",{\"eventInterval\":\"" + interval + "\"}";
            String intervalSubString2 = "{\"eventInterval\":\"" + interval + "\"},";
            filter = filter.replace(intervalSubString1, "");
            filter = filter.replace(intervalSubString2, "");
        }
        return filter;
    }
}

