/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import java.util.List;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.FilterPrel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.druid.DruidFilterBuilder;
import org.apache.drill.exec.store.druid.DruidGroupScan;
import org.apache.drill.exec.store.druid.DruidScanSpec;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class DruidPushDownFilterForScan
extends StoragePluginOptimizerRule {
    public static final StoragePluginOptimizerRule INSTANCE = new DruidPushDownFilterForScan();

    private DruidPushDownFilterForScan() {
        super(RelOptHelper.some(FilterPrel.class, (RelOptRuleOperand)RelOptHelper.any(ScanPrel.class), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "DruidPushDownFilterForScan");
    }

    public void onMatch(RelOptRuleCall relOptRuleCall) {
        ScanPrel scan = (ScanPrel)relOptRuleCall.rel(1);
        FilterPrel filter = (FilterPrel)relOptRuleCall.rel(0);
        RexNode condition = filter.getCondition();
        DruidGroupScan groupScan = (DruidGroupScan)scan.getGroupScan();
        if (groupScan.isFilterPushedDown()) {
            return;
        }
        LogicalExpression conditionExp = DrillOptiq.toDrill((DrillParseContext)new DrillParseContext(PrelUtil.getPlannerSettings((RelOptPlanner)relOptRuleCall.getPlanner())), (RelNode)scan, (RexNode)condition);
        DruidFilterBuilder druidFilterBuilder = new DruidFilterBuilder(groupScan, conditionExp);
        DruidScanSpec newScanSpec = druidFilterBuilder.parseTree();
        if (newScanSpec == null) {
            return;
        }
        DruidGroupScan newGroupsScan = new DruidGroupScan(groupScan.getUserName(), groupScan.getStoragePlugin(), newScanSpec, groupScan.getColumns(), groupScan.getMaxRecordsToRead());
        newGroupsScan.setFilterPushedDown(true);
        ScanPrel newScanPrel = scan.copy(filter.getTraitSet(), (GroupScan)newGroupsScan, filter.getRowType());
        if (druidFilterBuilder.isAllExpressionsConverted()) {
            relOptRuleCall.transformTo((RelNode)newScanPrel);
        } else {
            relOptRuleCall.transformTo(filter.copy(filter.getTraitSet(), (List)ImmutableList.of((Object)newScanPrel)));
        }
    }

    public boolean matches(RelOptRuleCall call) {
        ScanPrel scan = (ScanPrel)call.rel(1);
        if (scan.getGroupScan() instanceof DruidGroupScan) {
            return super.matches(call);
        }
        return false;
    }
}

