/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileVersion;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxLegalHoldPolicy;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.Date;

@BoxResourceType(value="legal_hold_assignment")
public class BoxLegalHoldAssignment
extends BoxResource {
    public static final String TYPE_FILE_VERSION = BoxFileVersion.getResourceType(BoxFileVersion.class);
    public static final String TYPE_FILE = BoxFile.getResourceType(BoxFile.class);
    public static final String TYPE_FOLDER = BoxFolder.getResourceType(BoxFolder.class);
    public static final String TYPE_USER = BoxUser.getResourceType(BoxUser.class);
    public static final URLTemplate ASSIGNMENTS_URL_TEMPLATE = new URLTemplate("legal_hold_policy_assignments");
    public static final URLTemplate LEGAL_HOLD_ASSIGNMENT_URL_TEMPLATE = new URLTemplate("legal_hold_policy_assignments/%s");

    public BoxLegalHoldAssignment(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info create(BoxAPIConnection api, String policyID, String resourceType, String resourceID) {
        BoxLegalHoldAssignment createdAssignment;
        URL url = ASSIGNMENTS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        JsonObject requestJSON = new JsonObject().add("policy_id", policyID).add("assign_to", (JsonValue)new JsonObject().add("type", resourceType).add("id", resourceID));
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
        BoxLegalHoldAssignment boxLegalHoldAssignment = createdAssignment = new BoxLegalHoldAssignment(api, responseJSON.get("id").asString());
        boxLegalHoldAssignment.getClass();
        return boxLegalHoldAssignment.new Info(responseJSON);
    }

    public void delete() {
        URL url = LEGAL_HOLD_ASSIGNMENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = LEGAL_HOLD_ASSIGNMENT_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse((String)response.getJSON()).asObject();
        return new Info(responseJSON);
    }

    public class Info
    extends BoxResource.Info {
        private BoxLegalHoldPolicy.Info legalHold;
        private BoxUser.Info assignedBy;
        private Date assignedAt;
        private Date deletedAt;
        private String assignedToType;
        private String assignedToID;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxLegalHoldAssignment.this;
        }

        public BoxLegalHoldPolicy.Info getLegalHold() {
            return this.legalHold;
        }

        public BoxUser.Info getAssignedBy() {
            return this.assignedBy;
        }

        public Date getAssignedAt() {
            return this.assignedAt;
        }

        public Date getDeletedAt() {
            return this.deletedAt;
        }

        public String getAssignedToType() {
            return this.assignedToType;
        }

        public String getAssignedToID() {
            return this.assignedToID;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("legal_hold_policy")) {
                    JsonObject policyJSON = value.asObject();
                    if (this.legalHold == null) {
                        BoxLegalHoldPolicy policy;
                        String policyID = policyJSON.get("id").asString();
                        BoxLegalHoldPolicy boxLegalHoldPolicy = policy = new BoxLegalHoldPolicy(BoxLegalHoldAssignment.this.getAPI(), policyID);
                        boxLegalHoldPolicy.getClass();
                        this.legalHold = new BoxLegalHoldPolicy.Info(boxLegalHoldPolicy, policyJSON);
                    } else {
                        this.legalHold.update(policyJSON);
                    }
                } else if (memberName.equals("assigned_to")) {
                    JsonObject assignmentJSON = value.asObject();
                    this.assignedToType = assignmentJSON.get("type").asString();
                    this.assignedToID = assignmentJSON.get("id").asString();
                } else if (memberName.equals("assigned_by")) {
                    JsonObject userJSON = value.asObject();
                    if (this.assignedBy == null) {
                        BoxUser user;
                        String userID = userJSON.get("id").asString();
                        BoxUser boxUser = user = new BoxUser(BoxLegalHoldAssignment.this.getAPI(), userID);
                        boxUser.getClass();
                        this.assignedBy = boxUser.new BoxUser.Info(userJSON);
                    } else {
                        this.assignedBy.update(userJSON);
                    }
                } else if (memberName.equals("assigned_at")) {
                    this.assignedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("deleted_at")) {
                    this.deletedAt = BoxDateFormat.parse(value.asString());
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }
}

