/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import org.apache.drill.common.types.TypeProtos;

public abstract class PathSegment {
    protected final Object originalValue;
    protected final TypeProtos.MajorType originalValueType;
    private PathSegment child;
    private int hash;

    public PathSegment(PathSegment child, Object originalValue, TypeProtos.MajorType originalValueType) {
        this.originalValue = originalValue;
        this.originalValueType = originalValueType;
        this.child = child;
    }

    public abstract PathSegment cloneWithNewChild(PathSegment var1);

    public abstract PathSegment clone();

    public Object getOriginalValue() {
        return this.originalValue;
    }

    public TypeProtos.MajorType getOriginalValueType() {
        return this.originalValueType;
    }

    public NameSegment getNameSegment() {
        throw new UnsupportedOperationException();
    }

    public ArraySegment getArraySegment() {
        throw new UnsupportedOperationException();
    }

    public abstract boolean isArray();

    public abstract boolean isNamed();

    public boolean isLastPath() {
        return this.child == null;
    }

    public PathSegment getChild() {
        return this.child;
    }

    void setChild(PathSegment child) {
        this.child = child;
    }

    protected abstract int segmentHashCode();

    protected abstract boolean segmentEquals(PathSegment var1);

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.segmentHashCode();
            this.hash = h += this.child == null ? 0 : 31 * this.child.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathSegment other = (PathSegment)obj;
        if (!this.segmentEquals(other)) {
            return false;
        }
        if (this.child == null) {
            return other.child == null;
        }
        return this.child.equals(other.child);
    }

    public boolean contains(PathSegment otherSeg) {
        if (this == otherSeg) {
            return true;
        }
        if (otherSeg == null) {
            return false;
        }
        if (otherSeg.isArray() || this.isArray()) {
            return true;
        }
        if (this.getClass() != otherSeg.getClass()) {
            return false;
        }
        if (!this.segmentEquals(otherSeg)) {
            return false;
        }
        if (this.child == null || otherSeg.child == null) {
            return true;
        }
        return this.child.contains(otherSeg.child);
    }

    public static final class NameSegment
    extends PathSegment {
        private final String path;

        public NameSegment(CharSequence n, Object originalValue, TypeProtos.MajorType valueType) {
            super(null, originalValue, valueType);
            this.path = n.toString();
        }

        public NameSegment(CharSequence n, PathSegment child) {
            super(child, n.toString(), null);
            this.path = n.toString();
        }

        public NameSegment(CharSequence n) {
            this(n, null);
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public boolean isNamed() {
            return true;
        }

        @Override
        public NameSegment getNameSegment() {
            return this;
        }

        public String toString() {
            return "NameSegment [path=" + this.path + ", getChild()=" + this.getChild() + "]";
        }

        @Override
        public int segmentHashCode() {
            return this.path == null ? 0 : this.path.toLowerCase().hashCode();
        }

        @Override
        public boolean segmentEquals(PathSegment obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameSegment other = (NameSegment)obj;
            if (this.path == null) {
                return other.path == null;
            }
            return this.path.equalsIgnoreCase(other.path);
        }

        public boolean nameEquals(String name) {
            return this.path == null && name == null || this.path != null && this.path.equalsIgnoreCase(name);
        }

        @Override
        public NameSegment clone() {
            NameSegment s = new NameSegment(this.path, this.originalValue, this.originalValueType);
            if (this.getChild() != null) {
                s.setChild(this.getChild().clone());
            }
            return s;
        }

        @Override
        public NameSegment cloneWithNewChild(PathSegment newChild) {
            NameSegment s = new NameSegment(this.path, this.originalValue, this.originalValueType);
            if (this.getChild() != null) {
                s.setChild(this.getChild().cloneWithNewChild(newChild));
            } else {
                s.setChild(newChild);
            }
            return s;
        }
    }

    public static final class ArraySegment
    extends PathSegment {
        private final int index;

        public ArraySegment(String numberAsText, PathSegment child) {
            this(Integer.parseInt(numberAsText), child);
        }

        public ArraySegment(String numberAsText) {
            this(Integer.parseInt(numberAsText), null);
        }

        public ArraySegment(int index, PathSegment child) {
            super(child, index, null);
            this.index = index;
            assert (index >= 0);
        }

        public ArraySegment(PathSegment child) {
            super(child, -1, null);
            this.index = -1;
        }

        public ArraySegment(int index) {
            this(index, null);
            if (index < 0) {
                throw new IllegalArgumentException();
            }
        }

        public ArraySegment(int index, Object originalValue, TypeProtos.MajorType valueType) {
            super(null, originalValue, valueType);
            this.index = index;
        }

        public boolean hasIndex() {
            return this.index != -1;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public boolean isNamed() {
            return false;
        }

        @Override
        public ArraySegment getArraySegment() {
            return this;
        }

        public String toString() {
            return "ArraySegment [index=" + this.index + ", getChild()=" + this.getChild() + "]";
        }

        @Override
        public int segmentHashCode() {
            return this.index;
        }

        @Override
        public boolean segmentEquals(PathSegment obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof ArraySegment) {
                return this.index == ((ArraySegment)obj).getIndex();
            }
            return false;
        }

        @Override
        public PathSegment clone() {
            int index = this.index < 0 ? -1 : this.index;
            ArraySegment seg = new ArraySegment(index, this.originalValue, this.originalValueType);
            if (this.getChild() != null) {
                seg.setChild(this.getChild().clone());
            }
            return seg;
        }

        @Override
        public ArraySegment cloneWithNewChild(PathSegment newChild) {
            int index = this.index < 0 ? -1 : this.index;
            ArraySegment seg = new ArraySegment(index, this.originalValue, this.originalValueType);
            if (this.getChild() != null) {
                seg.setChild(this.getChild().cloneWithNewChild(newChild));
            } else {
                seg.setChild(newChild);
            }
            return seg;
        }
    }
}

