/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;

public interface OutputTypeDeterminer {
    public static final OutputTypeDeterminer FIXED_BIT = new FixedType(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.BIT));
    public static final OutputTypeDeterminer FIXED_INT = new FixedType(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.INT));
    public static final OutputTypeDeterminer FIXED_BIGINT = new FixedType(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.BIGINT));
    public static final OutputTypeDeterminer FIXED_FLOAT4 = new FixedType(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT4));
    public static final OutputTypeDeterminer FIXED_FLOAT8 = new FixedType(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT8));
    public static final OutputTypeDeterminer FIXED_VARCHAR = new FixedType(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR));
    public static final OutputTypeDeterminer FIXED_VARBINARY = new FixedType(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.VARBINARY));
    public static final OutputTypeDeterminer FIXED_VAR16CHAR = new FixedType(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.VAR16CHAR));

    public TypeProtos.MajorType getOutputType(List<LogicalExpression> var1);

    public static class FixedType
    implements OutputTypeDeterminer {
        public TypeProtos.MajorType outputType;

        public FixedType(TypeProtos.MajorType outputType) {
            this.outputType = outputType;
        }

        @Override
        public TypeProtos.MajorType getOutputType(List<LogicalExpression> expressions) {
            return this.outputType;
        }
    }

    public static class NullIfNullType
    implements OutputTypeDeterminer {
        public TypeProtos.MinorType outputMinorType;

        public NullIfNullType(TypeProtos.MinorType outputType) {
            this.outputMinorType = outputType;
        }

        @Override
        public TypeProtos.MajorType getOutputType(List<LogicalExpression> expressions) {
            for (LogicalExpression e : expressions) {
                if (e.getMajorType().getMode() != TypeProtos.DataMode.OPTIONAL) continue;
                return Types.optional((TypeProtos.MinorType)this.outputMinorType);
            }
            return Types.required((TypeProtos.MinorType)this.outputMinorType);
        }
    }

    public static class SameAsAnySoft
    implements OutputTypeDeterminer {
        @Override
        public TypeProtos.MajorType getOutputType(List<LogicalExpression> expressions) {
            for (LogicalExpression e : expressions) {
                if (e.getMajorType().getMode() != TypeProtos.DataMode.OPTIONAL) continue;
                return e.getMajorType();
            }
            return expressions.get(0).getMajorType();
        }
    }

    public static class SameAsFirstInput
    implements OutputTypeDeterminer {
        @Override
        public TypeProtos.MajorType getOutputType(List<LogicalExpression> expressions) {
            return expressions.get(0).getMajorType();
        }
    }
}

